/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.composer;

import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.composer.UIActivityComposerManager;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public abstract class UIActivityComposer
extends UIContainer {
    private static final String SELECT_DOCUMENT_ACTION = "SelectDocument";
    private static final String UI_DOCUMENT_ACTIVITY_COMPOSER = "UIDocActivityComposer";
    private static final String FILE_ALREADY_EXIST = "UIActivityComposer.message.alreadyAttached";
    private UIContainer activityDisplay;
    private UIActivityComposerManager activityComposerManager;
    private boolean isReady = false;
    private boolean isDisplayed = false;

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public void setDisplayed(boolean isDisplayed) {
        this.isDisplayed = isDisplayed;
    }

    public boolean isReadyForPostingActivity() {
        return this.isReady;
    }

    public void setReadyForPostingActivity(boolean isReady) {
        this.isReady = isReady;
    }

    public void setActivityDisplay(UIContainer activityDisplay) {
        this.activityDisplay = activityDisplay;
    }

    public UIContainer getActivityDisplay() {
        return this.activityDisplay;
    }

    public void setActivityComposerManager(UIActivityComposerManager activityComposerManager) {
        this.activityComposerManager = activityComposerManager;
    }

    public UIActivityComposerManager getActivityComposerManager() {
        return this.activityComposerManager;
    }

    public ExoSocialActivity postActivity(UIComposer.PostContext postContext, String postedMessage) throws Exception {
        ExoSocialActivity activity = this.onPostActivity(postContext, postedMessage);
        this.setReadyForPostingActivity(false);
        this.setDisplayed(false);
        this.activityComposerManager.setDefaultActivityComposer();
        return activity;
    }

    protected ExoSocialActivity onPostActivity(UIComposer.PostContext postContext, String postedMessage) throws Exception {
        UIComposer uiComposer = (UIComposer)((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(UIComposer.class);
        this.onPostActivity(postContext, (UIComponent)uiComposer, (WebuiRequestContext)WebuiRequestContext.getCurrentInstance(), postedMessage);
        return null;
    }

    protected abstract void onPostActivity(UIComposer.PostContext var1, UIComponent var2, WebuiRequestContext var3, String var4) throws Exception;

    protected abstract void onClose(Event<UIActivityComposer> var1);

    protected abstract void onSubmit(Event<UIActivityComposer> var1);

    protected abstract void onActivate(Event<UIActivityComposer> var1);

    public static class ActivateActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            Event selectDocEvent;
            WebuiRequestContext ctx = event.getRequestContext();
            UIActivityComposer activityComposer = (UIActivityComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = activityComposer.getActivityComposerManager();
            activityComposerManager.setCurrentActivityComposer(activityComposer);
            if (((Object)((Object)activityComposer)).getClass().getSimpleName().equals(UIActivityComposer.UI_DOCUMENT_ACTIVITY_COMPOSER) && activityComposer.isDisplayed()) {
                UIApplication uiApp = ctx.getUIApplication();
                uiApp.addMessage(new ApplicationMessage(UIActivityComposer.FILE_ALREADY_EXIST, null, 1));
                return;
            }
            activityComposer.onActivate(event);
            if (!((Object)((Object)activityComposer)).getClass().getSimpleName().equals(UIActivityComposer.UI_DOCUMENT_ACTIVITY_COMPOSER)) {
                activityComposer.setDisplayed(true);
            }
            UIComposer composer = activityComposerManager.getUIComposer();
            if (((Object)((Object)activityComposer)).getClass().getSimpleName().equals(UIActivityComposer.UI_DOCUMENT_ACTIVITY_COMPOSER) && (selectDocEvent = activityComposer.createEvent(UIActivityComposer.SELECT_DOCUMENT_ACTION, event.getExecutionPhase(), ctx)) != null) {
                selectDocEvent.broadcast();
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)composer);
        }
    }

    public static class SubmitContentActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            UIActivityComposer activityComposer = (UIActivityComposer)((Object)event.getSource());
            activityComposer.onSubmit(event);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            UIActivityComposer activityComposer = (UIActivityComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = activityComposer.getActivityComposerManager();
            activityComposerManager.setDefaultActivityComposer();
            activityComposer.onClose(event);
            activityComposer.setDisplayed(false);
            WebuiRequestContext requestContext = event.getRequestContext();
            requestContext.getJavascriptManager().require("SHARED/social-ui-activity", "activity").addScripts("activity.responsiveMobile('" + ((UIPortletApplication)activityComposerManager.getUIComposer().getAncestorOfType(UIPortletApplication.class)).getId() + "');");
            UIComposer composer = activityComposerManager.getUIComposer();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)composer);
        }
    }
}

