/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/profile/UIProfileUserSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UIProfileUserSearch
extends UIForm {
    public static final String SEARCH = "Search";
    public static final String USER_CONTACT = "name";
    public static final String REG_FOR_SPLIT = "[^_A-Za-z0-9-.\\s[\\n]]";
    public static final char EMPTY_CHARACTER = '\u0000';
    private static final String ASTERIK_STR = "*";
    private static final String PERCENTAGE_STR = "%";
    private static final String HTML_ATTRIBUTE_PLACEHOLDER = "placeholder";
    public static final String ALL_FILTER = "All";
    private List<Identity> identityList = null;
    private String rawSearchConditional;
    ProfileFilter profileFilter = null;
    String typeOfRelation = null;
    String spaceURL = null;
    private boolean isNewSearch;
    long identitiesCount;
    private boolean hasPeopleTab;
    private boolean hasConnectionLink;
    private int peopleNum;
    private boolean isLoadFromSearch = false;

    public boolean isLoadFromSearch() {
        return this.isLoadFromSearch;
    }

    public void setLoadFromSearch(boolean isLoadFromSearch) {
        this.isLoadFromSearch = isLoadFromSearch;
    }

    public boolean isHasPeopleTab() {
        return this.hasPeopleTab;
    }

    public void setHasPeopleTab(boolean hasPeopleTab) {
        this.hasPeopleTab = hasPeopleTab;
    }

    public boolean isHasConnectionLink() {
        return this.hasConnectionLink;
    }

    public void setHasConnectionLink(boolean hasConnectionLink) {
        this.hasConnectionLink = hasConnectionLink;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public void setIdentityList(List<Identity> identityList) throws Exception {
        if (identityList.contains(Utils.getViewerIdentity())) {
            identityList.remove(Utils.getViewerIdentity());
        }
        this.identityList = identityList;
    }

    public final List<Identity> getIdentityList() {
        return this.identityList;
    }

    public String getRawSearchConditional() {
        return this.rawSearchConditional;
    }

    public void setRawSearchConditional(String rawSearchConditional) {
        this.rawSearchConditional = rawSearchConditional;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation != null ? this.typeOfRelation : "";
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL != null ? this.spaceURL : "";
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    public final ProfileFilter getProfileFilter() {
        return this.profileFilter;
    }

    public final void setProfileFilter(ProfileFilter profileFilter) {
        this.profileFilter = profileFilter;
    }

    public UIProfileUserSearch() throws Exception {
        if (this.getId() == null) {
            this.setId("UIProfileUserSearch");
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_CONTACT, USER_CONTACT, ""));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("position", "position", ""));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("skills", "skills", ""));
        this.profileFilter = new ProfileFilter();
        this.setHasPeopleTab(false);
        this.setSubmitAction("return false;");
    }

    protected void initPlaceholder() throws Exception {
        this.getUIStringInput(USER_CONTACT).setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, this.getLabel(USER_CONTACT));
        this.getUIStringInput("position").setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, this.getLabel("position"));
        this.getUIStringInput("skills").setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, this.getLabel("skills"));
    }

    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String currentPath = pcontext.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path")).trim();
        if (currentPath.split("/").length >= 2) {
            return currentPath.split("/")[1];
        }
        return currentPath;
    }

    public List<Identity> getIdentitiesBySkills(List<Identity> identities) {
        ArrayList<Identity> identityLst = new ArrayList<Identity>();
        String prof = null;
        String skill = this.getProfileFilter().getSkills().trim().toLowerCase();
        if (identities.size() == 0) {
            return identityLst;
        }
        for (Identity id : identities) {
            Profile profile = id.getProfile();
            ArrayList experiences = (ArrayList)profile.getProperty("experiences");
            if (experiences == null) continue;
            block1: for (HashMap exp : experiences) {
                String[] items;
                prof = (String)exp.get("skills");
                if (prof == null) continue;
                Pattern p = Pattern.compile(REG_FOR_SPLIT);
                for (String item : items = p.split(prof)) {
                    if (!item.toLowerCase().matches(skill)) continue;
                    identityLst.add(id);
                    continue block1;
                }
            }
        }
        return UIProfileUserSearch.GetUniqueIdentities(identityLst);
    }

    private static Collection<Identity> Union(Collection<Identity> identities1, Collection<Identity> identities2) {
        HashSet<Identity> identities = new HashSet<Identity>(identities1);
        identities.addAll(new HashSet<Identity>(identities2));
        return new ArrayList<Identity>(identities);
    }

    private static ArrayList<Identity> GetUniqueIdentities(Collection<Identity> identities) {
        return (ArrayList)UIProfileUserSearch.Union(identities, identities);
    }

    public final boolean isNewSearch() {
        return this.isNewSearch;
    }

    public final void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    public static class SearchActionListener
    extends EventListener<UIProfileUserSearch> {
        public final void execute(Event<UIProfileUserSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIProfileUserSearch uiSearch = (UIProfileUserSearch)((Object)event.getSource());
            ProfileFilter filter = new ProfileFilter();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            filter.setExcludedIdentityList(excludedIdentityList);
            uiSearch.invokeSetBindingBean(filter);
            this.normalizeInputValues(filter);
            try {
                StringBuffer rawSearchMessageStringBuffer = new StringBuffer();
                String name = filter.getName();
                String pos = filter.getPosition();
                String skills = filter.getSkills();
                if (name == null || UIProfileUserSearch.ASTERIK_STR.equals(name) || UIProfileUserSearch.PERCENTAGE_STR.equals(name)) {
                    filter.setName("");
                } else {
                    rawSearchMessageStringBuffer.append(uiSearch.getLabel(UIProfileUserSearch.USER_CONTACT) + ":" + name);
                }
                if (pos == null || UIProfileUserSearch.ASTERIK_STR.equals(pos) || UIProfileUserSearch.PERCENTAGE_STR.equals(pos)) {
                    filter.setPosition("");
                } else {
                    rawSearchMessageStringBuffer.append((rawSearchMessageStringBuffer.length() > 0 ? " " : "") + uiSearch.getLabel("position") + ":" + pos);
                }
                if (skills == null || UIProfileUserSearch.ASTERIK_STR.equals(skills) || UIProfileUserSearch.PERCENTAGE_STR.equals(skills)) {
                    filter.setSkills("");
                } else {
                    rawSearchMessageStringBuffer.append((rawSearchMessageStringBuffer.length() > 0 ? " " : "") + uiSearch.getLabel("skills") + ":" + skills);
                }
                if (rawSearchMessageStringBuffer.length() > 0) {
                    uiSearch.setRawSearchConditional(rawSearchMessageStringBuffer.toString());
                } else {
                    uiSearch.setRawSearchConditional(UIProfileUserSearch.ALL_FILTER);
                    filter.setFirstCharacterOfName('\u0000');
                    filter.setName("");
                    filter.setCompany("");
                    filter.setSkills("");
                    filter.setPosition("");
                }
                uiSearch.setProfileFilter(filter);
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            Event searchEvent = uiSearch.getParent().createEvent(UIProfileUserSearch.SEARCH, Event.Phase.PROCESS, ctx);
            if (searchEvent != null) {
                searchEvent.broadcast();
            }
        }

        private void normalizeInputValues(ProfileFilter filter) {
            String name = filter.getName();
            String pos = filter.getPosition();
            String skills = filter.getSkills();
            if (name != null && name.length() > 0) {
                filter.setName(Utils.normalizeString(name));
            }
            if (pos != null && pos.length() > 0) {
                filter.setPosition(Utils.normalizeString(pos));
            }
            if (skills != null && skills.length() > 0) {
                filter.setSkills(Utils.normalizeString(skills));
            }
        }
    }
}

