/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.commons;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.EventUIComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/webui/commons/UISpaceSwitcher.gtmpl", events={@EventConfig(listeners={SelectSpaceActionListener.class})})
public class UISpacesSwitcher
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.webui.commons.UISpacesSwitcher");
    public static final String SPACE_ID_PARAMETER = "spaceId";
    public static final String SELECT_SPACE_ACTION = "SelectSpace";
    public static final long DEFAULT_INVALIDING_CACHE_TIME = 60000L;
    private EventUIComponent eventComponent;
    private String currentSpaceName = "";
    protected long invalidingCacheTime;
    private boolean isShowPortalSpace = true;
    private boolean isShowUserSpace = true;
    private boolean isAutoResize = false;
    private String mySpaceLabel = null;
    private String portalSpaceLabel = null;

    public UISpacesSwitcher() throws Exception {
        String invalidingCacheTimeProperty = System.getProperty("commons.spaceswitcher.cache.interval");
        this.invalidingCacheTime = invalidingCacheTimeProperty == null || invalidingCacheTimeProperty.isEmpty() ? 60000L : Long.parseLong(invalidingCacheTimeProperty);
        this.initPortalSpaceLabel();
    }

    public void init(EventUIComponent eventComponent) {
        this.eventComponent = eventComponent;
    }

    public EventUIComponent getEventComponent() {
        return this.eventComponent;
    }

    public void setCurrentSpaceName(String currentSpaceName) {
        this.currentSpaceName = currentSpaceName;
    }

    public String getCurrentSpaceName() {
        PortalRequestContext portalRequestContext;
        if (!StringUtils.isEmpty((String)this.portalSpaceLabel) && (portalRequestContext = Util.getPortalRequestContext()).getPortalOwner().equalsIgnoreCase(this.currentSpaceName)) {
            String spaceId = portalRequestContext.getRequestParameter(SPACE_ID_PARAMETER);
            if (this.isCurrentPortalWiki()) {
                if (StringUtils.isEmpty((String)spaceId)) {
                    return this.upperFirstCharacter(this.portalSpaceLabel);
                }
                if (spaceId.startsWith("/" + this.getPortalName())) {
                    return this.upperFirstCharacter(this.portalSpaceLabel);
                }
            } else if (!StringUtils.isEmpty((String)spaceId) && spaceId.startsWith("/" + this.getPortalName())) {
                return this.upperFirstCharacter(this.portalSpaceLabel);
            }
        }
        return this.upperFirstCharacter(this.currentSpaceName);
    }

    public String getMySpaceLabel() {
        if (!StringUtils.isEmpty((String)this.mySpaceLabel)) {
            return this.mySpaceLabel;
        }
        try {
            ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
            return bundle.getString("UISpaceSwitcher.title.my-space");
        }
        catch (MissingResourceException ex) {
            return "UISpaceSwitcher.title.my-space";
        }
    }

    public void setMySpaceLabel(String mySpaceLabel) {
        this.mySpaceLabel = mySpaceLabel;
    }

    public boolean isShowPortalSpace() {
        return this.isShowPortalSpace;
    }

    public void setShowPortalSpace(boolean isShowPortalSpace) {
        this.isShowPortalSpace = isShowPortalSpace;
    }

    public boolean isShowUserSpace() {
        return this.isShowUserSpace;
    }

    public void setShowUserSpace(boolean isShowUserSpace) {
        this.isShowUserSpace = isShowUserSpace;
    }

    public void setAutoResize(boolean isAutoResize) {
        this.isAutoResize = isAutoResize;
    }

    public boolean isAutoResize() {
        return this.isAutoResize;
    }

    public String getUsername() {
        try {
            ConversationState conversationState = ConversationState.getCurrent();
            return conversationState.getIdentity().getUserId();
        }
        catch (Exception e) {
            return "system";
        }
    }

    public String getPortalSpaceId() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String portalOwner = portalRequestContext.getPortalOwner();
        String portalName = this.getPortalName();
        StringBuilder spaceId = new StringBuilder();
        spaceId.append("/");
        spaceId.append(portalName);
        spaceId.append("/");
        spaceId.append(portalOwner);
        return spaceId.toString();
    }

    private String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public boolean isCurrentPortalWiki() {
        String[] array;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        SiteType portalType = portalRequestContext.getSiteType();
        if (!portalType.equals((Object)SiteType.PORTAL)) {
            return false;
        }
        HttpServletRequest request = portalRequestContext.getRequest();
        String requestURL = request.getRequestURL().toString();
        UIPortal uiPortal = Util.getUIPortal();
        String pageNodeSelected = null;
        try {
            pageNodeSelected = uiPortal.getSelectedUserNode().getURI();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while retrieving selected page node: ", (Throwable)e);
        }
        if (!requestURL.contains(pageNodeSelected)) {
            requestURL = portalRequestContext.getPortalURI() + pageNodeSelected;
        }
        String wikiPageName = pageNodeSelected == null ? "wiki" : pageNodeSelected;
        String uri = "";
        String sign1 = "/" + wikiPageName + "/";
        String sign2 = "/" + wikiPageName;
        if (requestURL.lastIndexOf(sign1) < 0) {
            if (requestURL.lastIndexOf(sign2) > 0) {
                uri = requestURL.substring(requestURL.lastIndexOf(sign2) + sign2.length());
            }
        } else {
            uri = requestURL.substring(requestURL.lastIndexOf(sign1) + sign1.length());
        }
        if (uri != null && uri.length() > 0 && uri.lastIndexOf("/") + 1 == uri.length()) {
            uri = uri.substring(0, uri.lastIndexOf("/"));
        }
        return uri.indexOf("/") <= 0 || !(array = uri.split("/"))[0].equals(PortalConfig.USER_TYPE);
    }

    public String getPortalSpaceLabel() {
        if (!StringUtils.isEmpty((String)this.portalSpaceLabel)) {
            return this.upperFirstCharacter(this.portalSpaceLabel);
        }
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        return this.upperFirstCharacter(portalRequestContext.getPortalOwner());
    }

    public void setPortalSpaceLabel(String portalSpaceLabel) {
        this.portalSpaceLabel = portalSpaceLabel;
    }

    private void initPortalSpaceLabel() throws Exception {
        String portalLabel;
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        UserPortalConfig userPortalConfig = requestContext.getUserPortalConfig();
        PortalConfig portalConfig = userPortalConfig.getPortalConfig();
        if (portalConfig.getType().equals("portal")) {
            portalLabel = portalConfig.getLabel();
        } else {
            String currentPortalName = requestContext.getPortalOwner();
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
            DataStorage dataStorage = userPortalConfigService.getDataStorage();
            portalConfig = dataStorage.getPortalConfig(currentPortalName);
            portalLabel = portalConfig.getLabel();
        }
        if (!StringUtils.isEmpty((String)portalLabel)) {
            this.portalSpaceLabel = portalLabel;
        }
    }

    private String upperFirstCharacter(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    protected String getBaseRestUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(PortalContainer.getCurrentPortalContainerName());
        sb.append("/").append(PortalContainer.getCurrentRestContextName());
        return sb.toString();
    }

    protected String getSocialBaseRestUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(PortalContainer.getCurrentRestContextName());
        sb.append("/").append("private");
        sb.append("/").append(PortalContainer.getCurrentPortalContainerName());
        return sb.toString();
    }

    protected String createSelectSpaceEvent(String spaceId) throws Exception {
        Parameter parameter = new Parameter(SPACE_ID_PARAMETER, spaceId);
        return this.event(SELECT_SPACE_ACTION, null, new Parameter[]{parameter});
    }

    public static class SelectSpaceActionListener
    extends EventListener<UISpacesSwitcher> {
        public void execute(Event<UISpacesSwitcher> event) throws Exception {
            String eventName;
            WebuiRequestContext context = event.getRequestContext();
            UISpacesSwitcher spaceSwitcher = (UISpacesSwitcher)((Object)event.getSource());
            UIPortletApplication root = (UIPortletApplication)spaceSwitcher.getAncestorOfType(UIPortletApplication.class);
            EventUIComponent eventComponent = spaceSwitcher.getEventComponent();
            Object uiComponent = null;
            uiComponent = eventComponent.getId() != null ? root.findComponentById(eventComponent.getId()) : root;
            Event xEvent = uiComponent.createEvent(eventName = eventComponent.getEventName(), Event.Phase.PROCESS, context);
            if (xEvent != null) {
                xEvent.broadcast();
            }
        }
    }
}

