/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.models.parameters.AbstractParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.List;

@JsonPropertyOrder(value={"name", "in", "description", "required", "type", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum"})
public abstract class AbstractSerializableParameter<T extends AbstractSerializableParameter<T>>
extends AbstractParameter
implements SerializableParameter {
    protected String type;
    protected String format;
    protected String collectionFormat;
    protected Property items;
    protected List<String> _enum;
    protected Boolean exclusiveMaximum;
    protected Double maximum;
    protected Boolean exclusiveMinimum;
    protected Double minimum;
    @JsonProperty(value="default")
    protected String defaultValue;

    public T property(Property property) {
        this.setProperty(property);
        return this.castThis();
    }

    public T type(String type) {
        this.setType(type);
        return this.castThis();
    }

    public T format(String format) {
        this.setFormat(format);
        return this.castThis();
    }

    public T description(String description) {
        this.setDescription(description);
        return this.castThis();
    }

    public T name(String name) {
        this.setName(name);
        return this.castThis();
    }

    public T required(boolean required) {
        this.setRequired(required);
        return this.castThis();
    }

    public T collectionFormat(String collectionFormat) {
        this.setCollectionFormat(collectionFormat);
        return this.castThis();
    }

    public T items(Property items) {
        this.items = items;
        return this.castThis();
    }

    public T _enum(List<String> value) {
        this._enum = value;
        return this.castThis();
    }

    @Override
    public List<String> getEnum() {
        return this._enum;
    }

    @Override
    public void setEnum(List<String> _enum) {
        this._enum = _enum;
    }

    @Override
    public Property getItems() {
        return this.items;
    }

    @Override
    public void setItems(Property items) {
        this.items = items;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    @Override
    public void setCollectionFormat(String collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public void setProperty(Property property) {
        this.type = property.getType();
        this.format = property.getFormat();
        if (property instanceof StringProperty) {
            StringProperty string = (StringProperty)property;
            this.setEnum(string.getEnum());
        } else if (property instanceof ArrayProperty) {
            ArrayProperty array = (ArrayProperty)property;
            this.setItems(array.getItems());
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public Boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    @JsonIgnore
    private T castThis() {
        AbstractSerializableParameter result = this;
        return (T)result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._enum == null ? 0 : this._enum.hashCode());
        result = 31 * result + (this.collectionFormat == null ? 0 : this.collectionFormat.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.exclusiveMaximum == null ? 0 : this.exclusiveMaximum.hashCode());
        result = 31 * result + (this.exclusiveMinimum == null ? 0 : this.exclusiveMinimum.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.maximum == null ? 0 : this.maximum.hashCode());
        result = 31 * result + (this.minimum == null ? 0 : this.minimum.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSerializableParameter other = (AbstractSerializableParameter)obj;
        if (this._enum == null ? other._enum != null : !this._enum.equals(other._enum)) {
            return false;
        }
        if (this.collectionFormat == null ? other.collectionFormat != null : !this.collectionFormat.equals(other.collectionFormat)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.exclusiveMaximum == null ? other.exclusiveMaximum != null : !this.exclusiveMaximum.equals(other.exclusiveMaximum)) {
            return false;
        }
        if (this.exclusiveMinimum == null ? other.exclusiveMinimum != null : !this.exclusiveMinimum.equals(other.exclusiveMinimum)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        if (this.maximum == null ? other.maximum != null : !this.maximum.equals(other.maximum)) {
            return false;
        }
        if (this.minimum == null ? other.minimum != null : !this.minimum.equals(other.minimum)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

