/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy.jarjar;

import groovy.lang.GroovyClassLoader;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.script.groovy.jarjar.JarJarExpressionTransformer;
import org.exoplatform.services.script.groovy.jarjar.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarJarClassLoader
extends GroovyClassLoader {
    private Package root = new Package();

    public JarJarClassLoader() {
    }

    public JarJarClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public JarJarClassLoader(GroovyClassLoader groovyClassLoader) {
        super(groovyClassLoader);
    }

    public JarJarClassLoader(ClassLoader classLoader, CompilerConfiguration compilerConfiguration, boolean b) {
        super(classLoader, compilerConfiguration, b);
    }

    public JarJarClassLoader(ClassLoader classLoader, CompilerConfiguration compilerConfiguration) {
        super(classLoader, compilerConfiguration);
    }

    public void addMapping(List<String> source, List<String> destination) {
        this.root.add(source, destination);
    }

    public void addMapping(Map<String, String> mapping) {
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            this.addMapping(entry.getKey(), entry.getValue());
        }
    }

    public void addMapping(String source, String destination) {
        List<String> sourcePackage = Arrays.asList(source.split("\\."));
        List<String> destinationPackage = Arrays.asList(destination.split("\\."));
        this.root.add(sourcePackage, destinationPackage);
    }

    protected CompilationUnit createCompilationUnit(final CompilerConfiguration compilerConfiguration, final CodeSource codeSource) {
        CompilationUnit unit = (CompilationUnit)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<CompilationUnit>(){

            @Override
            public CompilationUnit run() {
                return JarJarClassLoader.super.createCompilationUnit(compilerConfiguration, codeSource);
            }
        });
        unit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit sourceUnit, GeneratorContext generatorContext, ClassNode classNode) throws CompilationFailedException {
                ModuleNode module = classNode.getModule();
                for (ImportNode importNode : module.getImports()) {
                    ClassNode cn = importNode.getType();
                    String s = cn.getPackageName();
                    List<String> ss = JarJarClassLoader.this.root.map2(s);
                    if (ss == null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (String n : ss) {
                        sb.append(n).append('.');
                    }
                    sb.append(cn.getNameWithoutPackage());
                    String name = sb.toString();
                    cn.setName(name);
                }
                JarJarExpressionTransformer visitor = new JarJarExpressionTransformer(sourceUnit, JarJarClassLoader.this.root);
                visitor.visitClass(classNode);
            }
        }, 3);
        return unit;
    }

    protected static JarJarClassLoader createJarJarClassLoaderInPrivilegedMode(final ClassLoader classLoader) {
        return (JarJarClassLoader)((Object)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<JarJarClassLoader>(){

            @Override
            public JarJarClassLoader run() {
                return new JarJarClassLoader(classLoader);
            }
        }));
    }
}

