/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.query;

import org.chromattic.api.format.FormatterContext;

public class ChromatticNameEncode {
    private static final char[] table = new char[]{'{', '}', '.', '/', ':', '[', ']', '|', '*', '%'};

    private static boolean isSpecialChar(char c) {
        return ChromatticNameEncode.getCode(c) != null;
    }

    private static String getCode(char c) {
        if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
            switch (c) {
                case '{': {
                    return "00";
                }
                case '}': {
                    return "01";
                }
                case '.': {
                    return "02";
                }
                case '/': {
                    return "03";
                }
                case ':': {
                    return "04";
                }
                case '[': {
                    return "05";
                }
                case ']': {
                    return "06";
                }
                case '|': {
                    return "07";
                }
                case '*': {
                    return "08";
                }
                case '%': {
                    return "09";
                }
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    private String decode(String s, int from) {
        StringBuffer buffer = new StringBuffer(s.length());
        buffer.append(s, 0, from);
        int to = s.length();
        while (from < to) {
            char c;
            if ((c = s.charAt(from++)) == '%') {
                char c2;
                char c1;
                if (from + 1 >= to) {
                    throw new IllegalStateException("Cannot decode wrong name " + s);
                }
                if ((c1 = s.charAt(from++)) != '0') {
                    throw new IllegalStateException("Cannot decode wrong name " + s);
                }
                if ((c2 = s.charAt(from++)) < '0' || c2 > '9') {
                    throw new IllegalStateException("Cannot decode wrong name " + s);
                }
                buffer.append(table[c2 - 48]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String decodeNodeName(FormatterContext context, String internalName) {
        int length = internalName.length();
        for (int i = 0; i < length; ++i) {
            char c = internalName.charAt(i);
            if (c != '%') continue;
            return this.decode(internalName, i);
        }
        return internalName;
    }

    private static String encode(String s, int from) {
        StringBuffer buffer = new StringBuffer(s.length() * 5 >> 2);
        buffer.append(s, 0, from);
        int to = s.length();
        while (from < to) {
            char c;
            String code;
            if ((code = ChromatticNameEncode.getCode(c = s.charAt(from++))) != null) {
                buffer.append('%');
                buffer.append(code);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String encodeNodeName(String externalName) {
        int length = externalName.length();
        for (int i = 0; i < length; ++i) {
            char c = externalName.charAt(i);
            if (!ChromatticNameEncode.isSpecialChar(c)) continue;
            externalName = ChromatticNameEncode.encode(externalName, i);
            break;
        }
        return externalName;
    }
}

