/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Permission;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ReadOnlyChangedSizeHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemState
implements Externalizable {
    private static final long serialVersionUID = 7967457831325761318L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemState");
    public static final int ADDED = 1;
    public static final int UPDATED = 2;
    public static final int DELETED = 4;
    public static final int UNCHANGED = 8;
    public static final int MIXIN_CHANGED = 16;
    public static final int RENAMED = 32;
    public static final int PATH_CHANGED = 64;
    public static final int ADDED_AUTO_CREATED_NODES = 128;
    public static final int MOVED = 256;
    public static final int ORDERED = 512;
    protected ItemData data;
    protected int state;
    private boolean isPersisted = true;
    private transient boolean internallyCreated = false;
    protected transient boolean eventFire;
    private transient QPath ancestorToSave;
    private QPath oldPath;
    private transient ChangedSizeHandler sizeHandler;

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave) {
        this(data, state, eventFire, ancestorToSave, false, true);
    }

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave, boolean isInternalCreated) {
        this(data, state, eventFire, ancestorToSave, isInternalCreated, true);
    }

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave, boolean isInternalCreated, boolean isPersisted, QPath oldPath) {
        this(data, state, eventFire, ancestorToSave, isInternalCreated, isPersisted);
        this.oldPath = oldPath;
    }

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave, boolean isInternalCreated, boolean isPersisted, QPath oldPath, ChangedSizeHandler sizeHandler) {
        this(data, state, eventFire, ancestorToSave, isInternalCreated, isPersisted, oldPath);
        this.sizeHandler = sizeHandler;
    }

    public ItemState(ItemData data, int state, boolean eventFire, QPath ancestorToSave, boolean isInternalCreated, boolean isPersisted) {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.INVOKE_INTERNAL_API_PERMISSION);
        this.data = data;
        this.state = state;
        this.eventFire = eventFire;
        this.ancestorToSave = ancestorToSave == null ? data.getQPath() : ancestorToSave;
        this.internallyCreated = isInternalCreated;
        this.isPersisted = isPersisted;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ItemState.nameFromValue(state) + " " + data.getQPath().getAsString() + ",  " + data.getIdentifier()));
        }
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public ItemData getData() {
        return this.data;
    }

    public int getState() {
        return this.state;
    }

    public boolean isNode() {
        return this.data.isNode();
    }

    public boolean isAdded() {
        return this.state == 1;
    }

    public boolean isUpdated() {
        return this.state == 2;
    }

    public boolean isDeleted() {
        return this.state == 4;
    }

    public boolean isUnchanged() {
        return this.state == 8;
    }

    public boolean isMixinChanged() {
        return this.state == 16;
    }

    public boolean isRenamed() {
        return this.state == 32;
    }

    public boolean isPathChanged() {
        return this.state == 64;
    }

    public boolean isAddedAutoCreatedNodes() {
        return this.state == 128;
    }

    public boolean isMoved() {
        return this.state == 256;
    }

    public boolean isOrdered() {
        return this.state == 512;
    }

    public boolean isEventFire() {
        return this.eventFire;
    }

    public void eraseEventFire() {
        this.eventFire = false;
    }

    public void makeStateAdded() {
        this.state = 1;
    }

    public boolean isDescendantOf(QPath relPath) {
        return this.ancestorToSave.isDescendantOf(relPath) || this.ancestorToSave.equals(relPath);
    }

    public QPath getAncestorToSave() {
        return this.ancestorToSave;
    }

    public QPath getOldPath() {
        return this.oldPath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemState) {
            ItemState other = (ItemState)obj;
            return other.getData().equals(this.data) && other.getState() == this.state;
        }
        return false;
    }

    public boolean isSame(ItemState item) {
        if (this == item) {
            return true;
        }
        return this.getData().getIdentifier().hashCode() == item.getData().getIdentifier().hashCode() && this.getData().getQPath().hashCode() == item.getData().getQPath().hashCode() && this.getState() == item.getState();
    }

    public static ItemState createAddedAutoCreatedNodes(ItemData data) {
        return new ItemState(data, 128, false, null, false);
    }

    public static ItemState createAddedState(ItemData data) {
        return new ItemState(data, 1, true, null, true);
    }

    public static ItemState createAddedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 1, true, null, isInternalCreated);
    }

    public static ItemState createUpdatedState(ItemData data) {
        return new ItemState(data, 2, true, null);
    }

    public static ItemState createUpdatedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 2, true, null, isInternalCreated);
    }

    public static ItemState createDeletedState(ItemData data) {
        return new ItemState(data, 4, true, null);
    }

    public static ItemState createDeletedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 4, true, null, isInternalCreated);
    }

    public static ItemState createRenamedState(ItemData data) {
        return new ItemState(data, 32, true, null);
    }

    public static ItemState createRenamedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 32, true, null, isInternalCreated);
    }

    public static ItemState createUnchangedState(ItemData data) {
        return new ItemState(data, 8, false, null);
    }

    public static ItemState createUnchangedState(ItemData data, boolean isInternalCreated) {
        return new ItemState(data, 8, false, null, isInternalCreated);
    }

    public static ItemState createMovedState(ItemData data, QPath oldPath) {
        return new ItemState(data, 256, true, null, true, false, oldPath);
    }

    public static ItemState createOrderedState(ItemData data, QPath oldPath) {
        return new ItemState(data, 512, true, null, true, false, oldPath);
    }

    public static String nameFromValue(int stateValue) {
        switch (stateValue) {
            case 1: {
                return "ADDED";
            }
            case 4: {
                return "DELETED";
            }
            case 2: {
                return "UPDATED";
            }
            case 8: {
                return "UNCHANGED";
            }
            case 16: {
                return "MIXIN_CHANGED";
            }
            case 32: {
                return "RENAMED";
            }
            case 64: {
                return "PATH_CHANGED";
            }
            case 128: {
                return "ADDED_AUTO_CREATED_NODES";
            }
            case 256: {
                return "MOVED";
            }
            case 512: {
                return "ORDERED";
            }
        }
        return "UNDEFINED STATE";
    }

    public boolean isInternallyCreated() {
        return this.internallyCreated;
    }

    public long getChangedSize() {
        if (this.sizeHandler == null) {
            throw new IllegalStateException("Changed size value is undefine. May be it is not appropriate place to invoke");
        }
        return this.sizeHandler.getChangedSize();
    }

    public ChangedSizeHandler getChangedSizeHandler() {
        if (this.sizeHandler == null || this.sizeHandler instanceof ReadOnlyChangedSizeHandler) {
            return this.sizeHandler;
        }
        return new ReadOnlyChangedSizeHandler(this.sizeHandler.getNewSize(), this.sizeHandler.getPrevSize());
    }

    public ItemState() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.state);
        out.writeBoolean(this.isPersisted);
        out.writeBoolean(this.eventFire);
        if (this.oldPath == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            byte[] buf = this.oldPath.getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        out.writeObject(this.data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = in.readInt();
        this.isPersisted = in.readBoolean();
        this.eventFire = in.readBoolean();
        if (in.readInt() == 1) {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            try {
                this.oldPath = QPath.parse(new String(buf, "UTF-8"));
            }
            catch (IllegalPathException e) {
                throw new IOException("Data currupted.", (Throwable)((Object)e));
            }
        }
        this.data = (ItemData)in.readObject();
    }

    public String toString() {
        return "ItemState [data=" + this.data + ", state=" + this.state + ", isPersisted=" + this.isPersisted + ", internallyCreated=" + this.internallyCreated + ", eventFire=" + this.eventFire + ", ancestorToSave=" + this.ancestorToSave + ", oldPath=" + this.oldPath + "]";
    }
}

