/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.SingleDbJDBCConnection;

public class HSQLDBSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    public HSQLDBSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected final void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_ITEM_BY_NAME = "select * from JCR_SITEM where PARENT_ID=? and CONTAINER_NAME=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=? order by N_ORDER_NUM";
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_SITEM where PARENT_ID=? and I_CLASS=2 and CONTAINER_NAME=? order by ID";
        this.FIND_WORKSPACE_DATA_SIZE = "select sum(bit_length(DATA)/8) from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID";
        this.FIND_NODE_DATA_SIZE = "select sum(bit_length(DATA)/8) from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID";
        this.FIND_VALUE_STORAGE_DESC_AND_SIZE = "select bit_length(DATA)/8, STORAGE_DESC from JCR_SVALUE where PROPERTY_ID=?";
    }

    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, parentId);
        this.findItemByName.setString(2, this.containerConfig.containerName);
        this.findItemByName.setString(3, name);
        this.findItemByName.setInt(4, index);
        return this.findItemByName.executeQuery();
    }

    protected ResultSet findPropertyByName(String parentCid, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, parentCid);
        this.findPropertyByName.setString(2, this.containerConfig.containerName);
        this.findPropertyByName.setString(3, name);
        return this.findPropertyByName.executeQuery();
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, parentCid);
        this.findNodesByParentId.setString(2, this.containerConfig.containerName);
        return this.findNodesByParentId.executeQuery();
    }

    protected ResultSet findChildNodesCountByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, parentCid);
        this.findNodesCountByParentId.setString(2, this.containerConfig.containerName);
        return this.findNodesCountByParentId.executeQuery();
    }

    protected ResultSet findChildPropertiesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, parentCid);
        this.findPropertiesByParentId.setString(2, this.containerConfig.containerName);
        return this.findPropertiesByParentId.executeQuery();
    }
}

