/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBInitializer {
    public static String SQL_CREATETABLE = "^(CREATE(\\s)+TABLE(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_CREATEVIEW = "^(CREATE(\\s)+VIEW(\\s)+(IF(\\s)+NOT(\\s)+EXISTS(\\s)+)*){1}";
    public static String SQL_OBJECTNAME = "((JCR_[A-Z_0-9]+){1}(\\s*?|(\\(\\))*?)+)+?";
    public static String SQL_CREATEINDEX = "^(CREATE(\\s)+(UNIQUE(\\s)+)*INDEX(\\s)+){1}";
    public static String SQL_ONTABLENAME = "(ON(\\s)+(JCR_[A-Z_0-9]+){1}(\\s*?|(\\(\\))*?)+){1}";
    public static String SQL_CREATESEQUENCE = "^(CREATE(\\s)+SEQUENCE(\\s)+){1}";
    public static String SQL_CREATETRIGGER = "^(CREATE(\\s)+(OR(\\s){1}REPLACE(\\s)+)*TRIGGER(\\s)+){1}";
    public static String SQL_TRIGGERNAME = "(([A-Z_]+JCR_[A-Z_0-9]+){1}(\\s*?|(\\(\\))*?)+)+?";
    public static String SQL_CREATEFUNCTION = "^CREATE[\\s]+Function[\\s]+([^(]+).*";
    public static String SQL_CREATEPROCEDURE = "^CREATE[\\s]+Procedure[\\s]+([^(]+).*";
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBInitializer");
    protected final Connection connection;
    protected final JDBCDataContainerConfig containerConfig;
    protected final String script;
    protected final Pattern creatTablePattern;
    protected final Pattern creatViewPattern;
    protected final Pattern dbObjectNamePattern;
    protected final Pattern creatIndexPattern;
    protected final Pattern onTableNamePattern;
    protected final Pattern creatSequencePattern;
    protected final Pattern creatTriggerPattern;
    protected final Pattern dbTriggerNamePattern;
    protected final Pattern creatFunctionPattern;
    protected final Pattern creatProcedurePattern;

    public DBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        this.connection = connection;
        this.containerConfig = containerConfig;
        this.script = DBInitializerHelper.prepareScripts(containerConfig);
        this.creatTablePattern = Pattern.compile(SQL_CREATETABLE, 2);
        this.creatViewPattern = Pattern.compile(SQL_CREATEVIEW, 2);
        this.dbObjectNamePattern = Pattern.compile(SQL_OBJECTNAME, 2);
        this.creatIndexPattern = Pattern.compile(SQL_CREATEINDEX, 2);
        this.onTableNamePattern = Pattern.compile(SQL_ONTABLENAME, 2);
        this.creatSequencePattern = Pattern.compile(SQL_CREATESEQUENCE, 2);
        this.creatTriggerPattern = Pattern.compile(SQL_CREATETRIGGER, 2);
        this.dbTriggerNamePattern = Pattern.compile(SQL_TRIGGERNAME, 2);
        this.creatFunctionPattern = Pattern.compile(SQL_CREATEFUNCTION, 2);
        this.creatProcedurePattern = Pattern.compile(SQL_CREATEPROCEDURE, 2);
    }

    protected boolean isTableExists(final Connection conn, final String tableName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JDBCUtils.tableExists((String)tableName, (Connection)conn);
            }
        });
    }

    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        return false;
    }

    protected boolean isProcedureExists(Connection conn, String procedureName) throws SQLException {
        return false;
    }

    protected boolean isFunctionExists(Connection conn, String functionName) throws SQLException {
        return false;
    }

    private boolean isObjectExists(Connection conn, String sql, Set<String> existingTables) throws SQLException {
        Matcher tMatcher = this.creatTablePattern.matcher(sql);
        if (tMatcher.find()) {
            String tableName;
            tMatcher = this.dbObjectNamePattern.matcher(sql);
            if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The table '" + tableName + "' already exists."));
                }
                existingTables.add(tableName);
                return true;
            }
        } else {
            tMatcher = this.creatViewPattern.matcher(sql);
            if (tMatcher.find()) {
                String tableName;
                tMatcher = this.dbObjectNamePattern.matcher(sql);
                if (tMatcher.find() && this.isTableExists(conn, tableName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("The view '" + tableName + "' already exists."));
                    }
                    existingTables.add(tableName);
                    return true;
                }
            } else {
                tMatcher = this.creatIndexPattern.matcher(sql);
                if (tMatcher.find()) {
                    tMatcher = this.dbObjectNamePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String indexName = sql.substring(tMatcher.start(), tMatcher.end());
                        tMatcher = this.onTableNamePattern.matcher(sql);
                        if (tMatcher.find()) {
                            String onTableName = sql.substring(tMatcher.start(), tMatcher.end());
                            if ((tMatcher = this.dbObjectNamePattern.matcher(onTableName)).find()) {
                                String tableName = onTableName.substring(tMatcher.start(), tMatcher.end());
                                if (existingTables.contains(tableName)) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("The table '" + tableName + "' already exists so we assume that the index '" + indexName + "' exists also."));
                                    }
                                    return true;
                                }
                            } else {
                                LOG.warn((Object)("Could not detect the $TABLE_NAME from the query '" + sql + "'."));
                            }
                        } else {
                            LOG.warn((Object)("Could not detect the clause ON $TABLE_NAME from the query '" + sql + "'."));
                        }
                    } else {
                        LOG.warn((Object)("Could not detect the $INDEX_NAME from the query '" + sql + "'."));
                    }
                } else {
                    tMatcher = this.creatSequencePattern.matcher(sql);
                    if (tMatcher.find()) {
                        String sequenceName;
                        tMatcher = this.dbObjectNamePattern.matcher(sql);
                        if (tMatcher.find() && this.isSequenceExists(conn, sequenceName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("The sequence '" + sequenceName + "' already exists."));
                            }
                            return true;
                        }
                    } else {
                        tMatcher = this.creatTriggerPattern.matcher(sql);
                        if (tMatcher.find()) {
                            tMatcher = this.dbTriggerNamePattern.matcher(sql);
                            if (tMatcher.find()) {
                                String triggerName = sql.substring(tMatcher.start(), tMatcher.end());
                                if (!existingTables.isEmpty()) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("At least one table has been created so we assume that the trigger '" + triggerName + "' exists also."));
                                    }
                                    return true;
                                }
                            }
                        } else {
                            tMatcher = this.creatFunctionPattern.matcher(sql);
                            if (tMatcher.find()) {
                                String functionName;
                                tMatcher = this.dbObjectNamePattern.matcher(sql);
                                if (tMatcher.find() && this.isFunctionExists(conn, functionName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("The function '" + functionName + "' already exists."));
                                    }
                                    return true;
                                }
                            } else {
                                tMatcher = this.creatProcedurePattern.matcher(sql);
                                if (tMatcher.find()) {
                                    String procedureName;
                                    tMatcher = this.dbObjectNamePattern.matcher(sql);
                                    if (tMatcher.find() && this.isProcedureExists(conn, procedureName = sql.substring(tMatcher.start(), tMatcher.end()))) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("The procedure  '" + procedureName + "' already exists."));
                                        }
                                        return true;
                                    }
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Could not detect the command type of the query '" + sql + "', it will be ignored."));
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void init() throws DBInitializerException {
        block22: {
            SQLException e2;
            HashSet<String> existingTables;
            Statement st;
            String sql;
            block20: {
                String[] scripts = JDBCUtils.splitWithSQLDelimiter((String)this.script);
                sql = null;
                st = null;
                existingTables = new HashSet<String>();
                st = this.connection.createStatement();
                this.connection.setAutoCommit(true);
                for (String scr : scripts) {
                    String s = JDBCUtils.cleanWhitespaces((String)scr.trim());
                    if (s.length() <= 0 || this.isObjectExists(this.connection, sql = s, existingTables)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                    }
                    final Statement finalSt = st;
                    final String finalSql = this.updateQuery(sql);
                    if (finalSql.isEmpty()) continue;
                    SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            finalSt.executeUpdate(finalSql);
                            return null;
                        }
                    });
                }
                this.postInit(this.connection);
                LOG.info((Object)("The DB schema of the workspace '" + this.containerConfig.containerName + "' has been initialized succesfully."));
                Object var13_16 = null;
                if (st == null) break block20;
                try {
                    st.close();
                }
                catch (SQLException e2) {
                    LOG.debug((Object)("Could not close the Statement: " + e2.getMessage()));
                }
            }
            try {
                this.connection.close();
            }
            catch (SQLException e2) {
                LOG.warn((Object)("Could not close the Connection: " + e2.getMessage()), (Throwable)e2);
            }
            break block22;
            {
                catch (SQLException e3) {
                    if (LOG.isDebugEnabled()) {
                        LOG.error((Object)"An error occurs while creating the tables.", (Throwable)e3);
                    }
                    LOG.warn((Object)("An error occurs while creating the tables it could be due to some existing tables that have not been properly created earlier. Please drop manually the tables of the workspace '" + this.containerConfig.containerName + "' and try again."));
                    boolean isAlreadyCreated = false;
                    try {
                        isAlreadyCreated = this.isObjectExists(this.connection, sql, existingTables);
                    }
                    catch (SQLException ce) {
                        LOG.warn((Object)("Could not check if objects corresponding to the query '" + sql + "' exist."));
                    }
                    if (!isAlreadyCreated) {
                        String msg = "Could not create the DB schema of the workspace '" + this.containerConfig.containerName + "'. Reason: " + e3.getMessage() + "; " + JDBCUtils.getFullMessage((SQLException)e3) + ". Last command: " + sql;
                        throw new DBInitializerException(msg, e3);
                    }
                    LOG.warn((Object)("Could not create the DB schema of the workspace '" + this.containerConfig.containerName + "'. Reason: Objects form '" + sql + "' already exist."));
                    Object var13_17 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e2) {
                            LOG.debug((Object)("Could not close the Statement: " + e2.getMessage()));
                        }
                    }
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e2) {
                        LOG.warn((Object)("Could not close the Connection: " + e2.getMessage()), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e2) {
                        LOG.debug((Object)("Could not close the Statement: " + e2.getMessage()));
                    }
                }
                try {
                    this.connection.close();
                }
                catch (SQLException e2) {
                    LOG.warn((Object)("Could not close the Connection: " + e2.getMessage()), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    protected void postInit(Connection connection) throws SQLException {
        String select = "select * from " + DBInitializerHelper.getItemTableName(this.containerConfig) + " where ID='" + Constants.ROOT_PARENT_UUID + "' and PARENT_ID='" + Constants.ROOT_PARENT_UUID + "'";
        if (!connection.createStatement().executeQuery(select).next()) {
            String insert = DBInitializerHelper.getRootNodeInitializeScript(this.containerConfig);
            connection.createStatement().executeUpdate(insert);
        }
    }

    protected String updateQuery(String sql) {
        return sql;
    }
}

