/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.formula;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.formula.FormulaRenderer;
import org.xwiki.formula.ImageData;
import org.xwiki.formula.ImageStorage;

public abstract class AbstractFormulaRenderer
implements FormulaRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFormulaRenderer.class);
    @Inject
    private ImageStorage storage;

    @Override
    public String process(String formula, boolean inline, FormulaRenderer.FontSize size, FormulaRenderer.Type type) throws IllegalArgumentException, IOException {
        String cacheKey = this.computeImageID(formula, inline, size, type);
        if (this.storage.get(cacheKey) == null) {
            ImageData image = this.renderImage(formula, inline, size, type);
            this.storage.put(cacheKey, image);
        }
        return cacheKey;
    }

    @Override
    public ImageData getImage(String imageID) {
        return this.storage.get(imageID);
    }

    protected abstract ImageData renderImage(String var1, boolean var2, FormulaRenderer.FontSize var3, FormulaRenderer.Type var4) throws IllegalArgumentException, IOException;

    protected String computeImageID(String formula, boolean inline, FormulaRenderer.FontSize size, FormulaRenderer.Type type) {
        try {
            MessageDigest hashAlgorithm = MessageDigest.getInstance("SHA-256");
            hashAlgorithm.update(inline ? (byte)116 : 102);
            hashAlgorithm.update((byte)size.ordinal());
            hashAlgorithm.update((byte)type.ordinal());
            hashAlgorithm.update(formula.getBytes());
            return new String(Hex.encodeHex((byte[])hashAlgorithm.digest()));
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error("No MD5 hash algorithm implementation", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LOGGER.error("Error hashing image name", (Throwable)ex);
        }
        int prime = 37;
        int result = 1;
        result = 37 * result + formula.hashCode();
        result = 37 * result + (inline ? 0 : 1);
        result = 37 * result + size.hashCode();
        result = 37 * result + type.hashCode();
        result = 37 * result + this.getClass().getCanonicalName().hashCode();
        return result + "";
    }

    protected String wrapFormula(String formula, boolean inline) {
        return (inline ? "\\begin{math}" : "\\begin{displaymath}") + "\n{ " + formula + " }\n" + (inline ? "\\end{math}" : "\\end{displaymath}");
    }
}

