/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.formula.internal;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.formula.AbstractFormulaRenderer;
import org.xwiki.formula.FormulaRenderer;
import org.xwiki.formula.ImageData;

@Component(value="mathtran")
public final class MathTranFormulaRenderer
extends AbstractFormulaRenderer
implements Initializable {
    private static final String MATHTRAN_BASE_URL = "http://www.mathtran.org/cgi-bin/mathtran?";
    private final HttpClient client = new HttpClient();

    public void initialize() throws InitializationException {
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
    }

    @Override
    protected ImageData renderImage(String formula, boolean inline, FormulaRenderer.FontSize size, FormulaRenderer.Type type) throws IllegalArgumentException, IOException {
        String encodedFormula = URLEncoder.encode((inline ? "" : "\\displaystyle") + formula, "UTF-8");
        GetMethod method = new GetMethod("http://www.mathtran.org/cgi-bin/mathtran?D=" + Math.max(size.ordinal() - 3, 0) + "&tex=" + encodedFormula);
        method.setRequestHeader("accept", type.getMimetype());
        method.setFollowRedirects(true);
        int statusCode = this.client.executeMethod((HttpMethod)method);
        if (statusCode >= 200 && statusCode < 400) {
            byte[] b = method.getResponseBody();
            method.releaseConnection();
            return new ImageData(b, type);
        }
        throw new IOException("Can't load image from MathTran server");
    }
}

