/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public final class DOMBuilder {
    private static final Log LOGGER = LogFactory.getLog(DOMBuilder.class);
    @GuardedBy(value="itself")
    private final Transformer contentTransformer;
    @GuardedBy(value="itself")
    private final Transformer identityTransformer = this.createIdentityTransformer();

    protected DOMBuilder() {
        this.contentTransformer = this.createContentTransformer(this.identityTransformer);
    }

    private Transformer createIdentityTransformer() {
        Transformer transformer;
        block2: {
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerException transformerException) {
                LOGGER.warn((Object)transformerException.getMessage());
                transformer = null;
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return transformer;
    }

    private Transformer createContentTransformer(Transformer transformer) {
        Transformer transformer2;
        try {
            transformer2 = TransformerFactory.newInstance().newTemplates(new StreamSource(DOMBuilder.class.getResourceAsStream("/content/mathmlc2p.xsl"))).newTransformer();
        }
        catch (TransformerException transformerException) {
            LOGGER.warn((Object)transformerException.getMessage());
            transformer2 = transformer;
        }
        return transformer2;
    }

    public static DOMBuilder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static DOMBuilder getDOMBuilder() {
        return DOMBuilder.getInstance();
    }

    public DocumentElement createJeuclidDom(Node node) {
        return this.createJeuclidDom(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentElement createJeuclidDom(Node node, boolean bl) {
        Node node2;
        Node node3;
        if (node instanceof Document) {
            node3 = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            node3 = node;
        } else if (node instanceof DocumentFragment) {
            node2 = node.getFirstChild();
            if (!(node2 instanceof Element)) {
                throw new IllegalArgumentException("Expected DocumentFragment with Element child");
            }
            node3 = node2;
        } else {
            throw new IllegalArgumentException("Unsupported node: " + node + ". Expected either Document, Element or DocumentFragment");
        }
        node2 = null;
        try {
            DOMSource dOMSource = new DOMSource(node3);
            node2 = new DocumentElement();
            DOMResult dOMResult = new DOMResult(node2);
            Transformer transformer = bl ? this.contentTransformer : this.identityTransformer;
            Transformer transformer2 = transformer;
            synchronized (transformer2) {
                transformer.transform(dOMSource, dOMResult);
            }
        }
        catch (TransformerException transformerException) {
            node2 = null;
            LOGGER.warn((Object)transformerException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            node2 = null;
            LOGGER.warn((Object)nullPointerException.getMessage());
        }
        catch (DOMException dOMException) {
            node2 = null;
            LOGGER.warn((Object)dOMException.getMessage());
        }
        return node2;
    }

    private static final class SingletonHolder {
        private static final DOMBuilder INSTANCE = new DOMBuilder();

        private SingletonHolder() {
        }
    }
}

