/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FlowScope;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LinkedFlowScope;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticSlot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TypeInference
extends DataFlowAnalysis.BranchedForwardDataFlowAnalysis<Node, FlowScope> {
    static final DiagnosticType TEMPLATE_TYPE_NOT_OBJECT_TYPE = DiagnosticType.warning("JSC_TEMPLATE_TYPE_NOT_OBJECT_TYPE", "The template type must be an object type.\nActual: {0}");
    static final DiagnosticType TEMPLATE_TYPE_OF_THIS_EXPECTED = DiagnosticType.warning("JSC_TEMPLATE_TYPE_OF_THIS_EXPECTED", "A function type with the template type as the type of this must be a parameter type");
    static final DiagnosticType FUNCTION_LITERAL_UNDEFINED_THIS = DiagnosticType.warning("JSC_FUNCTION_LITERAL_UNDEFINED_THIS", "Function literal argument refers to undefined this argument");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final Scope syntacticScope;
    private final FlowScope functionScope;
    private final FlowScope bottomScope;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;

    TypeInference(AbstractCompiler compiler, ControlFlowGraph<Node> cfg, ReverseAbstractInterpreter reverseInterpreter, Scope functionScope, Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap) {
        super(cfg, new LinkedFlowScope.FlowScopeJoinOp());
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.reverseInterpreter = reverseInterpreter;
        this.syntacticScope = functionScope;
        this.functionScope = LinkedFlowScope.createEntryLattice(functionScope);
        this.assertionFunctionsMap = assertionFunctionsMap;
        Iterator<Scope.Var> varIt = functionScope.getDeclarativelyUnboundVarsWithoutTypes();
        while (varIt.hasNext()) {
            Scope.Var var = varIt.next();
            if (this.isUnflowable(var)) continue;
            this.functionScope.inferSlotType(var.getName(), this.getNativeType(JSTypeNative.VOID_TYPE));
        }
        this.bottomScope = LinkedFlowScope.createEntryLattice(new Scope(functionScope.getRootNode(), functionScope.getTypeOfThis()));
    }

    @Override
    FlowScope createInitialEstimateLattice() {
        return this.bottomScope;
    }

    @Override
    FlowScope createEntryLattice() {
        return this.functionScope;
    }

    @Override
    FlowScope flowThrough(Node n, FlowScope input) {
        if (input == this.bottomScope) {
            return input;
        }
        FlowScope output = input.createChildFlowScope();
        output = this.traverse(n, output);
        return output;
    }

    @Override
    List<FlowScope> branchedFlowThrough(Node source, FlowScope input) {
        FlowScope output = this.flowThrough(source, input);
        Node condition = null;
        FlowScope conditionFlowScope = null;
        BooleanOutcomePair conditionOutcomes = null;
        List branchEdges = this.getCfg().getOutEdges(source);
        ArrayList result = Lists.newArrayListWithCapacity((int)branchEdges.size());
        for (DiGraph.DiGraphEdge branchEdge : branchEdges) {
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)branchEdge.getValue());
            FlowScope newScope = output;
            switch (branch) {
                case ON_TRUE: {
                    if (NodeUtil.isForIn(source)) {
                        Node item = source.getFirstChild();
                        Node obj = item.getNext();
                        FlowScope informed = this.traverse(obj, output.createChildFlowScope());
                        if (item.isVar()) {
                            item = item.getFirstChild();
                        }
                        if (item.isName()) {
                            JSType narrowedKeyType;
                            JSType objIndexType;
                            JSType iterKeyType = this.getNativeType(JSTypeNative.STRING_TYPE);
                            ObjectType objType = this.getJSType(obj).dereference();
                            JSType jSType = objIndexType = objType == null ? null : objType.getIndexType();
                            if (objIndexType != null && !objIndexType.isUnknownType() && !(narrowedKeyType = iterKeyType.getGreatestSubtype(objIndexType)).isEmptyType()) {
                                iterKeyType = narrowedKeyType;
                            }
                            this.redeclareSimpleVar(informed, item, iterKeyType);
                        }
                        newScope = informed;
                        break;
                    }
                }
                case ON_FALSE: {
                    if (condition == null && (condition = NodeUtil.getConditionExpression(source)) == null && source.isCase()) {
                        condition = source;
                        if (conditionFlowScope == null) {
                            conditionFlowScope = this.traverse(condition.getFirstChild(), output.createChildFlowScope());
                        }
                    }
                    if (condition == null) break;
                    if (condition.isAnd() || condition.isOr()) {
                        if (conditionOutcomes == null) {
                            conditionOutcomes = condition.isAnd() ? this.traverseAnd(condition, output.createChildFlowScope()) : this.traverseOr(condition, output.createChildFlowScope());
                        }
                        newScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, conditionOutcomes.getOutcomeFlowScope(condition.getType(), branch == ControlFlowGraph.Branch.ON_TRUE), branch == ControlFlowGraph.Branch.ON_TRUE);
                        break;
                    }
                    if (conditionFlowScope == null) {
                        conditionFlowScope = this.traverse(condition, output.createChildFlowScope());
                    }
                    newScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, conditionFlowScope, branch == ControlFlowGraph.Branch.ON_TRUE);
                }
            }
            result.add(newScope.optimize());
        }
        return result;
    }

    private FlowScope traverse(Node n, FlowScope scope) {
        JSDocInfo info;
        switch (n.getType()) {
            case 86: {
                scope = this.traverseAssign(n, scope);
                break;
            }
            case 38: {
                scope = this.traverseName(n, scope);
                break;
            }
            case 33: {
                scope = this.traverseGetProp(n, scope);
                break;
            }
            case 101: {
                scope = this.traverseAnd(n, scope).getJoinedFlowScope().createChildFlowScope();
                break;
            }
            case 100: {
                scope = this.traverseOr(n, scope).getJoinedFlowScope().createChildFlowScope();
                break;
            }
            case 98: {
                scope = this.traverseHook(n, scope);
                break;
            }
            case 64: {
                scope = this.traverseObjectLiteral(n, scope);
                break;
            }
            case 37: {
                scope = this.traverseCall(n, scope);
                break;
            }
            case 30: {
                scope = this.traverseNew(n, scope);
                break;
            }
            case 21: 
            case 93: {
                scope = this.traverseAdd(n, scope);
                break;
            }
            case 28: 
            case 29: {
                scope = this.traverse(n.getFirstChild(), scope);
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case 63: {
                scope = this.traverseArrayLiteral(n, scope);
                break;
            }
            case 42: {
                n.setJSType((JSType)scope.getTypeOfThis());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 103: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case 83: {
                scope = this.traverse(n.getFirstChild(), scope);
                n.setJSType(this.getJSType(n.getFirstChild()));
                break;
            }
            case 85: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getJSType(n.getLastChild()));
                break;
            }
            case 32: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.STRING_TYPE));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                break;
            }
            case 35: {
                scope = this.traverseGetElem(n, scope);
                break;
            }
            case 130: {
                scope = this.traverseChildren(n, scope);
                if (!n.getFirstChild().isGetProp()) break;
                this.ensurePropertyDeclared(n.getFirstChild());
                break;
            }
            case 110: {
                scope = this.traverse(n.getFirstChild(), scope);
                break;
            }
            case 4: 
            case 49: 
            case 118: {
                scope = this.traverseChildren(n, scope);
                break;
            }
            case 120: {
                scope = this.traverseCatch(n, scope);
            }
        }
        if (n.getType() != 105 && (info = n.getJSDocInfo()) != null && info.hasType()) {
            JSType castType = info.getType().evaluate(this.syntacticScope, this.registry);
            if (n.isQualifiedName() && n.getParent().isExprResult()) {
                this.updateScopeForTypeChange(scope, n, n.getJSType(), castType);
            }
            n.setJSType(castType);
        }
        return scope;
    }

    private FlowScope traverseCatch(Node n, FlowScope scope) {
        Node name = n.getFirstChild();
        JSType type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        name.setJSType(type);
        this.redeclareSimpleVar(scope, name, type);
        return scope;
    }

    private FlowScope traverseAssign(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        scope = this.traverseChildren(n, scope);
        JSType leftType = left.getJSType();
        JSType rightType = this.getJSType(right);
        n.setJSType(rightType);
        this.updateScopeForTypeChange(scope, left, leftType, rightType);
        return scope;
    }

    private void updateScopeForTypeChange(FlowScope scope, Node left, JSType leftType, JSType resultType) {
        Preconditions.checkNotNull((Object)resultType);
        switch (left.getType()) {
            case 38: {
                String varName = left.getString();
                Scope.Var var = this.syntacticScope.getVar(varName);
                boolean isVarDeclaration = left.hasChildren();
                if (!isVarDeclaration || var == null || var.isTypeInferred()) {
                    this.redeclareSimpleVar(scope, left, resultType);
                }
                left.setJSType(isVarDeclaration || leftType == null ? resultType : null);
                if (var == null || !var.isTypeInferred()) break;
                JSType oldType = var.getType();
                var.setType(oldType == null ? resultType : oldType.getLeastSupertype(resultType));
                break;
            }
            case 33: {
                String qualifiedName = left.getQualifiedName();
                if (qualifiedName != null) {
                    scope.inferQualifiedSlot(left, qualifiedName, leftType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : leftType, resultType);
                }
                left.setJSType(resultType);
                this.ensurePropertyDefined(left, resultType);
            }
        }
    }

    private void ensurePropertyDefined(Node getprop, JSType rightType) {
        String propName = getprop.getLastChild().getString();
        JSType nodeType = this.getJSType(getprop.getFirstChild());
        ObjectType objectType = ObjectType.cast(nodeType.restrictByNotNullOrUndefined());
        if (objectType == null) {
            this.registry.registerPropertyOnType(propName, nodeType);
        } else {
            if (this.ensurePropertyDeclaredHelper(getprop, objectType)) {
                return;
            }
            if (!objectType.isPropertyTypeDeclared(propName)) {
                if (objectType.hasProperty(propName) || !objectType.isInstanceType()) {
                    if ("prototype".equals(propName)) {
                        objectType.defineDeclaredProperty(propName, rightType, getprop);
                    } else {
                        objectType.defineInferredProperty(propName, rightType, getprop);
                    }
                } else if (getprop.getFirstChild().isThis() && this.getJSType(this.syntacticScope.getRootNode()).isConstructor()) {
                    objectType.defineInferredProperty(propName, rightType, getprop);
                } else {
                    this.registry.registerPropertyOnType(propName, objectType);
                }
            }
        }
    }

    private void ensurePropertyDeclared(Node getprop) {
        ObjectType ownerType = ObjectType.cast(this.getJSType(getprop.getFirstChild()).restrictByNotNullOrUndefined());
        if (ownerType != null) {
            this.ensurePropertyDeclaredHelper(getprop, ownerType);
        }
    }

    private boolean ensurePropertyDeclaredHelper(Node getprop, ObjectType objectType) {
        Scope.Var var;
        String propName = getprop.getLastChild().getString();
        String qName = getprop.getQualifiedName();
        if (qName != null && (var = this.syntacticScope.getVar(qName)) != null && !var.isTypeInferred() && (propName.equals("prototype") || !objectType.hasOwnProperty(propName) && (!objectType.isInstanceType() || var.isExtern() && !objectType.isNativeObjectType()))) {
            return objectType.defineDeclaredProperty(propName, var.getType(), getprop);
        }
        return false;
    }

    private FlowScope traverseName(Node n, FlowScope scope) {
        String varName = n.getString();
        Node value = n.getFirstChild();
        JSType type = n.getJSType();
        if (value != null) {
            scope = this.traverse(value, scope);
            this.updateScopeForTypeChange(scope, n, n.getJSType(), this.getJSType(value));
            return scope;
        }
        StaticSlot var = scope.getSlot(varName);
        if (var != null) {
            boolean nonLocalInferredSlot;
            boolean isInferred = var.isTypeInferred();
            boolean unflowable = isInferred && this.isUnflowable(this.syntacticScope.getVar(varName));
            boolean bl = nonLocalInferredSlot = isInferred && this.syntacticScope.getParent() != null && var == this.syntacticScope.getParent().getSlot(varName);
            if (!unflowable && !nonLocalInferredSlot && (type = (JSType)var.getType()) == null) {
                type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
        }
        n.setJSType(type);
        return scope;
    }

    private FlowScope traverseArrayLiteral(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        return scope;
    }

    private FlowScope traverseObjectLiteral(Node n, FlowScope scope) {
        boolean hasLendsName;
        JSType type = n.getJSType();
        Preconditions.checkNotNull((Object)type);
        for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
            scope = this.traverse(name.getFirstChild(), scope);
        }
        ObjectType objectType = ObjectType.cast(type);
        if (objectType == null) {
            return scope;
        }
        boolean bl = hasLendsName = n.getJSDocInfo() != null && n.getJSDocInfo().getLendsName() != null;
        if (objectType.hasReferenceName() && !hasLendsName) {
            return scope;
        }
        for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
            Node value = name.getFirstChild();
            String memberName = NodeUtil.getObjectLitKeyName(name);
            if (memberName != null) {
                JSType rawValueType = name.getFirstChild().getJSType();
                JSType valueType = NodeUtil.getObjectLitKeyTypeFromValueType(name, rawValueType);
                if (valueType == null) {
                    valueType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                objectType.defineInferredProperty(memberName, valueType, name);
                continue;
            }
            n.setJSType(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }
        return scope;
    }

    private FlowScope traverseAdd(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        Node right = left.getNext();
        scope = this.traverseChildren(n, scope);
        JSType leftType = left.getJSType();
        JSType rightType = right.getJSType();
        JSType type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        if (leftType != null && rightType != null) {
            boolean leftIsUnknown = leftType.isUnknownType();
            boolean rightIsUnknown = rightType.isUnknownType();
            type = leftIsUnknown && rightIsUnknown ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (!leftIsUnknown && leftType.isString() || !rightIsUnknown && rightType.isString() ? this.getNativeType(JSTypeNative.STRING_TYPE) : (leftIsUnknown || rightIsUnknown ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (this.isAddedAsNumber(leftType) && this.isAddedAsNumber(rightType) ? this.getNativeType(JSTypeNative.NUMBER_TYPE) : this.registry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE))));
        }
        n.setJSType(type);
        if (n.getType() == 93) {
            this.updateScopeForTypeChange(scope, left, leftType, type);
        }
        return scope;
    }

    private boolean isAddedAsNumber(JSType type) {
        return type.isSubtype(this.registry.createUnionType(JSTypeNative.VOID_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.BOOLEAN_OBJECT_TYPE));
    }

    private FlowScope traverseHook(Node n, FlowScope scope) {
        Node condition = n.getFirstChild();
        Node trueNode = condition.getNext();
        Node falseNode = n.getLastChild();
        scope = this.traverse(condition, scope);
        FlowScope trueScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, true);
        FlowScope falseScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, false);
        this.traverse(trueNode, trueScope.createChildFlowScope());
        this.traverse(falseNode, falseScope.createChildFlowScope());
        JSType trueType = trueNode.getJSType();
        JSType falseType = falseNode.getJSType();
        if (trueType != null && falseType != null) {
            n.setJSType(trueType.getLeastSupertype(falseType));
        } else {
            n.setJSType(null);
        }
        return scope.createChildFlowScope();
    }

    private FlowScope traverseCall(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        Node left = n.getFirstChild();
        JSType functionType = this.getJSType(left).restrictByNotNullOrUndefined();
        if (functionType != null) {
            if (functionType.isFunctionType()) {
                FunctionType fnType = functionType.toMaybeFunctionType();
                n.setJSType(fnType.getReturnType());
                this.updateTypeOfParameters(n, fnType);
                this.updateTypeOfThisOnClosure(n, fnType);
            } else if (functionType.equals(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE))) {
                n.setJSType(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE));
            }
        }
        scope = this.tightenTypesAfterAssertions(scope, n);
        return scope;
    }

    private FlowScope tightenTypesAfterAssertions(FlowScope scope, Node callNode) {
        JSType narrowed;
        JSType type;
        Node left = callNode.getFirstChild();
        Node firstParam = left.getNext();
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionsMap.get(left.getQualifiedName());
        if (assertionFunctionSpec == null || firstParam == null) {
            return scope;
        }
        Node assertedNode = assertionFunctionSpec.getAssertedParam(firstParam);
        if (assertedNode == null) {
            return scope;
        }
        JSTypeNative assertedType = assertionFunctionSpec.getAssertedType();
        String assertedNodeName = assertedNode.getQualifiedName();
        if (assertedType == null) {
            if (assertedNodeName != null) {
                JSType narrowed2;
                JSType type2 = this.getJSType(assertedNode);
                if (type2 != (narrowed2 = type2.restrictByNotNullOrUndefined())) {
                    scope = this.narrowScope(scope, assertedNode, narrowed2);
                    callNode.setJSType(narrowed2);
                }
            } else if (assertedNode.isAnd() || assertedNode.isOr()) {
                BooleanOutcomePair conditionOutcomes = this.traverseWithinShortCircuitingBinOp(assertedNode, scope);
                scope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(assertedNode, conditionOutcomes.getOutcomeFlowScope(assertedNode.getType(), true), true);
            }
        } else if (assertedNodeName != null && (type = this.getJSType(assertedNode)) != (narrowed = type.getGreatestSubtype(this.getNativeType(assertedType)))) {
            scope = this.narrowScope(scope, assertedNode, narrowed);
            callNode.setJSType(narrowed);
        }
        return scope;
    }

    private FlowScope narrowScope(FlowScope scope, Node node, JSType narrowed) {
        scope = scope.createChildFlowScope();
        if (node.isGetProp()) {
            scope.inferQualifiedSlot(node, node.getQualifiedName(), this.getJSType(node), narrowed);
        } else {
            this.redeclareSimpleVar(scope, node, narrowed);
        }
        return scope;
    }

    private void updateTypeOfParameters(Node n, FunctionType fnType) {
        int i = 0;
        int childCount = n.getChildCount();
        for (Node iParameter : fnType.getParameters()) {
            if (i + 1 >= childCount) {
                return;
            }
            JSType iParameterType = this.getJSType(iParameter);
            Node iArgument = n.getChildAtIndex(i + 1);
            JSType iArgumentType = this.getJSType(iArgument);
            this.inferPropertyTypesToMatchConstraint(iArgumentType, iParameterType);
            if (iParameterType.isFunctionType()) {
                FunctionType iParameterFnType = iParameterType.toMaybeFunctionType();
                if (iArgument.isFunction() && iArgumentType.isFunctionType() && iArgument.getJSDocInfo() == null) {
                    iArgument.setJSType(iParameterFnType);
                }
            }
            ++i;
        }
    }

    private void updateTypeOfThisOnClosure(Node n, FunctionType fnType) {
        if (fnType.getTemplateTypeName() == null) {
            return;
        }
        int i = 0;
        int childCount = n.getChildCount();
        for (Node iParameter : fnType.getParameters()) {
            JSType iParameterType = this.getJSType(iParameter).restrictByNotNullOrUndefined();
            if (iParameterType.isTemplateType()) {
                Node iArgument;
                ObjectType iArgumentType = null;
                if (i + 1 < childCount && (iArgumentType = this.getJSType(iArgument = n.getChildAtIndex(i + 1)).restrictByNotNullOrUndefined().collapseUnion().toObjectType()) == null) {
                    this.compiler.report(JSError.make(NodeUtil.getSourceName(iArgument), iArgument, TEMPLATE_TYPE_NOT_OBJECT_TYPE, this.getJSType(iArgument).toString()));
                    return;
                }
                boolean foundTemplateTypeOfThisParameter = false;
                int j = 0;
                for (Node jParameter : fnType.getParameters()) {
                    FunctionType jParameterFnType;
                    JSType jParameterType = this.getJSType(jParameter).restrictByNotNullOrUndefined();
                    if (jParameterType.isFunctionType() && (jParameterFnType = jParameterType.toMaybeFunctionType()).getTypeOfThis().equals(iParameterType)) {
                        foundTemplateTypeOfThisParameter = true;
                        if (j + 1 >= childCount) {
                            return;
                        }
                        Node jArgument = n.getChildAtIndex(j + 1);
                        JSType jArgumentType = this.getJSType(jArgument);
                        if (jArgument.isFunction() && jArgumentType.isFunctionType()) {
                            if (iArgumentType != null && !iArgumentType.isNoType()) {
                                FunctionType jArgumentFnType = jArgumentType.toMaybeFunctionType();
                                if (jArgumentFnType.getTypeOfThis().isUnknownType()) {
                                    jArgument.setJSType(this.registry.createFunctionTypeWithNewThisType(jArgumentFnType, iArgumentType));
                                }
                            } else if (NodeUtil.referencesThis(NodeUtil.getFunctionBody(jArgument))) {
                                this.compiler.report(JSError.make(NodeUtil.getSourceName(n), n, FUNCTION_LITERAL_UNDEFINED_THIS, new String[0]));
                            }
                        }
                    }
                    ++j;
                }
                if (!foundTemplateTypeOfThisParameter) {
                    this.compiler.report(JSError.make(NodeUtil.getSourceName(n), n, TEMPLATE_TYPE_OF_THIS_EXPECTED, new String[0]));
                    return;
                }
            }
            ++i;
        }
    }

    private FlowScope traverseNew(Node n, FlowScope scope) {
        Node constructor = n.getFirstChild();
        scope = this.traverse(constructor, scope);
        JSType constructorType = constructor.getJSType();
        JSType type = null;
        if (constructorType != null) {
            if ((constructorType = constructorType.restrictByNotNullOrUndefined()).isUnknownType()) {
                type = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            } else {
                FunctionType ct = constructorType.toMaybeFunctionType();
                if (ct == null && constructorType instanceof FunctionType) {
                    ct = (FunctionType)constructorType;
                }
                if (ct != null && ct.isConstructor()) {
                    type = ct.getInstanceType();
                }
            }
        }
        n.setJSType(type);
        for (Node arg = constructor.getNext(); arg != null; arg = arg.getNext()) {
            scope = this.traverse(arg, scope);
        }
        return scope;
    }

    private BooleanOutcomePair traverseAnd(Node n, FlowScope scope) {
        return this.traverseShortCircuitingBinOp(n, scope, true);
    }

    private FlowScope traverseChildren(Node n, FlowScope scope) {
        for (Node el = n.getFirstChild(); el != null; el = el.getNext()) {
            scope = this.traverse(el, scope);
        }
        return scope;
    }

    private FlowScope traverseGetElem(Node n, FlowScope scope) {
        JSType type;
        scope = this.traverseChildren(n, scope);
        ObjectType objType = ObjectType.cast(this.getJSType(n.getFirstChild()).restrictByNotNullOrUndefined());
        if (objType != null && (type = objType.getParameterType()) != null) {
            n.setJSType(type);
        }
        return this.dereferencePointer(n.getFirstChild(), scope);
    }

    private FlowScope traverseGetProp(Node n, FlowScope scope) {
        Node objNode = n.getFirstChild();
        Node property = n.getLastChild();
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.getPropertyType(objNode.getJSType(), property.getString(), n, scope));
        return this.dereferencePointer(n.getFirstChild(), scope);
    }

    private void inferPropertyTypesToMatchConstraint(JSType type, JSType constraint) {
        ObjectType objType;
        ObjectType constraintObj = ObjectType.cast(constraint.restrictByNotNullOrUndefined());
        if (constraintObj != null && constraintObj.isRecordType() && (objType = ObjectType.cast(type.restrictByNotNullOrUndefined())) != null) {
            for (String prop : constraintObj.getOwnPropertyNames()) {
                JSType propType = constraintObj.getPropertyType(prop);
                if (objType.isPropertyTypeDeclared(prop)) continue;
                JSType typeToInfer = propType;
                if (!objType.hasProperty(prop)) {
                    typeToInfer = this.getNativeType(JSTypeNative.VOID_TYPE).getLeastSupertype(propType);
                }
                objType.defineInferredProperty(prop, typeToInfer, null);
            }
        }
    }

    private FlowScope dereferencePointer(Node n, FlowScope scope) {
        JSType narrowed;
        JSType type;
        if (n.isQualifiedName() && (type = this.getJSType(n)) != (narrowed = type.restrictByNotNullOrUndefined())) {
            scope = this.narrowScope(scope, n, narrowed);
        }
        return scope;
    }

    private JSType getPropertyType(JSType objType, String propName, Node n, FlowScope scope) {
        ObjectType regType;
        JSType varType;
        String qualifiedName = n.getQualifiedName();
        StaticSlot var = scope.getSlot(qualifiedName);
        if (var != null && (varType = (JSType)var.getType()) != null) {
            if (varType.equals(this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) && var != this.syntacticScope.getSlot(qualifiedName)) {
                return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            return varType;
        }
        JSType propertyType = null;
        if (objType != null) {
            propertyType = objType.findPropertyType(propName);
        }
        if ((propertyType == null || propertyType.isUnknownType()) && qualifiedName != null && (regType = ObjectType.cast(this.registry.getType(qualifiedName))) != null) {
            propertyType = regType.getConstructor();
        }
        return propertyType;
    }

    private BooleanOutcomePair traverseOr(Node n, FlowScope scope) {
        return this.traverseShortCircuitingBinOp(n, scope, false);
    }

    private BooleanOutcomePair traverseShortCircuitingBinOp(Node n, FlowScope scope, boolean condition) {
        BooleanOutcomePair literals;
        JSType type;
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        BooleanOutcomePair leftLiterals = this.traverseWithinShortCircuitingBinOp(left, scope.createChildFlowScope());
        JSType leftType = left.getJSType();
        FlowScope rightScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(left, leftLiterals.getOutcomeFlowScope(left.getType(), condition), condition);
        BooleanOutcomePair rightLiterals = this.traverseWithinShortCircuitingBinOp(right, rightScope.createChildFlowScope());
        JSType rightType = right.getJSType();
        if (leftType != null && rightType != null) {
            leftType = leftType.getRestrictedTypeGivenToBooleanOutcome(!condition);
            if (leftLiterals.toBooleanOutcomes == BooleanLiteralSet.get(!condition)) {
                type = leftType;
                literals = leftLiterals;
            } else {
                type = leftType.getLeastSupertype(rightType);
                literals = this.getBooleanOutcomePair(leftLiterals, rightLiterals, condition);
            }
            if (literals.booleanValues == BooleanLiteralSet.EMPTY && this.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtype(type) && type.isUnionType()) {
                type = type.toMaybeUnionType().getRestrictedUnion(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
            }
        } else {
            type = null;
            literals = new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, leftLiterals.getJoinedFlowScope(), rightLiterals.getJoinedFlowScope());
        }
        n.setJSType(type);
        return literals;
    }

    private BooleanOutcomePair traverseWithinShortCircuitingBinOp(Node n, FlowScope scope) {
        switch (n.getType()) {
            case 101: {
                return this.traverseAnd(n, scope);
            }
            case 100: {
                return this.traverseOr(n, scope);
            }
        }
        scope = this.traverse(n, scope);
        return this.newBooleanOutcomePair(n.getJSType(), scope);
    }

    BooleanOutcomePair getBooleanOutcomePair(BooleanOutcomePair left, BooleanOutcomePair right, boolean condition) {
        return new BooleanOutcomePair(TypeInference.getBooleanOutcomes(left.toBooleanOutcomes, right.toBooleanOutcomes, condition), TypeInference.getBooleanOutcomes(left.booleanValues, right.booleanValues, condition), left.getJoinedFlowScope(), right.getJoinedFlowScope());
    }

    static BooleanLiteralSet getBooleanOutcomes(BooleanLiteralSet left, BooleanLiteralSet right, boolean condition) {
        return right.union(left.intersection(BooleanLiteralSet.get(!condition)));
    }

    private BooleanOutcomePair newBooleanOutcomePair(JSType jsType, FlowScope flowScope) {
        if (jsType == null) {
            return new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, flowScope, flowScope);
        }
        return new BooleanOutcomePair(jsType.getPossibleToBooleanOutcomes(), this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtype(jsType) ? BooleanLiteralSet.BOTH : BooleanLiteralSet.EMPTY, flowScope, flowScope);
    }

    private void redeclareSimpleVar(FlowScope scope, Node nameNode, JSType varType) {
        Preconditions.checkState((boolean)nameNode.isName());
        String varName = nameNode.getString();
        if (varType == null) {
            varType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.isUnflowable(this.syntacticScope.getVar(varName))) {
            return;
        }
        scope.inferSlotType(varName, varType);
    }

    private boolean isUnflowable(Scope.Var v) {
        return v != null && v.isLocal() && v.isMarkedEscaped() && v.getScope() == this.syntacticScope;
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    private final class BooleanOutcomePair {
        final BooleanLiteralSet toBooleanOutcomes;
        final BooleanLiteralSet booleanValues;
        final FlowScope leftScope;
        final FlowScope rightScope;
        FlowScope joinedScope = null;

        BooleanOutcomePair(BooleanLiteralSet toBooleanOutcomes, BooleanLiteralSet booleanValues, FlowScope leftScope, FlowScope rightScope) {
            this.toBooleanOutcomes = toBooleanOutcomes;
            this.booleanValues = booleanValues;
            this.leftScope = leftScope;
            this.rightScope = rightScope;
        }

        FlowScope getJoinedFlowScope() {
            if (this.joinedScope == null) {
                this.joinedScope = this.leftScope == this.rightScope ? this.rightScope : TypeInference.this.join(this.leftScope, this.rightScope);
            }
            return this.joinedScope;
        }

        FlowScope getOutcomeFlowScope(int nodeType, boolean outcome) {
            if (nodeType == 101 && outcome || nodeType == 100 && !outcome) {
                return this.rightScope;
            }
            return this.getJoinedFlowScope();
        }
    }
}

