/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

public final class MathVariantMap {
    private static final int MIN_CODEPOINT = 32;
    private static final int MAX_CODEPOINT = 128;
    private final String mathVariantName;
    private final char[] accentByCodePoint;

    public MathVariantMap(String mathVariantName, char[] accentData) {
        this.mathVariantName = mathVariantName;
        this.accentByCodePoint = new char[96];
        int i = 0;
        while (i < accentData.length) {
            char ascii = accentData[i++];
            char accented = accentData[i++];
            int index = this.charToIndex(ascii);
            if (index == -1) continue;
            this.accentByCodePoint[index] = accented;
        }
    }

    public String getMathVariantName() {
        return this.mathVariantName;
    }

    public char getAccentedChar(char c) {
        int index = this.charToIndex(c);
        return index != -1 ? this.accentByCodePoint[index] : (char)'\u0000';
    }

    private int charToIndex(char c) {
        int index = c - 32;
        return index >= 0 && index < 128 ? index : -1;
    }
}

