/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.owasp.html.Handler;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.PolicyFactory;
import org.owasp.html.TagBalancingHtmlStreamEventReceiver;

public class UrlTextExample {
    public static void run(Appendable out, String ... inputs) throws IOException {
        PolicyFactory policyBuilder = new HtmlPolicyBuilder().allowAttributes("src").onElements("img").allowAttributes("href").onElements("a").allowStandardUrlProtocols().allowElements("a", "label", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "small", "big", "pre", "code", "cite", "samp", "sub", "sup", "strike", "center", "blockquote", "hr", "br", "col", "font", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "fieldset", "legend").toFactory();
        StringBuilder htmlOut = new StringBuilder();
        HtmlSanitizer.Policy policy = policyBuilder.apply(new TagBalancingHtmlStreamEventReceiver(new AppendDomainAfterText(HtmlStreamRenderer.create(htmlOut, Handler.DO_NOTHING))));
        for (String input : inputs) {
            HtmlSanitizer.sanitize(input, policy);
        }
        out.append(htmlOut);
    }

    public static void main(String ... argv) throws IOException {
        UrlTextExample.run(System.out, argv);
        System.out.println();
    }

    static String domainOf(String url) {
        int start = -1;
        if (url.startsWith("//")) {
            start = 2;
        } else {
            start = url.indexOf("://");
            if (start >= 0) {
                start += 3;
            }
        }
        if (start < 0) {
            return null;
        }
        for (int i = 0; i < start - 3; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    return null;
                }
            }
        }
        int end = url.length();
        block7: for (int i = start; i < end; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    end = i;
                    continue block7;
                }
            }
        }
        if (start < end) {
            return url.substring(start, end);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppendDomainAfterText
    implements HtmlStreamEventReceiver {
        final HtmlStreamEventReceiver underlying;
        private final List<String> pendingText = new ArrayList<String>();

        AppendDomainAfterText(HtmlStreamEventReceiver underlying) {
            this.underlying = underlying;
        }

        @Override
        public void openDocument() {
            this.underlying.openDocument();
        }

        @Override
        public void closeDocument() {
            this.underlying.closeDocument();
        }

        @Override
        public void openTag(String elementName, List<String> attribs) {
            this.underlying.openTag(elementName, attribs);
            String trailingText = null;
            if (!attribs.isEmpty()) {
                String urlAttrName = null;
                if ("a".equals(elementName)) {
                    urlAttrName = "href";
                } else if ("img".equals(elementName)) {
                    urlAttrName = "src";
                }
                if (urlAttrName != null) {
                    int n = attribs.size();
                    for (int i = 0; i < n; i += 2) {
                        if (!urlAttrName.equals(attribs.get(i))) continue;
                        String url = attribs.get(i + 1).trim();
                        String domain = UrlTextExample.domainOf(url);
                        if (domain == null) break;
                        trailingText = " - " + domain;
                        break;
                    }
                }
            }
            if (HtmlTextEscapingMode.isVoidElement(elementName)) {
                if (trailingText != null) {
                    this.text(trailingText);
                }
            } else {
                this.pendingText.add(trailingText);
            }
        }

        @Override
        public void closeTag(String elementName) {
            String trailingText;
            this.underlying.closeTag(elementName);
            int pendingTextSize = this.pendingText.size();
            if (pendingTextSize != 0 && (trailingText = this.pendingText.remove(pendingTextSize - 1)) != null) {
                this.text(trailingText);
            }
        }

        @Override
        public void text(String text) {
            this.underlying.text(text);
        }
    }
}

