/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.webui.UIAvatarUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.social.webui.space.UISpaceMember;
import org.exoplatform.social.webui.space.UISpacePermission;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/space/UISpaceInfo.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.PROCESS), @EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UISpaceInfo
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UISpaceInfo.class);
    public static final String SPACE_ID = "id";
    private static final String SPACE_DISPLAY_NAME = "displayName";
    private static final String SPACE_DESCRIPTION = "description";
    private static final String SPACE_TEMPLATES_FEATURE = "space-templates";
    private static final String SPACE_TEMPLATE = "template";
    private static final String SPACE_TAG = "tag";
    private SpaceService spaceService = null;
    private SpaceTemplateService spaceTemplateService = null;
    private ExoFeatureService featureService = null;
    private boolean isSpaceTemplatesActive;
    private static final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    private static final String HTML_ATTRIBUTE_PLACEHOLDER = "placeholder";

    public UISpaceInfo() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        UIFormStringInput spaceId = (UIFormStringInput)new UIFormStringInput(SPACE_ID, SPACE_ID, null).setRendered(false);
        spaceId.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceInfo.label.SpaceId"));
        this.addUIFormInput((UIFormInput)spaceId);
        UIFormStringInput spaceDisplayName = new UIFormStringInput(SPACE_DISPLAY_NAME, SPACE_DISPLAY_NAME, null);
        spaceDisplayName.setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, resourceBundle.getString("UISpaceSettings.label.spaceDisplayName"));
        this.addUIFormInput((UIFormInput)spaceDisplayName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\s\\d']+[\\s]?)+$", "UISpaceInfo.msg.name-invalid"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        UIFormTextAreaInput description = new UIFormTextAreaInput(SPACE_DESCRIPTION, SPACE_DESCRIPTION, null);
        description.setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, resourceBundle.getString("UISpaceSettings.label.spaceDescription"));
        this.addUIFormInput((UIFormInput)description.addValidator(StringLengthValidator.class, new Object[]{0, 255}));
        List<SelectItemOption<String>> templates = this.getSpaceTemplatesOptions();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SPACE_TEMPLATE, SPACE_TEMPLATE, templates).setDisabled(true));
        UIFormStringInput tag = (UIFormStringInput)new UIFormStringInput(SPACE_TAG, SPACE_TAG, null).setRendered(false);
        tag.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceInfo.label.tag"));
        this.addUIFormInput((UIFormInput)tag);
        PopupContainer popupContainer = (PopupContainer)this.createUIComponent(PopupContainer.class, null, null);
        this.addChild((UIComponent)popupContainer);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIFormSelectBox uiFormTypesSelectBox = this.getUIFormSelectBox(SPACE_TEMPLATE);
        this.isSpaceTemplatesActive = this.getFeatureService().isActiveFeature(SPACE_TEMPLATES_FEATURE);
        Space space = this.getSpace();
        String templateName = space.getTemplate();
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(templateName);
        templateName = spaceTemplate == null ? this.spaceTemplateService.getDefaultSpaceTemplate() : spaceTemplate.getName();
        uiFormTypesSelectBox.setValue(templateName);
        uiFormTypesSelectBox.setRendered(this.isSpaceTemplatesActive);
        super.processRender(context);
    }

    private List<SelectItemOption<String>> getSpaceTemplatesOptions() {
        ArrayList<SelectItemOption<String>> templates = new ArrayList<SelectItemOption<String>>();
        for (SpaceTemplate spaceTemplate : this.getSpaceTemplateService().getSpaceTemplates()) {
            String spaceType = spaceTemplate.getName();
            String translation = null;
            try {
                ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
                String key = "space.template." + spaceType;
                translation = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                translation = StringUtils.capitalize((String)spaceType);
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not get resource bundle.");
            }
            SelectItemOption option = new SelectItemOption(translation, (Object)spaceType);
            templates.add((SelectItemOption<String>)option);
        }
        return templates;
    }

    protected void setCurrentSpace(Space space) throws Exception {
        UITabPane uiTabPane = (UITabPane)this.getAncestorOfType(UITabPane.class);
        uiTabPane.setSelectedTab(1);
        UISpaceInfo uiSpaceInfo = (UISpaceInfo)uiTabPane.findFirstComponentOfType(UISpaceInfo.class);
        uiSpaceInfo.setValue(space);
        UISpaceMember uiSpaceMember = (UISpaceMember)uiTabPane.findFirstComponentOfType(UISpaceMember.class);
        uiSpaceMember.setValue(space.getId());
        uiSpaceMember.setSpaceURL(space.getUrl());
        UISpaceApplication uiSpaceApplication = (UISpaceApplication)uiTabPane.findFirstComponentOfType(UISpaceApplication.class);
        uiSpaceApplication.setValue(space);
        UISpacePermission uiSpacePermission = (UISpacePermission)uiTabPane.findFirstComponentOfType(UISpacePermission.class);
        uiSpacePermission.setValue(space);
    }

    public void setValue(Space space) throws Exception {
        this.invokeGetBindingBean(space);
        UIFormTextAreaInput description = this.getUIFormTextAreaInput(SPACE_DESCRIPTION);
        description.setValue((Object)StringEscapeUtils.unescapeHtml((String)((String)description.getValue())));
        this.getUIStringInput(SPACE_TAG).setValue((Object)space.getTag());
    }

    protected Space getSpace() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String id = (String)this.getUIStringInput(SPACE_ID).getValue();
        Space space = spaceService.getSpaceById(id);
        return space;
    }

    protected boolean isSpaceTemplatesActive() {
        return this.isSpaceTemplatesActive;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public SpaceTemplateService getSpaceTemplateService() {
        if (this.spaceTemplateService == null) {
            this.spaceTemplateService = (SpaceTemplateService)this.getApplicationComponent(SpaceTemplateService.class);
        }
        return this.spaceTemplateService;
    }

    protected ExoFeatureService getFeatureService() {
        if (this.featureService == null) {
            this.featureService = (ExoFeatureService)this.getApplicationComponent(ExoFeatureService.class);
        }
        return this.featureService;
    }

    public OrganizationService getOrganizationService() {
        return (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    }

    public DataStorage getDataSource() {
        return (DataStorage)this.getApplicationComponent(DataStorage.class);
    }

    private UserNode renamePageNode(String newNodeLabel, Space space) {
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
        try {
            UserNode renamedNode = SpaceUtils.getSpaceUserNode((Space)space);
            UserNode parentNode = renamedNode.getParent();
            String newNodeName = SpaceUtils.cleanString((String)newNodeLabel);
            if (parentNode.getChild(newNodeName) != null) {
                newNodeName = newNodeName + "_" + System.currentTimeMillis();
            }
            renamedNode.setLabel(newNodeLabel);
            renamedNode.setName(newNodeName);
            Page page = dataService.getPage(renamedNode.getPageRef().format());
            if (page != null) {
                page.setTitle(newNodeLabel);
                dataService.save(page);
            }
            SpaceUtils.getUserPortal().saveNode(parentNode, null);
            space.setUrl(newNodeName);
            SpaceUtils.changeSpaceUrlPreference((UserNode)renamedNode, (Space)space, (String)newNodeLabel);
            SpaceUtils.changeAppPageTitle((UserNode)renamedNode, (String)newNodeLabel);
            ArrayList userNodes = new ArrayList(renamedNode.getChildren());
            for (UserNode childNode : userNodes) {
                SpaceUtils.changeSpaceUrlPreference((UserNode)childNode, (Space)space, (String)newNodeLabel);
                SpaceUtils.changeAppPageTitle((UserNode)childNode, (String)newNodeLabel);
            }
            return renamedNode;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static class ChangeAvatarActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            PopupContainer popupContainer = (PopupContainer)uiSpaceInfo.getChild(PopupContainer.class);
            popupContainer.activate(UIAvatarUploader.class, 500, UISpaceInfo.POPUP_AVATAR_UPLOADER);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }

    public static class SaveActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            SpaceService spaceService = uiSpaceInfo.getSpaceService();
            UIPortal uiPortal = Util.getUIPortal();
            String id = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_ID).getValue();
            String name = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).getValue();
            Space space = spaceService.getSpaceById(id);
            if (space == null) {
                event.getRequestContext().sendRedirect(Utils.getURI("all-spaces"));
                return;
            }
            String displayName = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).getValue();
            String spaceDescription = (String)uiSpaceInfo.getUIFormTextAreaInput(UISpaceInfo.SPACE_DESCRIPTION).getValue();
            String oldDisplayName = space.getDisplayName();
            String oldDescription = space.getDescription();
            UserNode selectedNode = uiPortal.getSelectedUserNode();
            UserNode renamedNode = null;
            boolean nameChanged = !space.getDisplayName().equals(name);
            UIPortletApplication uiApp = (UIPortletApplication)uiSpaceInfo.getAncestorOfType(UIPortletApplication.class);
            if (nameChanged) {
                String cleanedString = SpaceUtils.cleanString((String)name);
                if (spaceService.getSpaceByUrl(cleanedString) != null) {
                    uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).setValue((Object)oldDisplayName);
                    uiSpaceInfo.getUIFormTextAreaInput(UISpaceInfo.SPACE_DESCRIPTION).setValue((Object)oldDescription);
                    uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.current-name-exist", null, 2));
                    return;
                }
                renamedNode = uiSpaceInfo.renamePageNode(name, space);
                if (renamedNode == null) {
                    return;
                }
            }
            uiSpaceInfo.invokeSetBindingBean(space);
            space.setDisplayName(displayName);
            spaceDescription = StringEscapeUtils.escapeHtml((String)spaceDescription);
            space.setDescription(spaceDescription);
            if (oldDescription != null && !oldDescription.equals(spaceDescription)) {
                space.setField(Space.UpdatedField.DESCRIPTION);
            }
            space.setEditor(Utils.getViewerRemoteId());
            if (nameChanged) {
                space.setDisplayName(oldDisplayName);
                String remoteId = Utils.getViewerRemoteId();
                spaceService.renameSpace(remoteId, space, displayName);
                OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
                GroupHandler groupHandler = organizationService.getGroupHandler();
                Group group = groupHandler.findGroupById(space.getGroupId());
                group.setLabel(space.getDisplayName());
                groupHandler.saveGroup(group, true);
            } else {
                spaceService.updateSpace(space);
            }
            if (nameChanged) {
                if (renamedNode != null) {
                    selectedNode = renamedNode;
                    PortalRequestContext prContext = Util.getPortalRequestContext();
                    ((NodeURL)prContext.createURL(NodeURL.TYPE)).setNode(selectedNode);
                    event.getRequestContext().sendRedirect(Utils.getSpaceURL(selectedNode));
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.update-success", null, 2));
            }
        }
    }
}

