/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.formula;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.formula.FormulaRenderer;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.formula.FormulaMacroConfiguration;
import org.xwiki.rendering.macro.formula.FormulaMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="formula")
@Singleton
public class FormulaMacro
extends AbstractMacro<FormulaMacroParameters> {
    public static final String CONTENT_MISSING_ERROR = "The mandatory formula text is missing.";
    public static final String WRONG_CONTENT_ERROR = "The formula text is not valid, please correct it.";
    private static final String DESCRIPTION = "Displays a mathematical formula.";
    private static final String CONTENT_DESCRIPTION = "The mathematical formula, in LaTeX syntax";
    @Inject
    private ComponentManager manager;
    @Inject
    private FormulaMacroConfiguration configuration;
    @Inject
    private DocumentAccessBridge dab;
    @Inject
    private Logger logger;

    public FormulaMacro() {
        super("Formula", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), FormulaMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(FormulaMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        Block result;
        if (StringUtils.isEmpty((CharSequence)content)) {
            throw new MacroExecutionException(CONTENT_MISSING_ERROR);
        }
        String rendererHint = this.configuration.getRenderer();
        FormulaRenderer.FontSize size = parameters.getFontSize();
        FormulaRenderer.Type type = parameters.getImageType();
        try {
            result = this.render(content, context.isInline(), size, type, rendererHint);
        }
        catch (MacroExecutionException ex) {
            this.logger.debug("Failed to render content with the [{}] renderer. Falling back to the safe renderer.", (Object)rendererHint, (Object)ex);
            try {
                result = this.render(content, context.isInline(), size, type, this.configuration.getSafeRenderer());
            }
            catch (IllegalArgumentException ex2) {
                throw new MacroExecutionException(WRONG_CONTENT_ERROR);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MacroExecutionException(WRONG_CONTENT_ERROR);
        }
        if (result == null) {
            result = new WordBlock(content);
        }
        if (!context.isInline()) {
            result = new ParagraphBlock(Collections.singletonList(result));
        }
        return Collections.singletonList(result);
    }

    private Block render(String formula, boolean inline, FormulaRenderer.FontSize fontSize, FormulaRenderer.Type imageType, String rendererHint) throws MacroExecutionException, IllegalArgumentException {
        try {
            FormulaRenderer renderer = (FormulaRenderer)this.manager.getInstance(FormulaRenderer.class, rendererHint);
            String imageName = renderer.process(formula, inline, fontSize, imageType);
            AttachmentReference attachmentReference = new AttachmentReference(imageName, this.dab.getCurrentDocumentReference());
            String url = this.dab.getAttachmentURL(attachmentReference, false);
            url = url.replace("/download/", "/tex/");
            ResourceReference imageReference = new ResourceReference(url, ResourceType.URL);
            ImageBlock result = new ImageBlock(imageReference, false);
            result.setParameter("alt", formula);
            return result;
        }
        catch (Exception e) {
            throw new MacroExecutionException(String.format("Failed to render formula using the [%s] renderer", rendererHint), (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

