/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ActivityDAOImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamType;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.ActivityStorageException;

public class ActivityDAOImpl
extends GenericDAOJPAImpl<ActivityEntity, Long>
implements ActivityDAO {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public List<Long> getActivities(Identity owner, Identity viewer, long offset, long limit) throws ActivityStorageException {
        long ownerId = Long.parseLong(owner.getId());
        TypedQuery query = null;
        if (viewer != null && !viewer.getId().equals(owner.getId())) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwnerAndProviderId", Tuple.class);
            query.setParameter("providerId", (Object)"organization");
        } else {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwner", Tuple.class);
        }
        query.setParameter("owners", Collections.singleton(ownerId));
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<String> getUserIdsActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        long ownerId = Long.parseLong(owner.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityIdsByOwner", Tuple.class);
        query.setParameter("owners", Collections.singleton(ownerId));
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public List<Long> getActivityFeed(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getActivityFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<String> getActivityIdsFeed(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getActivityIdsFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfActivitesOnActivityFeed(Identity ownerIdentity, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getNumberOfActivitesOnActivityFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        owners.add(ownerId);
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnActivityFeed(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getNewerActivityFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getNumberOfNewerOnActivityFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnActivityFeed(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getOlderActivityFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        String queryName = "SocActivity.getNumberOfOlderOnActivityFeed";
        if (connections.isEmpty()) {
            queryName = queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.valueOf(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getUserActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        return this.getOwnerActivities(Arrays.asList(owner.getId()), -1L, -1L, offset, limit);
    }

    @Override
    public int getNumberOfUserActivities(Identity ownerIdentity) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfActivitiesByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnUserActivities(Identity ownerIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(ownerIdentity.getId()), sinceTime, -1L, 0L, limit);
    }

    @Override
    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerActivityByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        query.setParameter("sinceTime", (Object)sinceTime);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnUserActivities(Identity ownerIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(ownerIdentity.getId()), -1L, sinceTime, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderActivityByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        query.setParameter("sinceTime", (Object)sinceTime);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getSpaceActivities(Identity spaceOwner, long offset, long limit) throws ActivityStorageException {
        return this.getOwnerActivities(Arrays.asList(spaceOwner.getId()), -1L, -1L, offset, limit);
    }

    @Override
    public List<String> getSpaceActivityIds(Identity spaceIdentity, long offset, long limit) throws ActivityStorageException {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityIdsByOwner", Tuple.class);
        query.setParameter("owners", Collections.singleton(ownerId));
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfSpaceActivities(Identity spaceIdentity) {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfActivitiesByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnSpaceActivities(Identity spaceIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(spaceIdentity.getId()), sinceTime, -1L, 0L, limit);
    }

    @Override
    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, long sinceTime) {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", Collections.singleton(ownerId));
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnSpaceActivities(Identity spaceIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(spaceIdentity.getId()), -1L, sinceTime, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnSpaceActivities(Identity spaceIdentity, long sinceTime) {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", Collections.singleton(ownerId));
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getUserSpacesActivities(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, -1L, -1L, offset, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getUserSpacesActivityIds(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : spaceIds) {
            ids.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityIdsByOwner", Tuple.class);
        query.setParameter("owners", ids);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfUserSpacesActivities(Identity ownerIdentity, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return 0;
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfActivitesOnActivityFeedNoConnections", Long.class);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, sinceTime, -1L, 0L, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return 0;
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, -1L, sinceTime, 0L, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return 0;
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityOfConnection", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<String> getActivityIdsOfConnections(Identity ownerIdentity, int offset, int limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<String> connections = this.getConnectionIdsInString(ownerId);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityIdsOfConnections", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfActivitiesOfConnections(Identity ownerIdentity) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<String> connections = this.getConnectionIdsInString(ownerId);
        if (connections.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.numberOfActivitiesOfConnections", Long.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime, long limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityOfConnection", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        query.setParameter("sinceTime", (Object)sinceTime);
        if (limit > 0L) {
            query.setFirstResult(0);
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        if (connections.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerOnActivitiesOfConnections", Long.class);
        query.setParameter("connections", connections);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime, int limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityOfConnection", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        query.setParameter("sinceTime", (Object)sinceTime);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.getConnectionIds(ownerId);
        if (connections.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderOnActivitiesOfConnections", Long.class);
        query.setParameter("connections", connections);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getActivitiesByPoster(Identity posterIdentity, int offset, int limit, String ... activityTypes) {
        String queryName = "SocActivity.getActivitiesByPoster";
        ArrayList<String> types = new ArrayList<String>();
        if (activityTypes != null && activityTypes.length > 0) {
            types.addAll(Arrays.asList(activityTypes));
        } else {
            queryName = queryName + "NoTypes";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Tuple.class);
        if (!types.isEmpty()) {
            query.setParameter("types", types);
        }
        query.setParameter("owner", (Object)posterIdentity.getId());
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfActivitiesByPoster(Identity posterIdentity, String ... activityTypes) {
        String queryName = "SocActivity.getNumberOfActivitiesByPoster";
        ArrayList<String> types = new ArrayList<String>();
        if (activityTypes != null && activityTypes.length > 0) {
            types.addAll(Arrays.asList(activityTypes));
        } else {
            queryName = queryName + "NoTypes";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        if (!types.isEmpty()) {
            query.setParameter("types", types);
        }
        query.setParameter("owner", (Object)posterIdentity.getId());
        return ((Long)query.getSingleResult()).intValue();
    }

    private List<Long> convertActivityEntitiesToIds(List<Tuple> list) {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        if (list == null) {
            return Collections.emptyList();
        }
        for (Tuple t : list) {
            ids.add((Long)t.get(0));
        }
        return new LinkedList<Long>(ids);
    }

    private List<String> convertActivityEntitiesToIdsString(List<Tuple> list) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        if (list == null) {
            return Collections.emptyList();
        }
        for (Tuple t : list) {
            ids.add(String.valueOf(t.get(0)));
        }
        return new LinkedList<String>(ids);
    }

    @Override
    public long getNumberOfComments(long activityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.numberCommentsOfActivity", Long.class);
        query.setParameter("activityId", (Object)activityId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<ActivityEntity> findCommentsOfActivities(List<Long> ids) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findCommentsOfActivities", ActivityEntity.class);
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getComments(long activityId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getNewerComments(long activityId, Date sinceTime, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findNewerCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        query.setParameter("sinceTime", (Object)(sinceTime != null ? sinceTime.getTime() : 0L));
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getOlderComments(long activityId, Date sinceTime, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findOlderCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        query.setParameter("sinceTime", (Object)(sinceTime != null ? sinceTime.getTime() : 0L));
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public ActivityEntity getParentActivity(long commentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getParentActivity", ActivityEntity.class);
        query.setParameter("commentId", (Object)commentId);
        query.setMaxResults(1);
        try {
            return (ActivityEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<ActivityEntity> getAllActivities() {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getAllActivities", ActivityEntity.class);
        return query.getResultList();
    }

    @Override
    @ExoTransactional
    public void deleteActivitiesByOwnerId(String ownerId) {
        String string = ownerId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new ActivityDAOImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<Long> getOwnerActivities(List<String> owners, long newerTime, long olderTime, long offset, long limit) throws ActivityStorageException {
        TypedQuery query;
        if (newerTime > 0L) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityByOwner", Tuple.class);
            query.setParameter("sinceTime", (Object)newerTime);
        } else if (olderTime > 0L) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityByOwner", Tuple.class);
            query.setParameter("sinceTime", (Object)olderTime);
        } else {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwner", Tuple.class);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : owners) {
            ids.add(Long.parseLong(id));
        }
        query.setParameter("owners", ids);
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    private Set<String> getConnectionIdsInString(long ownerId) {
        HashSet<String> connectionIds = new HashSet<String>();
        String queryName = "SocConnection.getReceiverIdsBySenderWithStatus";
        List<Long> receiverIds = this.getConnectionsByQuery(ownerId, queryName);
        for (Long receiverId : receiverIds) {
            connectionIds.add(String.valueOf(receiverId));
        }
        queryName = "SocConnection.getSenderIdsByReceiverWithStatus";
        List<Long> senderIds = this.getConnectionsByQuery(ownerId, queryName);
        for (Long senderId : senderIds) {
            connectionIds.add(String.valueOf(senderId));
        }
        return connectionIds;
    }

    private Set<Long> getConnectionIds(long ownerId) {
        HashSet<Long> connectionIds = new HashSet<Long>();
        String queryName = "SocConnection.getReceiverIdsBySenderWithStatus";
        connectionIds.addAll(this.getConnectionsByQuery(ownerId, queryName));
        queryName = "SocConnection.getSenderIdsByReceiverWithStatus";
        connectionIds.addAll(this.getConnectionsByQuery(ownerId, queryName));
        return connectionIds;
    }

    private List<Long> getConnectionsByQuery(long ownerId, String queryName) {
        TypedQuery searchConnectionsQuery = this.getEntityManager().createNamedQuery(queryName, Tuple.class);
        searchConnectionsQuery.setParameter("identityId", (Object)ownerId);
        searchConnectionsQuery.setParameter("status", (Object)Relationship.Type.CONFIRMED);
        List connectionsTuple = searchConnectionsQuery.getResultList();
        ArrayList<Long> connections = new ArrayList<Long>();
        if (!connectionsTuple.isEmpty()) {
            for (Tuple tuple : connectionsTuple) {
                Long id = (Long)tuple.get(0, Long.class);
                connections.add(id);
            }
        }
        return connections;
    }

    @Override
    public List<ActivityEntity> findActivities(List<Long> activityIds) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findActivities", ActivityEntity.class);
        query.setParameter("ids", activityIds);
        return query.getResultList();
    }

    static {
        ActivityDAOImpl.ajc$preClinit();
    }

    static /* synthetic */ void deleteActivitiesByOwnerId_aroundBody0(ActivityDAOImpl ajc$this, String ownerId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocActivity.deleteActivityByOwner");
        query.setParameter("ownerId", (Object)ownerId);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ActivityDAOImpl.java", ActivityDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteActivitiesByOwnerId", "org.exoplatform.social.core.jpa.storage.dao.jpa.ActivityDAOImpl", "java.lang.String", "ownerId", "", "void"), 810);
    }
}

