/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;

public class SpaceMemberDAOImpl
extends GenericDAOJPAImpl<SpaceMemberEntity, Long>
implements SpaceMemberDAO {
    private static final Log LOG = ExoLogger.getLogger(SpaceMemberDAOImpl.class);

    @Override
    public void deleteBySpace(SpaceEntity entity) {
        Query query = this.getEntityManager().createNamedQuery("SpaceMember.deleteBySpace");
        query.setParameter("spaceId", (Object)entity.getId());
        query.executeUpdate();
    }

    @Override
    public List<String> sortSpaceMembers(List<String> usernames, String sortField) {
        if (usernames == null || usernames.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder queryStringBuilder = this.isOrcaleDialect() ? new StringBuilder("SELECT to_char(identity_1.remote_id) , to_char(identity_prop.value) \n") : (this.isMSSQLDialect() ? new StringBuilder("SELECT try_convert(varchar(200), identity_1.remote_id) as remote_id , try_convert(varchar(200), identity_prop.value) as identity_prop_value \n") : new StringBuilder("SELECT (identity_1.remote_id) , (identity_prop.value) \n"));
        queryStringBuilder.append(" FROM SOC_IDENTITIES identity_1 \n");
        queryStringBuilder.append(" LEFT JOIN SOC_IDENTITY_PROPERTIES identity_prop \n");
        queryStringBuilder.append("   ON identity_1.identity_id = identity_prop.identity_id \n");
        queryStringBuilder.append("       AND identity_prop.name = '").append(sortField).append("' \n");
        queryStringBuilder.append(" WHERE identity_1.remote_id IN (");
        for (int i = 0; i < usernames.size(); ++i) {
            if (i > 0) {
                queryStringBuilder.append(",");
            }
            queryStringBuilder.append("'").append(usernames.get(i)).append("'");
        }
        queryStringBuilder.append(")\n");
        queryStringBuilder.append("       AND identity_1.provider_id = '").append("organization").append("' \n");
        queryStringBuilder.append(" ORDER BY identity_prop.value ASC, identity_1.remote_id ASC");
        Query query = this.getEntityManager().createNativeQuery(queryStringBuilder.toString());
        List resultList = query.getResultList();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> addedUsernames = new ArrayList<String>(usernames);
        for (Object object : resultList) {
            Object[] resultEntry = (Object[])object;
            if (resultEntry[0] == null) continue;
            String username = resultEntry[0].toString();
            result.add(username);
            addedUsernames.remove(username);
        }
        for (String username : addedUsernames) {
            result.add(username);
        }
        return result;
    }

    @Override
    public List<String> getSpaceMembers(Long spaceId, SpaceMemberEntity.Status status, int offset, int limit) {
        if (status == null) {
            throw new IllegalArgumentException("Status is null");
        }
        if (spaceId == null || spaceId == 0L) {
            throw new IllegalArgumentException("spaceId is null or equals to 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be positive");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceMembersByStatus", String.class);
        query.setParameter("status", (Object)status);
        query.setParameter("spaceId", (Object)spaceId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public int countSpaceMembers(Long spaceId, SpaceMemberEntity.Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Status is null");
        }
        if (spaceId == null || spaceId == 0L) {
            throw new IllegalArgumentException("spaceId is null or equals to 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.countSpaceMembersByStatus", Long.class);
        query.setParameter("status", (Object)status);
        query.setParameter("spaceId", (Object)spaceId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public SpaceMemberEntity getSpaceMemberShip(String remoteId, Long spaceId, SpaceMemberEntity.Status status) throws IllegalArgumentException {
        if (status == null) {
            TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceMemberShip", SpaceMemberEntity.class);
            query.setParameter("userId", (Object)remoteId);
            query.setParameter("spaceId", (Object)spaceId);
            try {
                List memberEntities = query.getResultList();
                if (memberEntities.size() > 1) {
                    LOG.warn((Object)"we have found more than one result");
                    return (SpaceMemberEntity)memberEntities.get(0);
                }
                return (SpaceMemberEntity)query.getSingleResult();
            }
            catch (NoResultException ex) {
                return null;
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getMember", SpaceMemberEntity.class);
        query.setParameter("userId", (Object)remoteId);
        query.setParameter("spaceId", (Object)spaceId);
        query.setParameter("status", (Object)status);
        try {
            List memberEntities = query.getResultList();
            if (memberEntities.size() > 1) {
                LOG.warn((Object)"we have found more than one result");
                return (SpaceMemberEntity)memberEntities.get(0);
            }
            return (SpaceMemberEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<Long> getSpacesIdsByUserName(String userId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceIdentitiesIdByMemberId", Long.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("status", (Object)SpaceMemberEntity.Status.MEMBER);
        try {
            if (limit > 0) {
                query.setFirstResult(offset);
                query.setMaxResults(limit);
            }
            return query.getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
    }
}

