/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.DirectivePrologueQuasiNode;
import com.google.caja.parser.quasiliteral.MultiPropertyQuasi;
import com.google.caja.parser.quasiliteral.MultipleNonemptyQuasiHole;
import com.google.caja.parser.quasiliteral.MultipleQuasiHole;
import com.google.caja.parser.quasiliteral.ObjectCtorQuasiNode;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.SimpleQuasiNode;
import com.google.caja.parser.quasiliteral.SingleOptionalIdentifierQuasiNode;
import com.google.caja.parser.quasiliteral.SingleOptionalQuasiHole;
import com.google.caja.parser.quasiliteral.SinglePropertyQuasi;
import com.google.caja.parser.quasiliteral.SingleQuasiHole;
import com.google.caja.parser.quasiliteral.StringLiteralQuasiNode;
import com.google.caja.parser.quasiliteral.SyntheticQuasiNode;
import com.google.caja.parser.quasiliteral.TrailingUnderscoresHole;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.util.Lists;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuasiBuilder {
    private static final Map<String, QuasiNode> patternCache = Collections.synchronizedMap(new LinkedHashMap<String, QuasiNode>(){
        private static final long serialVersionUID = 8370964871936109547L;

        @Override
        public boolean removeEldestEntry(Map.Entry<String, QuasiNode> e) {
            return this.size() > 256;
        }
    });

    public static boolean match(String patternText, ParseTreeNode specimen) {
        return QuasiBuilder.match(patternText, specimen, Rule.makeBindings());
    }

    public static boolean match(String patternText, ParseTreeNode specimen, Map<String, ParseTreeNode> bindings) {
        Map<String, ParseTreeNode> tempBindings = QuasiBuilder.getPatternNode(patternText).match(specimen);
        if (tempBindings != null) {
            bindings.putAll(tempBindings);
            return true;
        }
        return false;
    }

    public static ParseTreeNode subst(String patternText, Map<String, ParseTreeNode> bindings) {
        return QuasiBuilder.getPatternNode(patternText).substitute(bindings);
    }

    public static ParseTreeNode substV(String patternText, Object ... args) {
        if (args.length % 2 != 0) {
            throw new SomethingWidgyHappenedError("Wrong # of args for subst()");
        }
        Map<String, ParseTreeNode> bindings = Rule.makeBindings();
        for (int i = 0; i < args.length; i += 2) {
            ParseTreeNode value = (ParseTreeNode)args[i + 1];
            if (value != null) {
                // empty if block
            }
            bindings.put((String)args[i], value);
        }
        ParseTreeNode result = QuasiBuilder.subst(patternText, bindings);
        if (result == null) {
            throw new NullPointerException("'" + patternText + "' > " + bindings.keySet());
        }
        return result;
    }

    public static QuasiNode parseQuasiNode(InputSource inputSource, String pattern) throws ParseException {
        Block topLevelBlock = (Block)QuasiBuilder.parse(inputSource, pattern);
        ParseTreeNode topLevelNode = topLevelBlock;
        if (topLevelNode.children().size() == 1) {
            topLevelNode = topLevelNode.children().get(0);
        }
        if (topLevelNode instanceof ExpressionStmt) {
            topLevelNode = topLevelNode.children().get(0);
        }
        if (topLevelNode instanceof FunctionDeclaration) {
            topLevelNode = ((FunctionDeclaration)topLevelNode).getInitializer();
        }
        return QuasiBuilder.build(topLevelNode);
    }

    public static QuasiNode parseQuasiNode(String pattern) throws ParseException {
        return QuasiBuilder.parseQuasiNode(FilePosition.UNKNOWN.source(), pattern);
    }

    public static Class<? extends ParseTreeNode> fuzzType(Class<? extends ParseTreeNode> nodeClass) {
        if (nodeClass == FunctionDeclaration.class) {
            return FunctionConstructor.class;
        }
        if (nodeClass == Expression.class) {
            return ExpressionStmt.class;
        }
        if (nodeClass == Reference.class) {
            return Identifier.class;
        }
        if (nodeClass == LabeledStmtWrapper.class) {
            return LabeledStatement.class;
        }
        return nodeClass;
    }

    private static QuasiNode getPatternNode(String patternText) {
        if (!patternCache.containsKey(patternText)) {
            try {
                patternCache.put(patternText, QuasiBuilder.parseQuasiNode(patternText));
            }
            catch (ParseException e) {
                throw new SomethingWidgyHappenedError("Pattern programming error", (Throwable)e);
            }
        }
        return patternCache.get(patternText);
    }

    private static QuasiNode build(ParseTreeNode n) {
        StringLiteral lit;
        String ident;
        String name;
        if (n instanceof ExpressionStmt && ((ExpressionStmt)n).getExpression() instanceof Reference && (name = ((Reference)n.children().get(0)).getIdentifierName()).startsWith("@") && !name.endsWith("_")) {
            return QuasiBuilder.buildMatchNode(Statement.class, name);
        }
        if (n instanceof Reference && (name = ((Reference)n).getIdentifierName()).startsWith("@") && !name.endsWith("_")) {
            return QuasiBuilder.buildMatchNode(Expression.class, name);
        }
        if (n instanceof FormalParam && (name = ((FormalParam)n).getIdentifierName()).startsWith("@")) {
            return QuasiBuilder.buildMatchNode(FormalParam.class, name);
        }
        if (n instanceof Identifier && (name = ((Identifier)n).getName()) != null && name.startsWith("@")) {
            boolean isOptional = name.endsWith("?");
            if (isOptional) {
                name = name.substring(0, name.length() - 1);
            }
            QuasiNode qn = name.endsWith("_") ? QuasiBuilder.buildTrailingUnderscoreMatchNode(name) : QuasiBuilder.buildMatchNode(Identifier.class, name);
            if (isOptional) {
                qn = new SingleOptionalIdentifierQuasiNode(qn);
            }
            return qn;
        }
        if (n instanceof ObjectConstructor) {
            return QuasiBuilder.buildObjectConstructorNode((ObjectConstructor)n);
        }
        if (n instanceof DirectivePrologue) {
            return QuasiBuilder.buildDirectivePrologueMatchNode(((DirectivePrologue)n).getDirectives());
        }
        if (n instanceof StringLiteral && (ident = QuasiBuilder.quasiIdent(lit = (StringLiteral)n)) != null && Character.isJavaIdentifierPart(ident.charAt(ident.length() - 1))) {
            return new StringLiteralQuasiNode(ident.substring(1));
        }
        return QuasiBuilder.buildSimpleNode(n);
    }

    private static QuasiNode buildSimpleNode(ParseTreeNode n) {
        QuasiNode.Equivalence cmp;
        boolean isSynthetic = false;
        if (QuasiBuilder.hasSyntheticAnnotation(n)) {
            isSynthetic = true;
        } else if (n instanceof Identifier) {
            Identifier ident = (Identifier)n;
            isSynthetic = ident.getName() != null && ident.getName().endsWith("__");
        } else if (n instanceof Reference) {
            Reference ref = (Reference)n;
            isSynthetic = ref.getIdentifierName().endsWith("__");
        }
        QuasiNode.Equivalence equivalence = cmp = n instanceof StringLiteral ? QuasiNode.EQUAL_UNESCAPED : QuasiNode.SAFE_EQUALS;
        if (isSynthetic) {
            return new SyntheticQuasiNode(n.getClass(), n.getValue(), cmp, QuasiBuilder.buildChildrenOf(n));
        }
        return new SimpleQuasiNode(n.getClass(), n.getValue(), cmp, QuasiBuilder.buildChildrenOf(n));
    }

    private static boolean hasSyntheticAnnotation(ParseTreeNode n) {
        for (Token<?> comment : n.getComments()) {
            if (comment.text.indexOf("@synthetic") < 0) continue;
            return SyntheticNodes.isSynthesizable(n);
        }
        return false;
    }

    private static QuasiNode buildMatchNode(Class<? extends ParseTreeNode> matchedClass, String quasiString) {
        assert (quasiString.startsWith("@"));
        if (quasiString.endsWith("*")) {
            return new MultipleQuasiHole(matchedClass, quasiString.substring(1, quasiString.length() - 1));
        }
        if (quasiString.endsWith("+")) {
            return new MultipleNonemptyQuasiHole(matchedClass, quasiString.substring(1, quasiString.length() - 1));
        }
        if (quasiString.endsWith("?")) {
            return new SingleOptionalQuasiHole(matchedClass, quasiString.substring(1, quasiString.length() - 1));
        }
        return new SingleQuasiHole(matchedClass, quasiString.substring(1, quasiString.length()));
    }

    private static QuasiNode buildTrailingUnderscoreMatchNode(String quasiString) {
        assert (quasiString.startsWith("@"));
        assert (quasiString.endsWith("_"));
        quasiString = quasiString.substring(1, quasiString.length());
        int numberOfUnderscores = 0;
        while (quasiString.endsWith("_")) {
            quasiString = quasiString.substring(0, quasiString.length() - 1);
            ++numberOfUnderscores;
        }
        return new TrailingUnderscoresHole(quasiString, numberOfUnderscores);
    }

    private static String quasiIdent(StringLiteral sl) {
        String raw = sl.getValue();
        int start = 0;
        int end = raw.length();
        if (end - start >= 2 && raw.charAt(end - 1) == raw.charAt(start)) {
            switch (raw.charAt(start)) {
                case '\"': 
                case '\'': {
                    start = 1;
                    --end;
                }
            }
        }
        if (start >= end || raw.charAt(start) != '@') {
            return null;
        }
        int identEnd = end;
        int identStart = start + 1;
        if (identEnd > identStart) {
            switch (raw.charAt(identEnd - 1)) {
                case '*': 
                case '+': 
                case '?': {
                    --identEnd;
                }
            }
        }
        if (ParserBase.isJavascriptIdentifier(StringLiteral.unescapeJsString(raw.substring(identStart, identEnd)))) {
            return StringLiteral.unescapeJsString(raw.substring(start, end));
        }
        return null;
    }

    private static QuasiNode buildObjectConstructorNode(ObjectConstructor obj) {
        List<QuasiNode> propQuasis = Lists.newArrayList();
        for (ObjProperty objProperty : obj.children()) {
            StringLiteral key = objProperty.getPropertyNameNode();
            if (objProperty instanceof ValueProperty) {
                Expression value = ((ValueProperty)objProperty).getValueExpr();
                String keyIdent = QuasiBuilder.quasiIdent(key);
                if (value instanceof Reference) {
                    String valueStr = ((Reference)value).getIdentifierName();
                    if (keyIdent != null && keyIdent.endsWith("*") && valueStr.startsWith("@") && valueStr.endsWith("*")) {
                        propQuasis.add(new MultiPropertyQuasi(keyIdent.substring(1, keyIdent.length() - 1), valueStr.substring(1, valueStr.length() - 1)));
                        continue;
                    }
                }
                QuasiNode keyQuasi = QuasiBuilder.build(keyIdent != null ? new Reference(new Identifier(FilePosition.UNKNOWN, keyIdent)) : key);
                propQuasis.add(new SinglePropertyQuasi(keyQuasi, QuasiBuilder.build(value)));
                continue;
            }
            throw new UnsupportedOperationException(objProperty.getClass().getName());
        }
        return new ObjectCtorQuasiNode(propQuasis.toArray(new QuasiNode[0]));
    }

    private static QuasiNode buildDirectivePrologueMatchNode(Set<String> subsetNames) {
        return new DirectivePrologueQuasiNode(subsetNames);
    }

    private static QuasiNode[] buildChildrenOf(ParseTreeNode n) {
        List<QuasiNode> children = Lists.newArrayList();
        for (ParseTreeNode parseTreeNode : n.children()) {
            children.add(QuasiBuilder.build(parseTreeNode));
        }
        return children.toArray(new QuasiNode[children.size()]);
    }

    private static ParseTreeNode parse(InputSource inputSource, String sourceText) throws ParseException {
        Parser parser = new Parser(new JsTokenQueue(new JsLexer(CharProducer.Factory.fromString((CharSequence)sourceText, inputSource), true), inputSource), DevNullMessageQueue.singleton(), true);
        Block topLevelStatement = parser.parse();
        parser.getTokenQueue().expectEmpty();
        return topLevelStatement;
    }
}

