/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.EmbeddedJsExpressionTokenConsumer;
import com.google.caja.plugin.JsExpressionUriLiteral;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.SuffixedClassOrIdLiteral;
import com.google.caja.plugin.UnsafeUriLiteral;
import com.google.caja.reporting.RenderContext;
import javax.annotation.Nullable;

public final class CssDynamicExpressionRewriter {
    @Nullable
    private final String gadgetNameSuffix;

    public CssDynamicExpressionRewriter(PluginMeta meta) {
        this.gadgetNameSuffix = meta.getIdClass();
    }

    public void rewriteCss(CssTree ss) {
        this.rewriteSuffixedIdsAndClasses(ss);
        this.rewriteUnsafeUriLiteralsToExpressions(ss);
    }

    private void rewriteSuffixedIdsAndClasses(CssTree ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof CssTree.SuffixedSelectorPart) {
                    CssTree.CssLiteral replacement;
                    CssTree.SuffixedSelectorPart ssp = (CssTree.SuffixedSelectorPart)node;
                    MutableParseTreeNode parent = (MutableParseTreeNode)ancestors.parent.cast(MutableParseTreeNode.class).node;
                    if (CssDynamicExpressionRewriter.this.gadgetNameSuffix == null) {
                        replacement = new SuffixedClassOrIdLiteral(ssp.getFilePosition(), ssp.typePrefix() + ssp.suffixedIdentifier(""));
                    } else {
                        String ident = ssp.suffixedIdentifier(CssDynamicExpressionRewriter.this.gadgetNameSuffix);
                        replacement = ".".equals(ssp.typePrefix()) ? new CssTree.ClassLiteral(ssp.getFilePosition(), "." + ident) : new CssTree.IdLiteral(ssp.getFilePosition(), "#" + ident);
                    }
                    parent.replaceChild(replacement, ssp);
                    return false;
                }
                if (node instanceof CssTree.IdLiteral) {
                    throw new AssertionError();
                }
                return true;
            }
        }, null);
    }

    private void rewriteUnsafeUriLiteralsToExpressions(CssTree ss) {
        ss.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ancestors) {
                Object node = ancestors.node;
                if (node instanceof UnsafeUriLiteral) {
                    UnsafeUriLiteral uul = (UnsafeUriLiteral)node;
                    CssTree parent = (CssTree)ancestors.parent.node;
                    assert (null != parent);
                    AncestorChain<Object> prop = ancestors;
                    while (null != prop && !(prop.node instanceof CssTree.PropertyDeclaration)) {
                        prop = prop.parent;
                    }
                    assert (null != prop);
                    parent.replaceChild(new JsExpressionUriLiteral(uul.getFilePosition(), (Expression)QuasiBuilder.substV("IMPORTS___./*@synthetic*/rewriteUriInCss___(@u, @p)", "u", StringLiteral.valueOf(uul.getFilePosition(), uul.getValue()), "p", StringLiteral.valueOf(uul.getFilePosition(), ((CssTree.PropertyDeclaration)prop.node).getProperty().getPropertyName().getCanonicalForm()))), uul);
                }
                return true;
            }
        }, null);
    }

    public static ArrayConstructor cssToJs(CssTree ss) {
        EmbeddedJsExpressionTokenConsumer cssToJsArrayElements = new EmbeddedJsExpressionTokenConsumer();
        ss.render(new RenderContext(cssToJsArrayElements));
        cssToJsArrayElements.noMoreTokens();
        return new ArrayConstructor(ss.getFilePosition(), cssToJsArrayElements.getArrayMembers());
    }
}

