/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.html.Dom;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.Placeholder;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.precajole.PrecajoleMap;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;
import com.google.caja.util.Strings;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecajoleRewriteStage
implements Pipeline.Stage<Jobs> {
    private final PrecajoleMap precajoleMap;
    private final boolean minify;
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";

    public PrecajoleRewriteStage(PrecajoleMap map, boolean minify) {
        this.precajoleMap = map;
        this.minify = minify;
    }

    @Override
    public boolean apply(Jobs jobs) {
        if (this.precajoleMap == null) {
            return true;
        }
        for (JobEnvelope env : jobs.getJobsByType(ContentType.HTML, new ContentType[0])) {
            DocumentFragment root = ((Dom)env.job.getRoot()).getValue();
            this.rewriteChildren(jobs, root);
        }
        return true;
    }

    private void rewriteChildren(Jobs jobs, Node node) {
        Node c = node.getFirstChild();
        Node next = null;
        while (c != null) {
            next = c.getNextSibling();
            if (!this.rewriteElement(jobs, c)) {
                this.rewriteChildren(jobs, c);
            }
            c = next;
        }
    }

    private boolean rewriteElement(Jobs jobs, Node node) {
        CajoledModule pre;
        String src;
        if (!(node instanceof Element)) {
            return false;
        }
        Element el = (Element)node;
        String tagName = Strings.lower(el.getLocalName());
        if ("script".equals(tagName) && (src = this.getAttr(el, "src")) != null && src.length() != 0 && (pre = this.precajoleMap.lookupUri(src, this.minify)) != null) {
            this.replaceScript(jobs, el, pre);
            return true;
        }
        return false;
    }

    private void replaceScript(Jobs jobs, Element el, CajoledModule pre) {
        Node parent = el.getParentNode();
        if (parent == null) {
            return;
        }
        String id = "$" + jobs.getPluginMeta().generateGuid();
        Element placeholder = Placeholder.make(el, id);
        if (Strings.eqIgnoreCase(this.getAttr(el, "defer"), "defer")) {
            parent.removeChild(el);
            parent.appendChild(placeholder);
        } else {
            parent.replaceChild(placeholder, el);
        }
        Job job = Job.cajoledJob(pre);
        jobs.getJobs().add(new JobEnvelope(id, JobCache.none(), ContentType.JS, true, job));
    }

    private String getAttr(Node n, String attrib) {
        if (n instanceof Element) {
            return ((Element)n).getAttributeNS(HTML_NS, attrib);
        }
        return null;
    }
}

