/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.precajole;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserContext;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.opt.ArrayIndexOptimization;
import com.google.caja.plugin.ExpressionSanitizerCaja;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.templates.QuasiUtil;
import com.google.caja.precajole.StaticPrecajoleMap;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.ContentType;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PrecajoleTask
extends Task {
    private String spec;
    private String dest;
    private final List<String> deps = new ArrayList<String>();
    private StaticPrecajoleMap map;

    public void setSpec(String value) {
        this.spec = value;
    }

    public void setDest(String value) {
        this.dest = value;
    }

    public void setDepend(String value) {
        this.deps.add(value);
    }

    public void execute() {
        if (this.spec == null) {
            throw new BuildException("missing spec= attribute");
        }
        if (this.dest == null) {
            throw new BuildException("missing dest= attribute");
        }
        long now = System.currentTimeMillis();
        this.map = new StaticPrecajoleMap(this.dest);
        this.outdatedCheck();
        try {
            new SpecHandler(this.spec).process();
            this.map.setModTime(now);
            this.map.finish();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void outdatedCheck() {
        long mt = this.map.getModTime();
        if (mt <= new File(this.spec).lastModified()) {
            this.map.setModTime(0L);
            return;
        }
        for (String dep : this.deps) {
            if (this.map.getModTime() > new File(dep).lastModified()) continue;
            this.map.setModTime(0L);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpecHandler
    extends DefaultHandler {
        private final File specFile;
        private final File specDir;
        private Locator here = null;
        private String precajoleFile = null;
        private String precajoleDir = null;
        private String cdata = "";
        private List<String> uris = null;

        public SpecHandler(String filename) {
            this.specFile = new File(filename);
            this.specDir = this.specFile.getParentFile();
        }

        public void process() throws SAXException, FileNotFoundException, IOException {
            XMLReader sax = XMLReaderFactory.createXMLReader();
            sax.setContentHandler(this);
            sax.parse(new org.xml.sax.InputSource(new FileInputStream(this.specFile)));
        }

        @Override
        public void setDocumentLocator(Locator here) {
            this.here = here;
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
            if (!"precajole-spec".equals(name)) {
                if ("precajole".equals(name)) {
                    this.startPrecajole(attrs);
                } else if ("uri".equals(name)) {
                    this.startUri();
                } else {
                    throw new SAXParseException("Unknown tag " + name, this.here);
                }
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!"precajole-spec".equals(name)) {
                if ("precajole".equals(name)) {
                    this.endPrecajole();
                } else if ("uri".equals(name)) {
                    this.endUri();
                } else {
                    throw new SAXParseException("Unknown tag " + name, this.here);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int len) {
            this.cdata = this.cdata + new String(ch, start, len);
        }

        private void startPrecajole(Attributes attrs) throws SAXParseException {
            if (attrs != null) {
                this.precajoleDir = attrs.getValue("dir");
                this.precajoleFile = attrs.getValue("file");
                if (this.precajoleDir != null && this.precajoleFile != null) {
                    throw new SAXParseException("can't use both dir= and file=", this.here);
                }
                if (this.precajoleDir != null || this.precajoleFile != null) {
                    this.uris = new ArrayList<String>();
                    return;
                }
            }
            throw new SAXParseException("missing file= or dir= attribute", this.here);
        }

        private void startUri() {
            this.cdata = "";
        }

        private void endUri() throws SAXParseException {
            if (this.cdata != null) {
                this.cdata = this.cdata.trim();
                if (!this.cdata.isEmpty()) {
                    String uri = StaticPrecajoleMap.normalizeUri(this.cdata);
                    this.uris.add(uri);
                    if (uri.startsWith("http:")) {
                        this.uris.add("https:" + uri.substring("http:".length()));
                    }
                    return;
                }
            }
            throw new SAXParseException("<uri> has no content", this.here);
        }

        private void endPrecajole() throws SAXException {
            if (this.precajoleDir != null) {
                this.cajoleDir(this.precajoleDir);
            } else {
                this.cajoleFile(this.uris, this.precajoleFile);
            }
        }

        private void cajoleFile(List<String> uris, String name) throws SAXException {
            File f = new File(this.specDir, name);
            if (f.exists() && f.lastModified() < PrecajoleTask.this.map.getModTime()) {
                return;
            }
            String text = this.readFile(f);
            CajoledModule cajoled = this.cajole(text, name);
            PrecajoleTask.this.map.put(uris, text, cajoled);
        }

        private void cajoleDir(String dirName) throws SAXException {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(this.specDir);
            String[] includes = new String[]{dirName + "/**/*.js"};
            ds.setIncludes(includes);
            ds.scan();
            for (String fileName : ds.getIncludedFiles()) {
                ArrayList<String> suburis = new ArrayList<String>();
                for (String uri : this.uris) {
                    String suburi = uri + "/" + fileName;
                    suburi = StaticPrecajoleMap.normalizeUri(suburi);
                    suburis.add(suburi);
                }
                this.cajoleFile(suburis, fileName);
            }
        }

        private String readFile(File f) throws SAXException {
            try {
                return Files.toString((File)f, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        private CajoledModule cajole(String text, String name) {
            EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter(System.err), new MessageContext(), false);
            PluginMeta pm = new PluginMeta();
            pm.setPrecajoleMap(null);
            ModuleManager mgr = new ModuleManager(pm, BuildInfo.getInstance(), UriFetcher.NULL_NETWORK, mq);
            UncajoledModule input = this.uncajoled(text, name, mq);
            ArrayIndexOptimization.optimize(input);
            ParseTreeNode result = new ExpressionSanitizerCaja(mgr, null).sanitize(input);
            if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
                throw new BuildException("Failed to cajole " + name);
            }
            if (!(result instanceof CajoledModule)) {
                throw new BuildException("No CajoledModule for " + name);
            }
            return (CajoledModule)result;
        }

        private UncajoledModule uncajoled(String text, String name, MessageQueue mq) {
            String imaginaryUri = "precajole:///" + name;
            try {
                ParseTreeNode node = new ParserContext(mq).withInput(ContentType.JS).withInput(CharProducer.Factory.create(new StringReader(text), new InputSource(new URI(imaginaryUri)))).build();
                node = QuasiUtil.quasiStmt("try {  @scriptBody;} catch (ex___) {  ___./*@synthetic*/ getNewModuleHandler()      ./*@synthetic*/ handleUncaughtException(          ex___, onerror, @sourceFile, @line);}", "scriptBody", node, "sourceFile", StringLiteral.valueOf(FilePosition.UNKNOWN, imaginaryUri), "line", StringLiteral.valueOf(FilePosition.UNKNOWN, "0"));
                return UncajoledModule.of(node);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

