/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;

public class MultipleResourceHttpFetcher {
    private final RequestPipeline requestPipeline;
    private final Executor executor;

    public MultipleResourceHttpFetcher(RequestPipeline requestPipeline, Executor executor) {
        this.requestPipeline = requestPipeline;
        this.executor = executor;
    }

    public List<Pair<Uri, FutureTask<RequestContext>>> fetchAll(List<HttpRequest> requests) {
        ArrayList futureTasks = Lists.newArrayList();
        for (HttpRequest request : requests) {
            futureTasks.add(Pair.of((Object)request.getUri(), this.createHttpFetcher(request)));
        }
        return futureTasks;
    }

    public Map<Uri, FutureTask<RequestContext>> fetchUnique(List<HttpRequest> requests) {
        HashMap futureTasks = Maps.newHashMap();
        for (HttpRequest request : requests) {
            Uri uri = request.getUri();
            if (futureTasks.containsKey(uri)) continue;
            futureTasks.put(uri, this.createHttpFetcher(request));
        }
        return futureTasks;
    }

    private FutureTask<RequestContext> createHttpFetcher(HttpRequest request) {
        FutureTask<RequestContext> httpFetcher = new FutureTask<RequestContext>(new HttpFetchCallable(request, this.requestPipeline));
        this.executor.execute(httpFetcher);
        return httpFetcher;
    }

    public static class RequestContext {
        private final HttpRequest httpReq;
        private final HttpResponse httpResp;
        private final GadgetException gadgetException;

        public HttpRequest getHttpReq() {
            return this.httpReq;
        }

        public HttpResponse getHttpResp() {
            return this.httpResp;
        }

        public GadgetException getGadgetException() {
            return this.gadgetException;
        }

        public RequestContext(HttpRequest httpReq, HttpResponse httpResp, GadgetException ge) {
            this.httpReq = httpReq;
            this.httpResp = httpResp;
            this.gadgetException = ge;
        }

        public int hashCode() {
            return this.httpReq.hashCode() ^ this.httpResp.hashCode() ^ this.gadgetException.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RequestContext)) {
                return false;
            }
            RequestContext reqCxt = (RequestContext)obj;
            return this.httpReq.equals(reqCxt.httpReq) && (this.httpResp != null ? this.httpResp.equals(reqCxt.httpResp) : reqCxt.httpResp == null) && (this.gadgetException != null ? this.gadgetException.equals(reqCxt.gadgetException) : reqCxt.gadgetException == null);
        }
    }

    private static class HttpFetchCallable
    implements Callable<RequestContext> {
        private final HttpRequest httpReq;
        private final RequestPipeline requestPipeline;

        public HttpFetchCallable(HttpRequest httpReq, RequestPipeline requestPipeline) {
            this.httpReq = httpReq;
            this.requestPipeline = requestPipeline;
        }

        @Override
        public RequestContext call() {
            HttpResponse httpResp = null;
            GadgetException gadgetException = null;
            try {
                httpResp = this.requestPipeline.execute(this.httpReq);
            }
            catch (GadgetException e) {
                gadgetException = e;
            }
            return new RequestContext(this.httpReq, httpResp, gadgetException);
        }
    }
}

