/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class AddOnloadFunctionProcessor
implements JsProcessor {
    private static final String ONLOAD_CODE_ID = "[onload-processor]";
    private static final String JSL_CODE_ID = "[jsload-callback]";
    @VisibleForTesting
    public static final String ONLOAD_FUNCTION_NAME_ERROR = "Invalid onload callback specified";
    @VisibleForTesting
    public static final String ONLOAD_JS_TPL = "(function() {var nm='%s';if (typeof window[nm]==='function') {window[nm]();}})();";
    @VisibleForTesting
    static final String JSL_CALLBACK_JS = "(function(){var j=window['___jsl'];if(j['c']&&--j['o']<=0){j['c']();delete j['c'];delete j['o'];}})();";
    private static final Pattern ONLOAD_FN_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");

    @Override
    public boolean process(JsRequest request, JsResponseBuilder builder) throws JsException {
        JsUriManager.JsUri jsUri = request.getJsUri();
        String onloadStr = jsUri.getOnload();
        if (onloadStr != null) {
            if (!ONLOAD_FN_PATTERN.matcher(onloadStr).matches()) {
                throw new JsException(400, ONLOAD_FUNCTION_NAME_ERROR);
            }
            builder.appendJs(this.createOnloadScript(onloadStr), ONLOAD_CODE_ID);
        } else if (jsUri.isNohint()) {
            builder.appendJs(JSL_CALLBACK_JS, JSL_CODE_ID, true);
        }
        return true;
    }

    @VisibleForTesting
    protected String createOnloadScript(String function) {
        return String.format(ONLOAD_JS_TPL, StringEscapeUtils.escapeEcmaScript((String)function));
    }
}

