/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.persistence;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Encrypter;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2EncryptionException;

public class OAuth2Client
implements Serializable {
    private static final long serialVersionUID = -7374658882342619184L;
    private boolean allowModuleOverride;
    private boolean authorizationHeader;
    private String authorizationUrl;
    private String clientAuthenticationType;
    private String clientId;
    private byte[] clientSecret;
    private byte[] encryptedSecret;
    private final transient OAuth2Encrypter encrypter;
    private String gadgetUri;
    private String grantType = "NONE";
    private String redirectUri;
    private String serviceName;
    private String tokenUrl;
    private OAuth2Accessor.Type type = OAuth2Accessor.Type.UNKNOWN;
    private boolean urlParameter;
    private boolean sharedToken = false;
    private String[] allowedDomains = new String[0];

    public OAuth2Client() {
        this(null);
    }

    @Inject
    public OAuth2Client(OAuth2Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OAuth2Client)) {
            return false;
        }
        OAuth2Client other = (OAuth2Client)obj;
        if (this.gadgetUri == null ? other.gadgetUri != null : !this.gadgetUri.equals(other.gadgetUri)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return this.sharedToken == other.sharedToken;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public byte[] getClientSecret() {
        return this.clientSecret;
    }

    public byte[] getEncryptedSecret() {
        return this.encryptedSecret;
    }

    public OAuth2Encrypter getEncrypter() {
        return this.encrypter;
    }

    public String getGadgetUri() {
        return this.gadgetUri;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuth2Accessor.Type getType() {
        return this.type;
    }

    public int hashCode() {
        if (this.serviceName != null && this.gadgetUri != null) {
            return (this.serviceName + ':' + this.gadgetUri).hashCode();
        }
        return 0;
    }

    public boolean isAllowModuleOverride() {
        return this.allowModuleOverride;
    }

    public boolean isAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public boolean isSharedToken() {
        return this.sharedToken;
    }

    public boolean isUrlParameter() {
        return this.urlParameter;
    }

    public void setAllowModuleOverride(boolean alllowModuleOverride) {
        this.allowModuleOverride = alllowModuleOverride;
    }

    public void setAuthorizationHeader(boolean authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public void setClientAuthenticationType(String clientAuthenticationType) {
        this.clientAuthenticationType = clientAuthenticationType;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(byte[] secret) throws OAuth2EncryptionException {
        this.clientSecret = secret;
        if (this.encrypter != null) {
            this.encryptedSecret = this.encrypter.encrypt(secret);
        }
    }

    public void setEncryptedSecret(byte[] encryptedSecret) throws OAuth2EncryptionException {
        this.encryptedSecret = encryptedSecret;
        if (this.encrypter != null) {
            this.clientSecret = this.encrypter.decrypt(encryptedSecret);
        }
    }

    public void setGadgetUri(String gadgetUri) {
        this.gadgetUri = gadgetUri;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setSharedToken(boolean sharedToken) {
        this.sharedToken = sharedToken;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setType(OAuth2Accessor.Type type) {
        this.type = type;
    }

    public void setUrlParameter(boolean urlParameter) {
        this.urlParameter = urlParameter;
    }

    public void setAllowedDomains(String[] allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    public String[] getAllowedDomains() {
        return this.allowedDomains;
    }

    public String toString() {
        return "org.apache.shindig.gadgets.oauth2.persistence.sample.OAuth2ClientImpl: serviceName = " + this.serviceName + " , redirectUri = " + this.redirectUri + " , gadgetUri = " + this.gadgetUri + " , clientId = " + this.clientId + " , grantType = " + this.grantType + " , type = " + this.type.name() + " , grantType = " + this.grantType + " , tokenUrl = " + this.tokenUrl + " , authorizationUrl = " + this.authorizationUrl + " , this.clientAuthenticationType = " + this.clientAuthenticationType + " , this.sharedToken = " + this.sharedToken + ", this.allowedDomains = " + Arrays.asList(this.allowedDomains);
    }

    public OAuth2Client clone() {
        OAuth2Client ret = new OAuth2Client(this.encrypter);
        ret.setAllowModuleOverride(this.allowModuleOverride);
        ret.setAuthorizationHeader(this.authorizationHeader);
        ret.setAuthorizationUrl(this.authorizationUrl);
        ret.setClientAuthenticationType(this.clientAuthenticationType);
        ret.setClientId(this.clientId);
        try {
            ret.setClientSecret(this.clientSecret);
        }
        catch (OAuth2EncryptionException oAuth2EncryptionException) {
            // empty catch block
        }
        ret.setGadgetUri(this.gadgetUri);
        ret.setGrantType(this.grantType);
        ret.setRedirectUri(this.redirectUri);
        ret.setServiceName(this.serviceName);
        ret.setSharedToken(this.sharedToken);
        ret.setTokenUrl(this.tokenUrl);
        ret.setType(this.type);
        ret.setUrlParameter(this.urlParameter);
        ret.setAllowedDomains(this.getAllowedDomains());
        return ret;
    }
}

