/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.html.DomParser;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.caja.VanillaCajaHtmlSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class VanillaCajaHtmlParser
extends GadgetHtmlParser {
    private final boolean needsDebugData;

    @Inject
    public VanillaCajaHtmlParser(DOMImplementation documentFactory, @Named(value="vanillaCajaParser.needsDebugData") boolean needsDebugData) {
        super(documentFactory);
        this.needsDebugData = needsDebugData;
    }

    @Override
    public Document parseDom(String source) throws GadgetException {
        return this.parseDomImpl(source);
    }

    private DomParser getDomParser(String source, MessageQueue mq) throws ParseException {
        InputSource is = InputSource.UNKNOWN;
        HtmlLexer lexer = new HtmlLexer(CharProducer.Factory.fromString((CharSequence)source, (InputSource)is));
        TokenQueue tokenQueue = new TokenQueue((TokenStream)lexer, is);
        DomParser parser = new DomParser(tokenQueue, false, mq);
        parser.setDomImpl(this.documentFactory);
        parser.setNeedsDebugData(this.needsDebugData);
        return parser;
    }

    @Override
    protected Document parseDomImpl(String source) throws GadgetException {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        try {
            DomParser parser = this.getDomParser(source, (MessageQueue)mq);
            Document doc = parser.parseDocument().getOwnerDocument();
            VanillaCajaHtmlSerializer serializer = new VanillaCajaHtmlSerializer();
            HtmlSerialization.attach(doc, serializer, null);
            return doc;
        }
        catch (ParseException e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, e.getCajaMessage().toString(), 500);
        }
        catch (NullPointerException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    protected DocumentFragment parseFragmentImpl(String source) throws GadgetException {
        throw new UnsupportedOperationException("Use parseDom instead.");
    }
}

