/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.rewrite.js.CompileResult;
import org.apache.shindig.gadgets.rewrite.js.DefaultJsCompiler;
import org.apache.shindig.gadgets.rewrite.js.JsCompiler;
import org.apache.shindig.gadgets.uri.JsUriManager;

@Singleton
public class ClosureJsCompiler
implements JsCompiler {
    private static final long DEFAULT_COMPILER_STACK_SIZE = 0x100000L;
    private static final JsContent EXPORTSYMBOL_CODE = JsContent.fromText("var goog=goog||{};goog.exportSymbol=function(name,obj){var parts=name.split('.'),cur=window,part;for(;parts.length&&(part=parts.shift());){if(!parts.length){cur[part]=obj;}else{cur=cur[part]||(cur[part]={})}}};", "[goog.exportSymbol]");
    private static final String classname = ClosureJsCompiler.class.getName();
    private static final Logger LOG = Logger.getLogger(classname);
    @VisibleForTesting
    static final String CACHE_NAME = "CompiledJs";
    private final DefaultJsCompiler defaultCompiler;
    private final Cache<String, CompileResult> cache;
    private final List<SourceFile> defaultExterns;
    private final String compileLevel;
    private final Map<String, Future<CompileResult>> compiling;
    private int threadPoolSize;
    private long compilerStackSize;
    private ExecutorService compilerPool;

    @Inject
    public ClosureJsCompiler(DefaultJsCompiler defaultCompiler, CacheProvider cacheProvider, @Named(value="shindig.closure.compile.level") String level) {
        this(defaultCompiler, cacheProvider, level, null);
    }

    public ClosureJsCompiler(DefaultJsCompiler defaultCompiler, CacheProvider cacheProvider, String level, ExecutorService executorService) {
        List externs;
        block2: {
            this.threadPoolSize = 5;
            this.compilerStackSize = 0x100000L;
            this.cache = cacheProvider.createCache(CACHE_NAME);
            this.defaultCompiler = defaultCompiler;
            externs = null;
            try {
                externs = Collections.unmodifiableList(CommandLineRunner.getDefaultExterns());
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "Unable to load default closure externs: " + e.getMessage(), e);
            }
        }
        this.defaultExterns = externs;
        this.compileLevel = level.toLowerCase().trim();
        this.compilerPool = executorService != null ? executorService : this.createThreadPool();
        HashMap map = Maps.newHashMap();
        this.compiling = new ConcurrentHashMap<String, Future<CompileResult>>(map);
    }

    @Inject(optional=true)
    public void setThreadPoolSize(@Named(value="shindig.closure.compile.threadPoolSize") Integer threadPoolSize) {
        if (threadPoolSize != null && threadPoolSize != this.threadPoolSize) {
            ExecutorService compilerPool = this.compilerPool;
            this.threadPoolSize = threadPoolSize;
            this.compilerPool = this.createThreadPool();
            compilerPool.shutdown();
        }
    }

    @Inject(optional=true)
    public void setCompilerStackSize(@Named(value="shindig.closure.compile.compilerStackSize") Long compilerStackSize) {
        if (compilerStackSize > 0L) {
            this.compilerStackSize = compilerStackSize;
        }
    }

    protected ExecutorService createThreadPool() {
        ClosureJSThreadFactory threadFactory = new ClosureJSThreadFactory();
        return Executors.newFixedThreadPool(this.threadPoolSize, threadFactory);
    }

    public CompilerOptions defaultCompilerOptions() {
        CompilerOptions result = new CompilerOptions();
        if (this.compileLevel.equals("advanced")) {
            CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(result);
        } else if (this.compileLevel.equals("whitespace_only")) {
            CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(result);
        } else {
            CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(result);
        }
        return result;
    }

    @VisibleForTesting
    protected CompilerOptions getCompilerOptions(JsUriManager.JsUri uri) {
        CompilerOptions options = this.defaultCompilerOptions();
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsResponse compile(JsUriManager.JsUri jsUri, Iterable<JsContent> content, String externs) {
        JsResponseBuilder builder = new JsResponseBuilder();
        CompilerOptions options = this.getCompilerOptions(jsUri);
        StringBuilder compiled = new StringBuilder();
        StringBuilder exports = new StringBuilder();
        boolean useExterns = this.compileLevel.equals("advanced");
        if (!useExterns) {
            externs = "";
        }
        if (options.isExternExportsEnabled()) {
            LinkedList allContent = Lists.newLinkedList(content);
            allContent.add(EXPORTSYMBOL_CODE);
            content = allContent;
        }
        try {
            LinkedList futures = Lists.newLinkedList();
            for (JsContent code : content) {
                JsResponse defaultCompiled = this.defaultCompiler.compile(jsUri, Lists.newArrayList((Object[])new JsContent[]{code}), externs);
                Object future = null;
                boolean compile = !code.isNoCompile() && !this.compileLevel.equals("none");
                boolean bl = compile = compile && (!jsUri.isDebug() || options.isExternExportsEnabled());
                if (compile) {
                    String cacheKey = this.makeCacheKey(defaultCompiled.toJsString(), externs, jsUri, options);
                    Map<String, Future<CompileResult>> map = this.compiling;
                    synchronized (map) {
                        CompileResult cached = (CompileResult)this.cache.getElement((Object)cacheKey);
                        if (cached == null) {
                            future = this.compiling.get(cacheKey);
                            if (future == null) {
                                future = this.getCompileFuture(cacheKey, code, jsUri, externs);
                                this.compiling.put(cacheKey, (Future<CompileResult>)future);
                            }
                        } else {
                            future = Futures.immediateFuture((Object)cached);
                        }
                    }
                }
                if (future == null) {
                    future = Futures.immediateFuture((Object)new CompileResult(code.get()));
                }
                futures.add(future);
            }
            for (Future future : futures) {
                String export;
                CompileResult result = (CompileResult)future.get();
                compiled.append(result.getContent());
                if (!useExterns || (export = result.getExternExport()) == null) continue;
                exports.append(export);
            }
        }
        catch (Exception e) {
            Throwable cause;
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
            if ((cause = e.getCause()) instanceof CompilerException) {
                return this.returnErrorResult(builder, 404, ((CompilerException)cause).getErrors());
            }
            return this.returnErrorResult(builder, 404, Lists.newArrayList((Object[])new String[]{e.getMessage()}));
        }
        builder.appendJs(compiled.toString(), "[compiled]");
        builder.clearExterns().appendRawExtern(exports.toString());
        return builder.build();
    }

    protected Future<CompileResult> getCompileFuture(final String cacheKey, final JsContent content, final JsUriManager.JsUri jsUri, final String externs) {
        return this.compilerPool.submit(new Callable<CompileResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompileResult call() throws Exception {
                CompileResult result = ClosureJsCompiler.this.doCompileContent(content, ClosureJsCompiler.this.getCompilerOptions(jsUri), ClosureJsCompiler.this.buildExterns(externs));
                Map map = ClosureJsCompiler.this.compiling;
                synchronized (map) {
                    ClosureJsCompiler.this.cache.addElement((Object)cacheKey, (Object)result);
                    ClosureJsCompiler.this.compiling.remove(cacheKey);
                }
                return result;
            }
        });
    }

    protected CompileResult doCompileContent(JsContent content, CompilerOptions options, List<SourceFile> externs) throws CompilerException {
        Compiler compiler = new Compiler(ClosureJsCompiler.getErrorManager());
        compiler.disableThreads();
        SourceFile source = SourceFile.fromCode((String)content.getSource(), (String)content.get());
        Result result = compiler.compile(externs, (List)Lists.newArrayList((Object[])new SourceFile[]{source}), options);
        if (result.errors.length > 0) {
            throw new CompilerException(result.errors);
        }
        return new CompileResult(compiler, result);
    }

    protected List<SourceFile> buildExterns(String externs) {
        ArrayList allExterns = Lists.newArrayList();
        allExterns.add(SourceFile.fromCode((String)"externs", (String)externs));
        if (this.defaultExterns != null) {
            allExterns.addAll(this.defaultExterns);
        }
        return allExterns;
    }

    private JsResponse returnErrorResult(JsResponseBuilder builder, int statusCode, List<String> messages) {
        builder.setStatusCode(statusCode);
        builder.addErrors(messages);
        JsResponse result = builder.build();
        return result;
    }

    @Override
    public Iterable<JsContent> getJsContent(JsUriManager.JsUri jsUri, FeatureRegistry.FeatureBundle bundle) {
        jsUri = new JsUriManager.JsUri(jsUri){

            @Override
            public boolean isDebug() {
                return true;
            }
        };
        LinkedList builder = Lists.newLinkedList(this.defaultCompiler.getJsContent(jsUri, bundle));
        CompilerOptions options = this.getCompilerOptions(jsUri);
        if (options.isExternExportsEnabled()) {
            ArrayList exports = Lists.newArrayList(bundle.getApis(ApiDirective.Type.JS, true));
            Collections.sort(exports);
            String prevExport = null;
            for (String export : exports) {
                if (export.equals(prevExport)) continue;
                builder.add(JsContent.fromText("goog.exportSymbol('" + StringEscapeUtils.escapeEcmaScript((String)export) + "', " + export + ");\n", "[export-symbol]"));
                prevExport = export;
            }
        }
        return builder;
    }

    protected String makeCacheKey(String code, String externs, JsUriManager.JsUri uri, CompilerOptions options) {
        return Joiner.on((String)":").join((Object)HashUtil.checksum((byte[])code.getBytes()), (Object)HashUtil.checksum((byte[])externs.getBytes()), new Object[]{uri.getCompileMode(), uri.isDebug(), options.isExternExportsEnabled()});
    }

    private static ErrorManager getErrorManager() {
        return new BasicErrorManager(){

            protected void printSummary() {
            }

            public void println(CheckLevel checkLevel, JSError jsError) {
            }
        };
    }

    private class ClosureJSThreadFactory
    implements ThreadFactory {
        private ClosureJSThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(null, runnable, "shindigjscompiler", ClosureJsCompiler.this.compilerStackSize);
        }
    }

    private class CompilerException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final JSError[] errors;

        public CompilerException(JSError[] errors) {
            this.errors = errors;
        }

        public List<String> getErrors() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JSError error : this.errors) {
                builder.add((Object)error.toString());
            }
            return builder.build();
        }
    }
}

