/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.MessageDigest;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.shindig.common.util.HashUtil;

public class ETaggingHttpResponse
extends HttpServletResponseWrapper {
    public static final String RESPONSE_HEADER = "ETag";
    public static final String REQUEST_HEADER = "If-None-Match";
    private static final Splitter IF_NONE_MATCH_SPLITTER = Splitter.on((char)',').trimResults().trimResults(CharMatcher.is((char)'\"'));
    protected final HttpServletRequest request;
    protected final BufferServletOutputStream stream;
    protected ServletOutputStream originalStream;
    protected PrintWriter writer;
    protected boolean batching;

    public ETaggingHttpResponse(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
        this.stream = new BufferServletOutputStream();
        this.writer = null;
        this.batching = true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.originalStream == null) {
            this.originalStream = this.getResponse().getOutputStream();
        }
        if (this.isCommitted()) {
            this.batching = false;
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        this.writeToOutput();
        this.getResponse().flushBuffer();
        this.batching = false;
    }

    public void reset() {
        super.reset();
        this.writer = null;
        this.stream.reset();
        this.batching = !this.isCommitted();
    }

    public void resetBuffer() {
        super.resetBuffer();
        this.writer = null;
        this.stream.reset();
        this.batching = !this.isCommitted();
    }

    public void startStreaming() throws IOException {
        this.batching = false;
        this.writeToOutput();
    }

    protected void writeToOutput() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        byte[] bytes = this.stream.getBuffer().toByteArray();
        if (this.batching) {
            String etag = this.stream.getContentHash();
            ((HttpServletResponse)this.getResponse()).setHeader(RESPONSE_HEADER, '\"' + etag + '\"');
            if (this.etagMatches(etag)) {
                this.emitETagMatchedResult();
            } else {
                this.emitFullResponseBody(bytes);
            }
        } else if (bytes.length != 0) {
            this.originalStream.write(bytes);
            this.stream.getBuffer().clear();
        }
    }

    protected boolean etagMatches(String etag) {
        String ifNoneMatches = this.request.getHeader(REQUEST_HEADER);
        if (Strings.isNullOrEmpty((String)ifNoneMatches)) {
            return false;
        }
        return ImmutableList.copyOf((Iterable)IF_NONE_MATCH_SPLITTER.split((CharSequence)ifNoneMatches)).contains((Object)etag);
    }

    protected void emitETagMatchedResult() {
        ((HttpServletResponse)this.getResponse()).setStatus(304);
        this.getResponse().setContentLength(0);
    }

    protected void emitFullResponseBody(byte[] bytes) throws IOException {
        this.getResponse().setContentLength(bytes.length);
        this.getResponse().getOutputStream().write(bytes);
    }

    @VisibleForTesting
    class BufferServletOutputStream
    extends ServletOutputStream {
        private static final int BUFFER_INITIAL_CAPACITY = 16384;
        private MessageDigest digest = null;
        private ByteArrayBuffer buffer = new ByteArrayBuffer(16384);

        BufferServletOutputStream() {
        }

        public void write(int b) throws IOException {
            if (ETaggingHttpResponse.this.batching) {
                this.updateDigest(b);
                this.buffer.append(b);
            } else {
                ETaggingHttpResponse.this.originalStream.write(b);
            }
        }

        public ByteArrayBuffer getBuffer() {
            return this.buffer;
        }

        public void reset() {
            this.buffer.clear();
            this.digest = null;
        }

        public String getContentHash() {
            this.ensureDigestObjectExists();
            String hash = HashUtil.bytesToHex((byte[])this.digest.digest());
            this.digest = null;
            return hash;
        }

        private void updateDigest(int b) {
            this.ensureDigestObjectExists();
            this.digest.update((byte)b);
        }

        private void ensureDigestObjectExists() {
            if (this.digest == null) {
                this.digest = HashUtil.getMessageDigest();
                this.digest.update(this.buffer.toByteArray());
            }
        }
    }
}

