/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.BaseOAuthService;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAuthService
extends BaseOAuthService {
    private BaseOAuthService.EndPoint requestUrl;
    private BaseOAuthService.EndPoint accessUrl;
    private Uri authorizationUrl;
    private String name;

    OAuthService() {
    }

    public OAuthService(Element serviceElement, Uri base) throws SpecParserException {
        this.name = serviceElement.getAttribute("name");
        NodeList children = serviceElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if ("Request".equals(childName)) {
                if (this.requestUrl != null) {
                    throw new SpecParserException("Multiple OAuth/Service/Request elements");
                }
                this.requestUrl = this.parseEndPoint("OAuth/Service/Request", (Element)child, base);
                continue;
            }
            if ("Authorization".equals(childName)) {
                if (this.authorizationUrl != null) {
                    throw new SpecParserException("Multiple OAuth/Service/Authorization elements");
                }
                this.authorizationUrl = this.parseAuthorizationUrl((Element)child, base);
                continue;
            }
            if (!"Access".equals(childName)) continue;
            if (this.accessUrl != null) {
                throw new SpecParserException("Multiple OAuth/Service/Access elements");
            }
            this.accessUrl = this.parseEndPoint("OAuth/Service/Access", (Element)child, base);
        }
        if (this.requestUrl == null) {
            throw new SpecParserException("/OAuth/Service/Request is required");
        }
        if (this.accessUrl == null) {
            throw new SpecParserException("/OAuth/Service/Access is required");
        }
        if (this.authorizationUrl == null) {
            throw new SpecParserException("/OAuth/Service/Authorization is required");
        }
        if (this.requestUrl.location != this.accessUrl.location) {
            throw new SpecParserException("Access@location must be identical to Request@location");
        }
        if (this.requestUrl.method != this.accessUrl.method) {
            throw new SpecParserException("Access@method must be identical to Request@method");
        }
        if (this.requestUrl.location == BaseOAuthService.Location.BODY && this.requestUrl.method == BaseOAuthService.Method.GET) {
            throw new SpecParserException("Incompatible parameter location, cannotuse post-body with GET requests");
        }
    }

    public BaseOAuthService.EndPoint getRequestUrl() {
        return this.requestUrl;
    }

    public BaseOAuthService.EndPoint getAccessUrl() {
        return this.accessUrl;
    }

    public Uri getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

