/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.JsCompileMode;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public class DefaultJsUriManager
implements JsUriManager {
    static final String JS_HOST_PARAM = "gadgets.uri.js.host";
    static final String JS_PATH_PARAM = "gadgets.uri.js.path";
    static final JsUriManager.JsUri INVALID_URI = new JsUriManager.JsUri(UriStatus.BAD_URI);
    protected static final String JS_SUFFIX = ".js";
    protected static final String JS_DELIMITER = ":";
    private static final Logger LOG = Logger.getLogger(DefaultJsUriManager.class.getName());
    private final ContainerConfig config;
    private final JsUriManager.Versioner versioner;
    private Authority authority;

    @Inject
    public DefaultJsUriManager(ContainerConfig config, JsUriManager.Versioner versioner) {
        this.config = config;
        this.versioner = versioner;
    }

    @Inject(optional=true)
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Override
    public Uri makeExternJsUri(JsUriManager.JsUri ctx) {
        String version;
        JsCompileMode mode;
        String container = ctx.getContainer();
        String jsHost = this.getReqConfig(container, JS_HOST_PARAM);
        String jsPathBase = this.getReqConfig(container, JS_PATH_PARAM);
        UriBuilder uri = new UriBuilder(Uri.parse((String)jsHost));
        StringBuilder jsPath = new StringBuilder(jsPathBase);
        if (!jsPathBase.endsWith("/")) {
            jsPath.append('/');
        }
        jsPath.append(DefaultJsUriManager.addJsLibs(ctx.getLibs()));
        if (!ctx.getLoadedLibs().isEmpty()) {
            jsPath.append('!').append(DefaultJsUriManager.addJsLibs(ctx.getLoadedLibs()));
        }
        jsPath.append(JS_SUFFIX);
        uri.setPath(jsPath.toString());
        uri.addQueryParameter(UriCommon.Param.CONTAINER.getKey(), container);
        uri.addQueryParameter(UriCommon.Param.NO_CACHE.getKey(), ctx.isNoCache() ? "1" : "0");
        uri.addQueryParameter(UriCommon.Param.DEBUG.getKey(), ctx.isDebug() ? "1" : "0");
        uri.addQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey(), ctx.getContext().getParamValue());
        if (this.addGadgetUri()) {
            uri.addQueryParameter(UriCommon.Param.URL.getKey(), ctx.getGadget());
        }
        if (ctx.getOnload() != null) {
            uri.addQueryParameter(UriCommon.Param.ONLOAD.getKey(), ctx.getOnload());
        }
        if (ctx.isJsload()) {
            uri.addQueryParameter(UriCommon.Param.JSLOAD.getKey(), "1");
        }
        if (ctx.isNohint()) {
            uri.addQueryParameter(UriCommon.Param.NO_HINT.getKey(), "1");
        }
        if ((mode = ctx.getCompileMode()) != null && mode != JsCompileMode.getDefault()) {
            uri.addQueryParameter(UriCommon.Param.COMPILE_MODE.getKey(), mode.getParamValue());
        }
        if (ctx.cajoleContent()) {
            uri.addQueryParameter(UriCommon.Param.CAJOLE.getKey(), "1");
        }
        if (ctx.getRepository() != null) {
            uri.addQueryParameter(UriCommon.Param.REPOSITORY_ID.getKey(), ctx.getRepository());
        }
        if (this.versioner != null && !ctx.isNoCache() && (version = this.versioner.version(ctx)) != null && version.length() > 0) {
            uri.addQueryParameter(UriCommon.Param.VERSION.getKey(), version);
        }
        if (ctx.getExtensionParams() != null) {
            uri.addQueryParameters(ctx.getExtensionParams());
        }
        return uri.toUri();
    }

    @Override
    public JsUriManager.JsUri processExternJsUri(Uri uri) throws GadgetException {
        String host;
        String container = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = "default";
        }
        if ((host = uri.getAuthority()) == null) {
            this.issueUriFormatError("Unexpected: Js Uri has no host");
            return INVALID_URI;
        }
        String path = uri.getPath();
        if (path == null) {
            this.issueUriFormatError("Unexpected: Js Uri has no path");
            return INVALID_URI;
        }
        int lastSlash = (path = Utf8UrlCoder.decode((String)path)).lastIndexOf(47);
        if (lastSlash != -1) {
            path = path.substring(lastSlash + 1);
        }
        if (path.endsWith(JS_SUFFIX)) {
            path = path.substring(0, path.length() - JS_SUFFIX.length());
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] splits = StringUtils.split((String)path, (char)'!');
        Collection<String> libs = DefaultJsUriManager.getJsLibs(splits.length >= 1 ? splits[0] : "");
        String haveString = splits.length >= 2 ? splits[1] : "";
        String haveQueryParam = uri.getQueryParameter(UriCommon.Param.LOADED.getKey());
        if (haveQueryParam == null) {
            haveQueryParam = "";
        } else {
            LOG.log(Level.WARNING, "Using deprecated query param ?loaded=c:d in URL. Replace by specifying it in path as /gadgets/js/a:b!c:d.js");
        }
        haveString = haveString + JS_DELIMITER + haveQueryParam;
        Collection<String> have = DefaultJsUriManager.getJsLibs(haveString);
        UriStatus status = UriStatus.VALID_UNVERSIONED;
        String version = uri.getQueryParameter(UriCommon.Param.VERSION.getKey());
        JsUriManager.JsUri jsUri = new JsUriManager.JsUri(status, uri, libs, have);
        if (version != null && this.versioner != null && (status = this.versioner.validate(jsUri, version)) != UriStatus.VALID_UNVERSIONED) {
            jsUri = new JsUriManager.JsUri(status, jsUri);
        }
        return jsUri;
    }

    static String addJsLibs(Collection<String> extern) {
        return Joiner.on((String)JS_DELIMITER).join(extern);
    }

    static Collection<String> getJsLibs(String path) {
        return ImmutableList.copyOf((Iterable)Splitter.on((String)JS_DELIMITER).trimResults().omitEmptyStrings().split((CharSequence)path));
    }

    private String getReqConfig(String container, String key) {
        String ret = this.config.getString(container, key);
        if (ret == null && (ret = this.config.getString("default", key)) == null) {
            throw new RuntimeException("Container '" + container + "' missing config for required param: " + key);
        }
        if (this.authority != null) {
            ret = ret.replace("%authority%", this.authority.getAuthority());
        }
        return ret;
    }

    protected void issueUriFormatError(String err) throws GadgetException {
        throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, err, 400);
    }

    protected boolean addGadgetUri() {
        return false;
    }
}

