/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.component.explorer.UIConfirmMessage;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanDeleteNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotMandatoryChildNode;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={DeleteActionListener.class})})
public class DeleteManageComponent
extends UIAbstractManagerComponent {
    private static final Log LOG = ExoLogger.getLogger((String)DeleteManageComponent.class.getName());
    private static final String DELETE_FILE_CONFIRM_TITLE = "UIDeleteFileConfirmMessage";
    private static final String DELETE_FOLDER_CONFIRM_TITLE = "UIDeleteFolderConfirmMessage";
    private static final String DELETE_ITEMS_CONFIRM_TITLE = "UIDeleteItemsConfirmMessage";
    private static final int GENERIC_TYPE = 1;
    private static final int FILE_TYPE = 2;
    private static final int FOLDER_TYPE = 3;
    private static final int FOLDERS = 1;
    private static final int FILES = 2;
    private static final int FILES_AND_FOLDERS = 3;
    private static final int GENERIC = 4;
    private static final int GENERICS_AND_FOLDERS = 5;
    private static final int GENERICS_AND_FILES = 6;
    private static final int GENERICS_AND_FILES_AND_FOLDERS = 7;
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotLockedFilter(), new CanDeleteNodeFilter(), new IsNotTrashHomeNodeFilter(), new IsNotEditingDocumentFilter(), new IsNotMandatoryChildNode()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private String processRemoveMultiple(String[] nodePaths, Event<?> event) throws Exception {
        StringBuilder trashId = new StringBuilder();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        Arrays.sort(nodePaths, Collections.reverseOrder());
        for (int i = 0; i < nodePaths.length; ++i) {
            try {
                Node node = this.getNodeByPath(nodePaths[i]);
                Validate.isTrue((node != null ? 1 : 0) != 0, (String)("The ObjectId is invalid '" + nodePaths[i] + "'"));
                trashId.append(this.processRemoveOrMoveToTrash(nodePaths[i], node, event, true, true)).append(";");
                continue;
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                continue;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
        }
        return trashId.substring(0, trashId.length() - 1);
    }

    private void removeAuditForNode(Node node) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ManageableRepository repository = uiExplorer.getRepository();
        SessionProvider sessionProvider = uiExplorer.getSystemProvider();
        Session session = null;
        session = sessionProvider.getSession(node.getSession().getWorkspace().getName(), repository);
        Node rootNode = session.getRootNode();
        if (rootNode.hasNode("exo:audit") && rootNode.getNode("exo:audit").hasNode(node.getUUID())) {
            rootNode.getNode("exo:audit").getNode(node.getUUID()).remove();
            session.save();
        }
    }

    private String processRemoveOrMoveToTrash(String nodePath, Node node, Event<?> event, boolean isMultiSelect, boolean checkToMoveToTrash) throws Exception {
        String trashId;
        block8: {
            trashId = "-1";
            if (!checkToMoveToTrash || Utils.isInTrash((Node)node)) {
                this.processRemoveNode(nodePath, node, event, isMultiSelect);
                return "0";
            }
            trashId = this.moveToTrash(nodePath, node, event, isMultiSelect);
            if (!trashId.equals("-1")) {
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
                node = trashService.getNodeByTrashId(trashId);
                if (!this.isDocumentNodeType(node) && !node.getPrimaryNodeType().getName().equals("nt:file")) {
                    LinkedList<Node> queue = new LinkedList<Node>();
                    queue.add(node);
                    Node tempNode = null;
                    try {
                        while (!queue.isEmpty()) {
                            tempNode = (Node)queue.poll();
                            if (this.isDocumentNodeType(tempNode) || tempNode.getPrimaryNodeType().getName().equals("nt:file")) {
                                listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, (Object)tempNode.getParent(), (Object)tempNode);
                                continue;
                            }
                            NodeIterator iter = tempNode.getNodes();
                            while (iter.hasNext()) {
                                Node childNode = iter.nextNode();
                                if (!this.isDocumentNodeType(childNode) && !childNode.isNodeType("nt:unstructured") && !childNode.isNodeType("nt:folder")) continue;
                                queue.add(childNode);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block8;
                        LOG.warn((Object)e.getMessage());
                    }
                }
            }
        }
        return trashId;
    }

    private String moveToTrash(String srcPath, Node node, Event<?> event, boolean isMultiSelect) throws Exception {
        TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
        AuditService auditService = (AuditService)WCMCoreUtils.getService(AuditService.class);
        boolean ret = true;
        String trashId = "-1";
        String virtualNodePath = srcPath;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return trashId;
        }
        try {
            if (node.isLocked()) {
                LockUtil.removeLock((Node)node);
                node.unlock();
            }
            if (auditService.hasHistory(node)) {
                auditService.removeHistory(node);
            }
            if (node.isNodeType("exo:auditable")) {
                node.removeMixin("exo:auditable");
            }
            node.save();
            RelationsService relationService = (RelationsService)uiApp.getApplicationComponent(RelationsService.class);
            PropertyIterator iter = node.getReferences();
            while (iter.hasNext()) {
                Node refNode = iter.nextProperty().getParent();
                relationService.removeRelation(refNode, node.getPath());
            }
            if (!node.isCheckedOut()) {
                throw new VersionException("node is locked, can't move to trash node :" + node.getPath());
            }
            if (!PermissionUtil.canRemoveNode((Node)node)) {
                throw new AccessDeniedException("access denied, can't move to trash node:" + node.getPath());
            }
            SessionProvider sessionProvider = uiExplorer.getSessionProvider();
            Node currentNode = uiExplorer.getCurrentNode();
            try {
                trashId = trashService.moveToTrash(node, sessionProvider);
            }
            catch (PathNotFoundException ex) {
                ret = false;
            }
            String currentPath = LinkUtils.getExistPath((Node)currentNode, (String)uiExplorer.getCurrentPath());
            uiExplorer.setCurrentPath(currentPath);
            uiExplorer.updateAjax(event);
        }
        catch (LockException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is locked, can't move to trash node :" + node.getPath()));
            }
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.can-not-remove-locked-node", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (VersionException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is checked in, can't move to trash node:" + node.getPath()));
            }
            this.removeMixinEXO_RESTORE_LOCATION(node);
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.can-not-remove-checked-in-node", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (AccessDeniedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("access denied, can't move to trash node:" + node.getPath()));
            }
            ApplicationMessage appMessage = new ApplicationMessage("UIPopupMenu.msg.access-denied-to-delete", (Object[])new String[]{node.getPath()}, 0);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
            uiExplorer.updateAjax(event);
            ret = false;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            }
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.unexpected-error", (Object[])new String[]{node.getPath()}, 0));
            uiExplorer.updateAjax(event);
            ret = false;
        }
        if (!isMultiSelect) {
            if (uiExplorer.getCurrentPath().equals(virtualNodePath)) {
                uiExplorer.setSelectNode(LinkUtils.getParentPath((String)virtualNodePath));
            } else {
                uiExplorer.setSelectNode(uiExplorer.getCurrentPath());
            }
        }
        return ret ? trashId : "-1";
    }

    private void processRemoveNode(String nodePath, Node node, Event<?> event, boolean isMultiSelect) throws Exception {
        String virtualNodePath = nodePath;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiExplorer.getCurrentNode();
        Session session = node.getSession();
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        Node parentNode = node.getParent();
        uiExplorer.addLockToken(parentNode);
        try {
            TaxonomyService taxonomyService = (TaxonomyService)uiExplorer.getApplicationComponent(TaxonomyService.class);
            List listTaxonomyTrees = taxonomyService.getAllTaxonomyTrees();
            List listExistedTaxonomy = taxonomyService.getAllCategories(node);
            block8: for (Node existedTaxonomy : listExistedTaxonomy) {
                for (Node taxonomyTrees : listTaxonomyTrees) {
                    if (!existedTaxonomy.getPath().contains(taxonomyTrees.getPath())) continue;
                    taxonomyService.removeCategory(node, taxonomyTrees.getName(), existedTaxonomy.getPath().substring(taxonomyTrees.getPath().length()));
                    continue block8;
                }
            }
            ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
            actionService.removeAction(node, uiExplorer.getRepositoryName());
            ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
            thumbnailService.processRemoveThumbnail(node);
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
            newFolksonomyService.removeTagsOfNodeRecursively(node, uiExplorer.getRepository().getConfiguration().getDefaultWorkspaceName(), WCMCoreUtils.getRemoteUser(), this.getGroups());
            if (PermissionUtil.canRemoveNode((Node)node) && node.isNodeType("exo:auditable")) {
                this.removeAuditForNode(node);
            }
            LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            if (!node.isNodeType("exo:symlink")) {
                for (Node symlink : linkManager.getAllLinks(node, "exo:symlink")) {
                    symlink.remove();
                    symlink.getSession().save();
                }
            }
            node.remove();
            parentNode.save();
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ReferentialIntegrityException ref) {
            session.refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ConstraintViolationException cons) {
            session.refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LockException lockException) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-other-person", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        if (!isMultiSelect) {
            if (currentNode.getPath().equals(virtualNodePath)) {
                uiExplorer.setSelectNode(LinkUtils.getParentPath((String)virtualNodePath));
            } else {
                uiExplorer.setSelectNode(currentNode.getPath());
            }
        }
    }

    private void processRemoveMultiple(String[] nodePaths, String[] wsNames, Event<?> event) throws Exception {
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processRemove(nodePaths[i], wsNames[i], event, true);
        }
    }

    private void processRemove(String nodePath, String wsName, Event<?> event, boolean isMultiSelect) throws Exception {
        if (wsName == null) {
            wsName = this.getDefaultWorkspace();
        }
        this.doDelete(wsName.concat(":").concat(nodePath), event);
    }

    private String getDefaultWorkspace() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getCurrentDriveWorkspace();
    }

    public void doDelete(String nodePath, String wsName, Event<?> event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (nodePath.indexOf(";") > -1) {
            this.processRemoveMultiple(nodePath.split(";"), wsName.split(";"), event);
        } else {
            this.processRemove(nodePath, wsName, event, false);
        }
        uiExplorer.updateAjax(event);
    }

    public void doDeleteWithoutTrash(String nodePath, Event<?> event) throws Exception {
        this.doDelete(nodePath, event, false);
    }

    public void doDelete(String nodePath, Event<?> event) throws Exception {
        this.doDelete(nodePath, event, true);
    }

    public void doDelete(String nodePath, Event<?> event, boolean checkToMoveToTrash) throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class);
        ResourceBundle res = context.getApplicationResourceBundle();
        String deleteNotice = "";
        String deleteNoticeParam = "";
        String trashId = "";
        if (nodePath.indexOf(";") > -1) {
            trashId = this.processRemoveMultiple(Utils.removeChildNodes((String)nodePath), event);
            deleteNotice = checkToMoveToTrash ? "UIWorkingArea.msg.feedback-delete-multi" : "UIWorkingArea.msg.feedback-delete-permanently-multi";
            deleteNoticeParam = String.valueOf(nodePath.split(";").length);
        } else {
            UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
            try {
                Node node = this.getNodeByPath(nodePath);
                deleteNotice = checkToMoveToTrash ? "UIWorkingArea.msg.feedback-delete" : "UIWorkingArea.msg.feedback-delete-permanently";
                deleteNoticeParam = StringEscapeUtils.unescapeHtml((String)Utils.getTitle((Node)node));
                if (node != null) {
                    trashId = this.processRemoveOrMoveToTrash(node.getPath(), node, event, false, checkToMoveToTrash);
                }
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
        deleteNotice = res.getString(deleteNotice);
        deleteNotice = deleteNotice.replace("{0}", deleteNoticeParam);
        deleteNotice = deleteNotice.replace("\"", "'");
        deleteNotice = StringEscapeUtils.escapeHtml((String)deleteNotice);
        if (checkToMoveToTrash) {
            String undoLink = this.getUndoLink(trashId);
            uiWorkingArea.setDeleteNotice(deleteNotice);
            uiWorkingArea.setNodePathDelete(undoLink);
        } else {
            uiWorkingArea.setWCMNotice(deleteNotice);
        }
        uiExplorer.updateAjax(event);
    }

    private String getUndoLink(String trashId) throws Exception {
        String undoLink = "";
        TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        PortletPreferences portletPrefs = uiExplorer.getPortletPreferences();
        String trashWorkspace = portletPrefs.getValue("trashWorkspace", "");
        StringBuffer sb = new StringBuffer();
        if (trashId.indexOf(";") > -1) {
            String[] nodePaths = trashId.split(";");
            for (int i = 0; i < nodePaths.length; ++i) {
                trashId = nodePaths[i].substring(nodePaths[i].indexOf(":") + 1, nodePaths[i].length());
                sb.append(trashWorkspace).append(":").append(trashService.getNodeByTrashId(trashId).getPath()).append(";");
            }
            undoLink = sb.toString();
            if (undoLink.length() > 0) {
                undoLink = undoLink.substring(0, undoLink.length() - 1);
            }
        } else {
            trashId = trashId.substring(trashId.indexOf(":") + 1, trashId.length());
            Node tmpNode = trashService.getNodeByTrashId(trashId);
            sb.append(tmpNode.getPath()).append(";");
            undoLink = sb.toString();
            if (undoLink.length() > 0) {
                undoLink = undoLink.substring(0, undoLink.length() - 1);
                undoLink = trashWorkspace + ":" + undoLink;
            }
        }
        return undoLink;
    }

    private boolean isInTrashFolder(String nodePath) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String wsName = null;
        Session session = null;
        String[] nodePaths = nodePath.split(";");
        for (int i = 0; i < nodePaths.length; ++i) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePaths[i]);
            if (!matcher.find()) continue;
            wsName = matcher.group(1);
            nodePath = matcher.group(2);
            session = uiExplorer.getSessionByWorkspace(wsName);
            Node node = uiExplorer.getNodeByPath(nodePath, session, false);
            return Utils.isInTrash((Node)node);
        }
        return false;
    }

    private boolean isDocumentNodeType(Node node) throws Exception {
        boolean isDocument = true;
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        isDocument = templateService.getAllDocumentNodeTypes().contains(node.getPrimaryNodeType().getName());
        return isDocument;
    }

    private int getContentType(String nodePath) throws Exception {
        int content_type = 1;
        Node node = this.getNodeByPath(nodePath);
        String primaryType = node.getPrimaryNodeType().getName();
        content_type = node.isNodeType("nt:file") ? 2 : (primaryType.equals("nt:folder") || primaryType.equals("nt:unstructured") ? 3 : 1);
        return content_type;
    }

    private int getMultiContentType(String nodePath) throws Exception {
        StringBuffer sBuffer = new StringBuffer();
        String[] nodePaths = nodePath.split(";");
        boolean isGeneric = false;
        boolean isFile = false;
        boolean isFolder = false;
        for (int i = 0; i < nodePaths.length; ++i) {
            Node node = this.getNodeByPath(nodePaths[i]);
            String primaryType = node.getPrimaryNodeType().getName();
            if (node.isNodeType("nt:file")) {
                isFile = true;
                continue;
            }
            if (primaryType.equals("nt:folder") || primaryType.equals("nt:unstructured")) {
                isFolder = true;
                continue;
            }
            isGeneric = true;
        }
        if (isGeneric) {
            sBuffer.append("1");
        } else {
            sBuffer.append("0");
        }
        if (isFile) {
            sBuffer.append("1");
        } else {
            sBuffer.append("0");
        }
        if (isFolder) {
            sBuffer.append("1");
        } else {
            sBuffer.append("0");
        }
        return Integer.parseInt(sBuffer.toString(), 2);
    }

    public static void deleteManage(Event<? extends UIComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        UIConfirmMessage uiConfirmMessage = (UIConfirmMessage)uiWorkingArea.createUIComponent(UIConfirmMessage.class, null, null);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        DeleteManageComponent deleteManageComponent = (DeleteManageComponent)uiWorkingArea.getChild(DeleteManageComponent.class);
        List<String> listNodesHaveRelations = null;
        try {
            listNodesHaveRelations = DeleteManageComponent.checkRelations(nodePath, uiExplorer);
        }
        catch (PathNotFoundException pathEx) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        boolean isInTrashFolder = deleteManageComponent.isInTrashFolder(nodePath);
        uiConfirmMessage.setNodeInTrash(isInTrashFolder);
        String nodeName = nodePath;
        int contentType = 1;
        int multiContentType = 1;
        String message_key = "";
        if (nodePath.indexOf(";") > 0) {
            uiConfirmMessage.setId(DELETE_ITEMS_CONFIRM_TITLE);
            multiContentType = deleteManageComponent.getMultiContentType(nodePath);
        } else {
            Node node = deleteManageComponent.getNodeByPath(nodePath);
            if (node != null) {
                nodeName = StringEscapeUtils.unescapeHtml((String)Utils.getTitle((Node)node));
            }
            if ((contentType = deleteManageComponent.getContentType(nodePath)) == 2) {
                uiConfirmMessage.setId(DELETE_FILE_CONFIRM_TITLE);
            } else if (contentType == 3) {
                uiConfirmMessage.setId(DELETE_FOLDER_CONFIRM_TITLE);
            }
        }
        if (listNodesHaveRelations != null && listNodesHaveRelations.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < listNodesHaveRelations.size(); ++i) {
                sb.append("'").append(listNodesHaveRelations.get(i)).append("', ");
            }
            if (nodePath.indexOf(";") < 0) {
                if (contentType == 1) {
                    message_key = "UIWorkingArea.msg.confirm-delete-has-relations";
                } else if (contentType == 2) {
                    message_key = "UIWorkingArea.msg.confirm-delete-file-has-relations";
                } else if (contentType == 3) {
                    message_key = "UIWorkingArea.msg.confirm-delete-folder-has-relations";
                }
                uiConfirmMessage.setMessageKey(message_key);
                uiConfirmMessage.setArguments(new String[]{nodeName});
            } else {
                switch (multiContentType) {
                    case 1: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-folder-have-relations";
                        break;
                    }
                    case 2: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-file-have-relations";
                        break;
                    }
                    case 3: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-file-and-folder-have-relations";
                        break;
                    }
                    case 4: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-have-relations";
                        break;
                    }
                    case 5: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-folder-have-relations";
                        break;
                    }
                    case 6: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-file-have-relations";
                        break;
                    }
                    case 7: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-file-and-folder-have-relations";
                        break;
                    }
                    default: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-have-relations";
                    }
                }
                uiConfirmMessage.setMessageKey(message_key);
                uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length)});
            }
        } else if (isInTrashFolder) {
            if (nodePath.indexOf(";") > -1) {
                switch (multiContentType) {
                    case 1: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-folder-permanently";
                        break;
                    }
                    case 2: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-file-permanently";
                        break;
                    }
                    case 3: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-file-and-folder-permanently";
                        break;
                    }
                    case 4: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-permanently";
                        break;
                    }
                    case 5: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-folder-permanently";
                        break;
                    }
                    case 6: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-file-permanently";
                        break;
                    }
                    case 7: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-file-and-folder-permanently";
                        break;
                    }
                    default: {
                        message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-permanently";
                    }
                }
                uiConfirmMessage.setMessageKey(message_key);
                uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length)});
            } else {
                if (contentType == 1) {
                    message_key = "UIWorkingArea.msg.confirm-delete-permanently";
                } else if (contentType == 2) {
                    message_key = "UIWorkingArea.msg.confirm-delete-file-permanently";
                } else if (contentType == 3) {
                    message_key = "UIWorkingArea.msg.confirm-delete-folder-permanently";
                }
                uiConfirmMessage.setMessageKey(message_key);
                uiConfirmMessage.setArguments(new String[]{nodeName});
            }
        } else if (nodePath.indexOf(";") > -1) {
            switch (multiContentType) {
                case 1: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-folder";
                    break;
                }
                case 2: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-file";
                    break;
                }
                case 3: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-file-and-folder";
                    break;
                }
                case 4: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic";
                    break;
                }
                case 5: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-folder";
                    break;
                }
                case 6: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-file";
                    break;
                }
                case 7: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic-and-file-and-folder";
                    break;
                }
                default: {
                    message_key = "UIWorkingArea.msg.confirm-delete-multi-nodes-generic";
                }
            }
            uiConfirmMessage.setMessageKey(message_key);
            uiConfirmMessage.setArguments(new String[]{Integer.toString(nodePath.split(";").length)});
        } else {
            if (contentType == 1) {
                message_key = "UIWorkingArea.msg.confirm-delete";
            } else if (contentType == 2) {
                message_key = "UIWorkingArea.msg.confirm-delete-file";
            } else if (contentType == 3) {
                message_key = "UIWorkingArea.msg.confirm-delete-folder";
            }
            uiConfirmMessage.setMessageKey(message_key);
            uiConfirmMessage.setArguments(new String[]{nodeName});
        }
        uiConfirmMessage.setNodePath(nodePath);
        UIPopupWindow popUp = (UIPopupWindow)uiExplorer.getChild(UIPopupWindow.class);
        popUp.setUIComponent((UIComponent)uiConfirmMessage);
        popUp.setShowMask(true);
        popUp.setShow(true);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popUp);
    }

    private static List<String> checkRelations(String nodePath, UIJCRExplorer uiExplorer) throws Exception {
        Node node = null;
        String wsName = null;
        Session session = null;
        String[] nodePaths = nodePath.split(";");
        RelationsService rlService = (RelationsService)WCMCoreUtils.getService(RelationsService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ArrayList<String> listNodesHaveRelations = new ArrayList<String>();
        for (int i = 0; i < nodePaths.length; ++i) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePaths[i]);
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                node = uiExplorer.getNodeByPath(nodePath, session = uiExplorer.getSessionByWorkspace(wsName), false);
                if (rlService.getRelations(node, sessionProvider).size() <= 0) continue;
                listNodesHaveRelations.add(nodePath);
                continue;
            }
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        return listNodesHaveRelations;
    }

    private Node getNodeByPath(String nodePath) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        if (!matcher.find()) {
            return null;
        }
        String wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        return uiExplorer.getNodeByPath(nodePath, session, false);
    }

    private String getGroups() throws Exception {
        StringBuilder ret = new StringBuilder();
        for (String group : Utils.getGroups()) {
            ret.append(group).append(';');
        }
        ret.deleteCharAt(ret.length() - 1);
        return ret.toString();
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    private void removeMixinEXO_RESTORE_LOCATION(Node node) throws Exception {
        if (node.isNodeType("exo:restoreLocation")) {
            node.removeMixin("exo:restoreLocation");
            node.save();
        }
    }

    public static class DeleteActionListener
    extends UIWorkingAreaActionListener<DeleteManageComponent> {
        public void processEvent(Event<DeleteManageComponent> event) throws Exception {
            DeleteManageComponent.deleteManage(event);
        }
    }
}

