/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.util.List;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Properties;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.chromattic.ext.ntdef.NTFile;
import org.exoplatform.social.core.chromattic.entity.ActivityProfileEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileXpEntity;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;

@PrimaryType(name="soc:profiledefinition")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class ProfileEntity {
    public static final PropertyLiteralExpression<String> parentId = new PropertyLiteralExpression<String>(String.class, "soc:parentId");
    public static final PropertyLiteralExpression<Long> createdTime = new PropertyLiteralExpression<Long>(Long.class, "soc:createdTime");
    public static final PropertyLiteralExpression<String> firstName = new PropertyLiteralExpression<String>(String.class, "void-firstName");
    public static final PropertyLiteralExpression<String> lastName = new PropertyLiteralExpression<String>(String.class, "void-lastName");
    public static final PropertyLiteralExpression<String> fullName = new PropertyLiteralExpression<String>(String.class, "void-fullName");
    public static final PropertyLiteralExpression<String> aboutMe = new PropertyLiteralExpression<String>(String.class, "void-aboutMe");
    public static final PropertyLiteralExpression<String> position = new PropertyLiteralExpression<String>(String.class, "void-position");
    public static final PropertyLiteralExpression<String> gender = new PropertyLiteralExpression<String>(String.class, "void-gender");
    public static final PropertyLiteralExpression<String> deleted = new PropertyLiteralExpression<String>(String.class, "void-deleted");
    public static final PropertyLiteralExpression<String> skills = new PropertyLiteralExpression<String>(String.class, "index-skills");
    public static final PropertyLiteralExpression<String> positions = new PropertyLiteralExpression<String>(String.class, "index-position");
    public static final PropertyLiteralExpression<String> organizations = new PropertyLiteralExpression<String>(String.class, "index-company");
    public static final PropertyLiteralExpression<String> jobsDescription = new PropertyLiteralExpression<String>(String.class, "index-description");

    @Id
    public abstract String getId();

    @MappedBy(value="soc:avatar")
    @OneToOne
    @Owner
    public abstract NTFile getAvatar();

    public abstract void setAvatar(NTFile var1);

    @MappedBy(value="soc:profile")
    @OneToOne
    public abstract IdentityEntity getIdentity();

    public abstract void setIdentity(IdentityEntity var1);

    @MappedBy(value="soc:activityprofile")
    @OneToOne
    @Owner
    public abstract ActivityProfileEntity getActivityProfile();

    public abstract void setActivityProfile(ActivityProfileEntity var1);

    @Property(name="soc:externalUrl")
    public abstract String getExternalUrl();

    public abstract void setExternalUrl(String var1);

    @Property(name="soc:externalAvatarUrl")
    public abstract String getExternalAvatarUrl();

    public abstract void setExternalAvatarUrl(String var1);

    @Property(name="soc:parentId")
    public abstract String getParentId();

    public abstract void setParentId(String var1);

    @Property(name="soc:createdTime")
    public abstract Long getCreatedTime();

    public abstract void setCreatedTime(Long var1);

    @OneToMany
    @Owner
    public abstract Map<String, ProfileXpEntity> getXps();

    @Properties
    public abstract Map<String, List<String>> getProperties();

    @Create
    public abstract NTFile createAvatar();

    @Create
    public abstract ProfileXpEntity createXp();

    @Create
    public abstract ActivityProfileEntity createActivityProfile();

    public List<String> getProperty(String key) {
        return this.getProperties().get(key);
    }

    public void setProperty(String key, List<String> value) {
        this.getProperties().put(key, value);
    }

    public String getPropertyFirst(String key) {
        List<String> value = this.getProperties().get(key);
        return value.size() > 0 ? value.get(0) : null;
    }
}

