/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceTemplateConfigPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.picocontainer.Startable;

public class SpaceTemplateServiceImpl
implements SpaceTemplateService,
Startable {
    private static final String DEFAULT_SPACE_TEMPLATE_PARAM = "defaultSpaceTemplate";
    private static final Log LOG = ExoLogger.getLogger(SpaceTemplateServiceImpl.class);
    private Map<String, SpaceApplicationHandler> spaceApplicationHandlers = new HashMap<String, SpaceApplicationHandler>();
    private Map<String, SpaceTemplate> spaceTemplates = new HashMap<String, SpaceTemplate>();
    private Map<String, SpaceTemplate> registeredSpaceTemplates = new HashMap<String, SpaceTemplate>();
    private Map<String, SpaceTemplate> extendedSpaceTemplates = new HashMap<String, SpaceTemplate>();
    private String defaultSpaceTemplate;

    public SpaceTemplateServiceImpl(InitParams params) {
        if (params != null) {
            this.defaultSpaceTemplate = params.getValueParam(DEFAULT_SPACE_TEMPLATE_PARAM).getValue();
        }
    }

    @Override
    public List<SpaceTemplate> getSpaceTemplates() {
        return Collections.unmodifiableList(new ArrayList<SpaceTemplate>(this.spaceTemplates.values()));
    }

    @Override
    public SpaceTemplate getSpaceTemplateByName(String name) {
        SpaceTemplate template;
        if (name == null) {
            LOG.warn((Object)"Attempt to get template with null name. Falling back to default template name");
            name = this.getDefaultSpaceTemplate();
        }
        if ((template = this.spaceTemplates.get(name)) != null) {
            return template.clone();
        }
        SpaceTemplate defaultTemplate = this.spaceTemplates.get(this.getDefaultSpaceTemplate());
        return defaultTemplate.clone();
    }

    @Override
    public void registerSpaceTemplatePlugin(SpaceTemplateConfigPlugin spaceTemplateConfigPlugin) {
        SpaceTemplate spaceTemplate = spaceTemplateConfigPlugin.getSpaceTemplate();
        if (spaceTemplate == null) {
            LOG.warn((Object)"No space template found !");
            return;
        }
        this.registeredSpaceTemplates.put(spaceTemplate.getName(), spaceTemplate);
    }

    @Override
    public void extendSpaceTemplatePlugin(SpaceTemplateConfigPlugin spaceTemplateConfigPlugin) {
        SpaceTemplate spaceTemplateExtension = spaceTemplateConfigPlugin.getSpaceTemplate();
        if (spaceTemplateExtension == null || StringUtils.isBlank((String)spaceTemplateExtension.getName())) {
            LOG.warn("Space template plugin doesn't have mandatory object: {}. The plugin will be ignored.", new Object[]{spaceTemplateConfigPlugin});
            return;
        }
        this.extendedSpaceTemplates.put(spaceTemplateExtension.getName(), spaceTemplateExtension);
    }

    @Override
    public void registerSpaceApplicationHandler(SpaceApplicationHandler spaceApplicationHandler) {
        this.spaceApplicationHandlers.put(spaceApplicationHandler.getName(), spaceApplicationHandler);
    }

    @Override
    public Map<String, SpaceApplicationHandler> getSpaceApplicationHandlers() {
        return Collections.unmodifiableMap(this.spaceApplicationHandlers);
    }

    @Override
    public String getDefaultSpaceTemplate() {
        return this.defaultSpaceTemplate;
    }

    @Override
    public void initSpaceApplications(Space space, SpaceApplicationHandler spaceApplicationHandler) throws SpaceException {
        String type = space.getTemplate();
        SpaceTemplate spaceTemplate = this.getSpaceTemplateByName(type);
        spaceApplicationHandler.initApps(space, spaceTemplate);
        List<SpaceApplication> apps = spaceTemplate.getSpaceApplicationList();
        if (apps != null) {
            for (SpaceApplication spaceApplication : apps) {
                this.setApp(space, spaceApplication.getPortletName(), spaceApplication.getAppTitle(), spaceApplication.isRemovable(), "active");
            }
        }
    }

    @Override
    public void setApp(Space space, String appId, String appName, boolean isRemovable, String status) {
        String apps = space.getApp();
        String applicationStatus = appId + ":" + appName;
        applicationStatus = isRemovable ? applicationStatus + ":true" : applicationStatus + ":false";
        applicationStatus = applicationStatus + ":" + status;
        apps = apps == null ? applicationStatus : apps + "," + applicationStatus;
        space.setApp(apps);
    }

    public void start() {
        this.spaceTemplates = this.registeredSpaceTemplates;
        for (String spaceTemplateExtensionName : this.extendedSpaceTemplates.keySet()) {
            SpaceTemplate spaceTemplateExtension = this.extendedSpaceTemplates.get(spaceTemplateExtensionName);
            List<SpaceApplication> apps = spaceTemplateExtension.getSpaceApplicationList();
            SpaceTemplate toExtendSpaceTemplate = this.spaceTemplates.get(spaceTemplateExtensionName);
            if (toExtendSpaceTemplate == null) {
                LOG.warn("Can't extend Space template {} with applications {} because the space template can't be found.", new Object[]{spaceTemplateExtensionName, apps});
            }
            if (spaceTemplateExtension.getBannerPath() != null) {
                LOG.warn("Banner path defined in extension of space template {} isn't extensible", new Object[]{spaceTemplateExtensionName});
            }
            if (spaceTemplateExtension.getSpaceHomeApplication() != null) {
                LOG.warn("Space home defined in extension of space template {} isn't extensible", new Object[]{spaceTemplateExtensionName});
            }
            if (apps == null) continue;
            for (SpaceApplication application : apps) {
                toExtendSpaceTemplate.addToSpaceApplicationList(application);
            }
        }
    }

    public void stop() {
    }
}

