/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.ArrayNodePageList;
import org.exoplatform.services.wcm.search.base.EcmsSearchResult;
import org.exoplatform.services.wcm.search.base.LazyPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.search.connector.FileApplicationSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PageListFactory {
    private static final Log LOG = ExoLogger.getLogger((String)PageListFactory.class.getName());

    public static <E> AbstractPageList<E> createPageList(String queryStatement, Locale locale, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, int pageSize, int bufferSize, QueryCriteria criteria) throws RepositoryException {
        SiteSearchService siteSearchService = (SiteSearchService)WCMCoreUtils.getService(SiteSearchService.class);
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (criteria != null) {
            if (criteria.getOffset() <= 0L) {
                criteria.setOffset(0L);
                siteSearchService.clearCache(ConversationState.getCurrent().getIdentity().getUserId(), queryStatement);
            }
        } else {
            siteSearchService.clearCache(ConversationState.getCurrent().getIdentity().getUserId(), queryStatement);
        }
        List<E> results = PageListFactory.searchInJCR(queryStatement, workspace, language, isSystemSession, filter, dataCreator, criteria);
        if (criteria != null && !criteria.isSearchWebpage()) {
            results.addAll(PageListFactory.searchInES(workspace, locale, isSystemSession, filter, dataCreator, criteria));
        }
        results = new ArrayList<E>(new LinkedHashSet<E>(results));
        if (criteria != null && criteria.getOffset() > 0L) {
            results = results.subList((int)criteria.getOffset(), results.size());
        }
        return new ArrayNodePageList<E>(results, pageSize);
    }

    public static <E> AbstractPageList<E> createPageList(String queryStatement, Locale locale, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, int pageSize, int bufferSize) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return PageListFactory.createPageList(queryStatement, locale, workspace, language, isSystemSession, filter, dataCreator, pageSize, bufferSize, null);
    }

    public static <E> AbstractPageList<E> createPageList(String queryStatement, Locale locale, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return PageListFactory.createPageList(queryStatement, locale, workspace, language, isSystemSession, filter, dataCreator, 10, 100);
    }

    public static <E> AbstractPageList<E> createPageList(List<Node> nodes, int pageSize, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) {
        return new ArrayNodePageList<E>(nodes, pageSize, filter, dataCreator);
    }

    public static <E> List<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, SearchDataCreator<E> dataCreator) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        ArrayList<E> dataList;
        block3: {
            SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
            Session session = sessionProvider.getSession(workspace, WCMCoreUtils.getRepository());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryStatement, language);
            QueryResult queryResult = query.execute();
            dataList = new ArrayList<E>();
            try {
                NodeIterator nodeIterator = queryResult.getNodes();
                RowIterator rowIterator = queryResult.getRows();
                while (nodeIterator.hasNext()) {
                    E data;
                    Node node = nodeIterator.nextNode();
                    Row row = rowIterator.nextRow();
                    if (dataCreator == null || node == null || (data = dataCreator.createData(node, row, null)) == null) continue;
                    dataList.add(data);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)e.getMessage());
            }
        }
        return dataList;
    }

    public static <E> LazyPageList<E> createLazyPageList(QueryData queryData, int nodePerPage, SearchDataCreator<E> dataCreator) {
        return new LazyPageList<E>(queryData, nodePerPage, dataCreator);
    }

    protected static <E> List<E> searchInJCR(String queryStatement, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, QueryCriteria criteria) throws RepositoryException {
        ArrayList<E> dataList;
        block4: {
            SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
            Session session = sessionProvider.getSession(workspace, WCMCoreUtils.getRepository());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryStatement, language);
            long offset = criteria != null ? criteria.getOffset() : 0L;
            ((QueryImpl)query).setOffset(0L);
            ((QueryImpl)query).setLimit(offset + 100L + 1L);
            QueryResult result = query.execute();
            dataList = new ArrayList<E>();
            try {
                NodeIterator nodeIterator = result.getNodes();
                RowIterator rowIterator = result.getRows();
                while (nodeIterator.hasNext()) {
                    E data;
                    Node node = nodeIterator.nextNode();
                    Row row = rowIterator.nextRow();
                    if (filter != null) {
                        node = filter.filterNodeToDisplay(node);
                    }
                    if (dataCreator == null || node == null || (data = dataCreator.createData(node, row, null)) == null) continue;
                    dataList.add(data);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage());
            }
        }
        return dataList;
    }

    protected static <E> List<E> searchInES(String workspace, Locale locale, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, QueryCriteria criteria) throws RepositoryException {
        SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(workspace, WCMCoreUtils.getRepository());
        FileApplicationSearchServiceConnector fileSearchInternalServiceConnector = (FileApplicationSearchServiceConnector)((Object)CommonsUtils.getService(FileApplicationSearchServiceConnector.class));
        int offset = criteria != null ? (int)criteria.getOffset() : 0;
        Collection<SearchResult> results = fileSearchInternalServiceConnector.appSearch(workspace, criteria != null ? criteria.getSearchPath() : "", locale, criteria != null ? criteria.getKeyword() : "", 0, offset + 100 + 1, null, null);
        ArrayList filteredResults = new ArrayList();
        results.forEach(result -> {
            EcmsSearchResult searchResult = (EcmsSearchResult)((Object)result);
            searchResult.setRelevancy(searchResult.getRelevancy() * 1000L);
            String nodePath = searchResult.getNodePath();
            try {
                Node node = (Node)session.getItem(nodePath);
                if (node != null) {
                    if (filter != null) {
                        node = filter.filterNodeToDisplay(node);
                    }
                    filteredResults.add(dataCreator.createData(node, null, searchResult));
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Cannot get node " + nodePath), (Throwable)e);
            }
        });
        return filteredResults;
    }
}

