/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.operatordict;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorAttribute;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorForm;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class OperatorDictionary
implements Serializable {
    public static final String NAME_VERYVERYTHINMATHSPACE = "veryverythinmathspace";
    public static final String NAME_VERYTHINMATHSPACE = "verythinmathspace";
    public static final String NAME_THINMATHSPACE = "thinmathspace";
    public static final String NAME_MEDIUMMATHSPACE = "mediummathspace";
    public static final String NAME_THICKMATHSPACE = "thickmathspace";
    public static final String NAME_VERYTHICKMATHSPACE = "verythickmathspace";
    public static final String NAME_VERYVERYTHICKMATHSPACE = "veryverythickmathspace";
    public static final String NAME_INFINITY = "infinity";
    public static final String FORM_PREFIX = "prefix";
    public static final String FORM_INFIX = "infix";
    public static final String FORM_POSTFIX = "postfix";
    public static final String VALUE_UNKNOWN = "NULL";
    private static final Log LOGGER = LogFactory.getLog(OperatorDictionary.class);
    private static final long serialVersionUID = 1L;
    private static final String DICTIONARY_FILE = "/moDictionary.xml";
    private static OperatorDictionary instance;
    private final Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> dict = new EnumMap<OperatorAttribute, Map<String, Map<OperatorForm, String>>>(OperatorAttribute.class);

    private OperatorDictionary() {
        this.initializeFromXML();
    }

    public static synchronized OperatorDictionary getInstance() {
        if (instance == null) {
            OperatorDictionary operatorDictionary = null;
            try {
                InputStream inputStream = OperatorDictionary.class.getResourceAsStream("/moDictionary.ser");
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                operatorDictionary = (OperatorDictionary)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
                operatorDictionary = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                operatorDictionary = null;
            }
            catch (IOException iOException) {
                operatorDictionary = null;
            }
            catch (NullPointerException nullPointerException) {
                operatorDictionary = null;
            }
            instance = operatorDictionary == null ? new OperatorDictionary() : operatorDictionary;
        }
        return instance;
    }

    private void initializeFromXML() {
        try {
            InputStream inputStream = OperatorDictionary.class.getResourceAsStream(DICTIONARY_FILE);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(new DictionaryReader());
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warn((Object)("Cannot get SAXParser:" + parserConfigurationException.getMessage()));
        }
        catch (SAXException sAXException) {
            LOGGER.warn((Object)("SAXException while parsing dictionary:" + sAXException.getMessage()));
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Read error while accessing XML dictionary", (Throwable)iOException);
        }
    }

    public String getDefaultAttributeValue(String string, String string2, String string3) throws UnknownAttributeException {
        OperatorForm operatorForm = OperatorForm.parseOperatorForm(string2);
        return this.getDefaultAttributeValue(string, operatorForm, OperatorAttribute.parseOperatorAttribute(string3));
    }

    private String getDefaultAttributeValue(String string, OperatorForm operatorForm, OperatorAttribute operatorAttribute) {
        String string2;
        Map<String, Map<OperatorForm, String>> map = this.dict.get((Object)operatorAttribute);
        if (map == null) {
            return operatorAttribute.getDefaultValue();
        }
        Map<OperatorForm, String> map2 = map.get(string);
        if (map2 == null) {
            string2 = operatorAttribute.getDefaultValue();
        } else {
            string2 = map2.get((Object)operatorForm);
            if (string2 == null) {
                string2 = map2.get((Object)OperatorForm.INFIX);
            }
            if (string2 == null) {
                string2 = map2.get((Object)OperatorForm.POSTFIX);
            }
            if (string2 == null) {
                string2 = map2.get((Object)OperatorForm.PREFIX);
            }
            if (string2 == null) {
                string2 = operatorAttribute.getDefaultValue();
            }
        }
        return string2;
    }

    private class DictionaryReader
    extends DefaultHandler {
        private static final String ELEMENT_ELEMENT = "element";
        private String currentOperator;
        private OperatorForm currentFormIndex;
        private Map<OperatorAttribute, String> currentEntry = null;

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(ELEMENT_ELEMENT)) {
                this.currentEntry = new TreeMap<OperatorAttribute, String>();
                String string4 = attributes.getValue("form");
                if (string4 == null) {
                    LOGGER.fatal((Object)"Error in dictionary, attribute 'form' is required attribute for the dictionary");
                    this.currentFormIndex = OperatorForm.INFIX;
                } else {
                    this.currentFormIndex = OperatorForm.parseOperatorForm(string4);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string5 = attributes.getQName(i);
                    String string6 = attributes.getValue(i);
                    if (string5.equals("form")) continue;
                    try {
                        this.currentEntry.put(OperatorAttribute.parseOperatorAttribute(string5), string6);
                        continue;
                    }
                    catch (UnknownAttributeException unknownAttributeException) {
                        LOGGER.fatal((Object)unknownAttributeException.getMessage());
                    }
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(ELEMENT_ELEMENT)) {
                for (Map.Entry<OperatorAttribute, String> entry : this.currentEntry.entrySet()) {
                    EnumMap<OperatorForm, String> enumMap;
                    OperatorAttribute operatorAttribute = entry.getKey();
                    String string4 = entry.getValue();
                    TreeMap<String, EnumMap<OperatorForm, String>> treeMap = (TreeMap<String, EnumMap<OperatorForm, String>>)OperatorDictionary.this.dict.get((Object)operatorAttribute);
                    if (treeMap == null) {
                        treeMap = new TreeMap<String, EnumMap<OperatorForm, String>>();
                        OperatorDictionary.this.dict.put(operatorAttribute, treeMap);
                    }
                    if ((enumMap = (EnumMap<OperatorForm, String>)treeMap.get(this.currentOperator)) == null) {
                        enumMap = new EnumMap<OperatorForm, String>(OperatorForm.class);
                        treeMap.put(this.currentOperator, enumMap);
                    }
                    enumMap.put(this.currentFormIndex, string4);
                }
            }
            this.currentEntry = null;
            this.currentOperator = null;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentEntry != null) {
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                this.currentOperator = this.currentOperator == null ? new String(cArray2) : this.currentOperator + new String(cArray2);
                this.currentOperator = this.currentOperator.trim();
            }
        }
    }
}

