/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;

@Managed
@ManagedDescription(value="eXo Feature Service")
@NameTemplate(value={@Property(key="service", value="feature"), @Property(key="view", value="ExoFeatureService")})
@RESTEndpoint(path="featureservice")
public class ExoFeatureServiceImpl
implements ExoFeatureService {
    private static final String NAME_SPACES = "exo:";
    private SettingService settingService;

    public ExoFeatureServiceImpl(SettingService settingService) {
        this.settingService = settingService;
    }

    @Managed
    @ManagedDescription(value="Determine if the feature is active")
    @Impact(value=ImpactType.READ)
    public boolean isActiveFeature(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName) {
        SettingValue sValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + featureName);
        return sValue == null ? true : Boolean.valueOf(sValue.getValue().toString());
    }

    public void saveActiveFeature(String featureName, boolean isActive) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + featureName, SettingValue.create((Boolean)isActive));
    }

    @Managed
    @ManagedDescription(value="Activate/Deactivate feature")
    @Impact(value=ImpactType.WRITE)
    public void changeFeatureActivation(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName, @ManagedDescription(value="Is active") @ManagedName(value="isActive") String isActive) {
        boolean isActiveBool = Boolean.parseBoolean(isActive);
        this.saveActiveFeature(featureName, isActiveBool);
    }
}

