/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.InputStream;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.services.organization.idm.IntegrationCache;
import org.gatein.common.classloader.DelegatingClassLoader;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.idm.impl.cache.infinispan.InfinispanAPICacheProviderImpl;
import org.gatein.portal.idm.impl.cache.infinispan.InfinispanIdentityStoreCacheProviderImpl;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;

class InfinispanCacheFactory {
    private static final InfinispanCacheFactory INSTANCE = new InfinispanCacheFactory();
    private static final Logger log = LoggerFactory.getLogger(InfinispanCacheFactory.class);
    private EmbeddedCacheManager cacheManager;
    private boolean skipExpirationOfStructureCacheEntries = false;
    private long cacheLifespanOfLeafNodes = -1L;

    private InfinispanCacheFactory() {
    }

    public static final InfinispanCacheFactory getInstance() {
        return INSTANCE;
    }

    public void setSkipExpirationOfStructureCacheEntries(boolean skipExpirationOfStructureCacheEntries) {
        if (this.cacheManager != null && skipExpirationOfStructureCacheEntries != this.skipExpirationOfStructureCacheEntries) {
            log.warn((Object)"CacheManager is already initialized. Setting of skipExpirationOfStructureCacheEntries won't have effect");
        } else {
            this.skipExpirationOfStructureCacheEntries = skipExpirationOfStructureCacheEntries;
        }
    }

    APICacheProvider createAPICacheProvider(long staleCacheNodesLinksCleanerDelay, Cache infinispanCache) {
        InfinispanAPICacheProviderImpl apiCacheProvider = new InfinispanAPICacheProviderImpl();
        apiCacheProvider.initialize(infinispanCache, this.skipExpirationOfStructureCacheEntries, this.cacheLifespanOfLeafNodes, staleCacheNodesLinksCleanerDelay);
        return apiCacheProvider;
    }

    IntegrationCache createIntegrationCache(Cache infinispanCache) {
        IntegrationCache integrationCache = new IntegrationCache();
        integrationCache.initialize(infinispanCache, this.skipExpirationOfStructureCacheEntries, this.cacheLifespanOfLeafNodes, -1L);
        return integrationCache;
    }

    IdentityStoreCacheProvider createStoreCacheProvider(long staleCacheNodesLinksCleanerDelay, Cache infinispanCache) {
        InfinispanIdentityStoreCacheProviderImpl storeCacheProvider = new InfinispanIdentityStoreCacheProviderImpl();
        storeCacheProvider.initialize(infinispanCache, this.skipExpirationOfStructureCacheEntries, this.cacheLifespanOfLeafNodes, staleCacheNodesLinksCleanerDelay);
        return storeCacheProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cache createInfinispanCache(InputStream configStream, String portalContainerName, String apiOrStore) throws Exception {
        ClassLoader infinispanCl = EmbeddedCacheManager.class.getClassLoader();
        ClassLoader portalCl = Thread.currentThread().getContextClassLoader();
        DelegatingClassLoader delegating = new DelegatingClassLoader(new ClassLoader[]{infinispanCl, portalCl});
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)delegating);
            String cacheName = "idm-" + portalContainerName + "-" + apiOrStore;
            EmbeddedCacheManager cacheManager = this.getSharedCacheManager(configStream);
            Cache cache = cacheManager.getCache(cacheName);
            return cache;
        }
        finally {
            Thread.currentThread().setContextClassLoader(portalCl);
        }
    }

    private EmbeddedCacheManager getSharedCacheManager(InputStream configStream) throws Exception {
        if (this.cacheManager == null) {
            DefaultCacheManager cacheManager = new DefaultCacheManager(configStream, false);
            GlobalConfiguration globalConfigFromXml = cacheManager.getCacheManagerConfiguration();
            GlobalConfigurationBuilder globalConfigBuilder = new GlobalConfigurationBuilder();
            globalConfigBuilder.read(globalConfigFromXml);
            Configuration configFromXml = cacheManager.getDefaultCacheConfiguration();
            ConfigurationBuilder configBuilder = new ConfigurationBuilder().read(configFromXml);
            TransactionManagerLookup tmLookup = configFromXml.transaction().transactionManagerLookup();
            if (tmLookup == null) {
                tmLookup = this.getTransactionManagerLookup();
                configBuilder.transaction().transactionManagerLookup(tmLookup);
            }
            log.debug((Object)("Infinispan transaction manager lookup: " + tmLookup));
            if (this.skipExpirationOfStructureCacheEntries) {
                this.cacheLifespanOfLeafNodes = configFromXml.expiration().lifespan();
                configBuilder.expiration().lifespan(-1L);
                log.debug((Object)("Expiration of structure cache entries is disabled. Leaf nodes will use expiration " + this.cacheLifespanOfLeafNodes));
            }
            cacheManager = new DefaultCacheManager(globalConfigBuilder.build(), configBuilder.build(), true);
            this.cacheManager = cacheManager;
        }
        return this.cacheManager;
    }

    private TransactionManagerLookup getTransactionManagerLookup() {
        if (new J2EEServerInfo().isJBoss()) {
            return new GenericTransactionManagerLookup();
        }
        return new JBossStandaloneJTAManagerLookup();
    }
}

