/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.listeners;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.space.SpaceCustomizationService;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class CustomizeSpaceHomePageListener
extends SpaceListenerPlugin {
    private ExoProperties welcomeSCVCustomPreferences = null;
    private SpaceCustomizationService spaceCustomizationService = null;
    private Map<String, Boolean> spaceIds = new HashMap<String, Boolean>();

    public CustomizeSpaceHomePageListener(SpaceCustomizationService spaceCustomizationService_, InitParams params) {
        this.spaceCustomizationService = spaceCustomizationService_;
        this.welcomeSCVCustomPreferences = params.getPropertiesParam("welcomeSCVCustomPreferences").getProperties();
    }

    public void spaceCreated(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        this.spaceIds.put(spaceLifeCycleEvent.getSpace().getGroupId(), true);
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        String spaceGroupId = spaceLifeCycleEvent.getSpace().getGroupId();
        Boolean spaceCreated = this.spaceIds.get(spaceGroupId);
        if (spaceCreated == null || !spaceCreated.booleanValue()) {
            return;
        }
        this.spaceIds.put(spaceGroupId, false);
        String spacePrettyName = spaceLifeCycleEvent.getSpace().getPrettyName();
        this.spaceCustomizationService.createSpaceHomePage(spacePrettyName, spaceGroupId, this.welcomeSCVCustomPreferences);
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }
}

