/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.processor.I18NActivityUtils;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class RelationshipPublisher
extends RelationshipListenerPlugin {
    public static final String USER_RELATION_CONFIRMED = "user_relation_confirmed";
    public static final String SENDER_PARAM = "SENDER";
    public static final String RECEIVER_PARAM = "RECEIVER";
    public static final String RELATIONSHIP_UUID_PARAM = "RELATIONSHIP_UUID";
    public static final String RELATIONSHIP_ACTIVITY_TYPE = "exosocial:relationship";
    public static final String NUMBER_OF_CONNECTIONS = "NUMBER_OF_CONNECTIONS";
    public static final String USER_ACTIVITIES_FOR_RELATIONSHIP = "USER_ACTIVITIES_FOR_RELATIONSHIP";
    public static final String USER_COMMENTS_ACTIVITY_FOR_RELATIONSHIP = "USER_COMMENTS_ACTIVITY_FOR_RELATIONSHIP";
    public static final String USER_DISPLAY_NAME_PARAM = "USER_DISPLAY_NAME_PARAM";
    private static final Log LOG = ExoLogger.getLogger(RelationshipPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public RelationshipPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    private ExoSocialActivity createNewActivity(Identity identity, int nbOfConnections) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType(USER_ACTIVITIES_FOR_RELATIONSHIP);
        this.updateActivity(activity, nbOfConnections);
        return activity;
    }

    private ExoSocialActivity createNewComment(Identity userIdenity, String fullName) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setType(USER_COMMENTS_ACTIVITY_FOR_RELATIONSHIP);
        String message = String.format("I'm now connected with %s", fullName);
        comment.setTitle(message);
        comment.setUserId(userIdenity.getId());
        I18NActivityUtils.addResourceKeyToProcess(comment, USER_RELATION_CONFIRMED);
        I18NActivityUtils.addResourceKey(comment, USER_RELATION_CONFIRMED, fullName);
        return comment;
    }

    private void updateActivity(ExoSocialActivity activity, int numberOfConnections) {
        String title = String.format("I'm now connected with %s user(s)", numberOfConnections);
        String titleId = "user_relations";
        HashMap params = new HashMap();
        activity.setTitle(title);
        activity.setTitleId(null);
        activity.setTemplateParams(params);
        I18NActivityUtils.addResourceKey(activity, titleId, "" + numberOfConnections);
    }

    @Override
    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            Identity sender = this.identityManager.getOrCreateIdentity("organization", relationship.getSender().getRemoteId(), true);
            Identity receiver = this.identityManager.getOrCreateIdentity("organization", relationship.getReceiver().getRemoteId(), true);
            String activityIdSender = this.getIdentityStorage().getProfileActivityId(sender.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
            int nbOfSenderConnections = this.getRelationShipManager().getConnections(sender).getSize();
            String activityIdReceiver = this.getIdentityStorage().getProfileActivityId(receiver.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
            int nbOfReceiverConnections = this.getRelationShipManager().getConnections(receiver).getSize();
            String fullNameReceiver = receiver.getProfile().getFullName();
            ExoSocialActivity senderComment = this.createNewComment(sender, fullNameReceiver);
            String fullNameSender = sender.getProfile().getFullName();
            ExoSocialActivity receiverComment = this.createNewComment(receiver, fullNameSender);
            if (activityIdSender != null) {
                ExoSocialActivity activitySender = this.activityManager.getActivity(activityIdSender);
                if (activitySender != null) {
                    this.updateActivity(activitySender, nbOfSenderConnections);
                    this.activityManager.updateActivity(activitySender);
                    this.activityManager.saveComment(activitySender, senderComment);
                } else {
                    activityIdSender = null;
                }
            }
            if (activityIdSender == null) {
                ExoSocialActivity newActivitySender = this.createNewActivity(sender, nbOfSenderConnections);
                this.activityManager.saveActivityNoReturn(sender, newActivitySender);
                this.getIdentityStorage().updateProfileActivityId(sender, newActivitySender.getId(), Profile.AttachedActivityType.RELATIONSHIP);
                SpaceUtils.endRequest();
                this.activityManager.saveComment(newActivitySender, senderComment);
            }
            if (activityIdReceiver != null) {
                ExoSocialActivity activityReceiver = this.activityManager.getActivity(activityIdReceiver);
                if (activityReceiver != null) {
                    this.updateActivity(activityReceiver, nbOfReceiverConnections);
                    this.activityManager.updateActivity(activityReceiver);
                    this.activityManager.saveComment(activityReceiver, receiverComment);
                } else {
                    activityIdReceiver = null;
                }
            }
            if (activityIdReceiver == null) {
                ExoSocialActivity newActivityReceiver = this.createNewActivity(receiver, nbOfReceiverConnections);
                this.activityManager.saveActivityNoReturn(receiver, newActivityReceiver);
                this.getIdentityStorage().updateProfileActivityId(receiver, newActivityReceiver.getId(), Profile.AttachedActivityType.RELATIONSHIP);
                SpaceUtils.endRequest();
                this.activityManager.saveComment(newActivityReceiver, receiverComment);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity identity) throws Exception {
        if (identity.getId() == null || identity.getProfile().getFullName().length() == 0) {
            identity = this.identityManager.getIdentity(identity.getGlobalId().toString(), true);
        }
    }

    @Override
    public void ignored(RelationshipEvent event) {
    }

    @Override
    public void removed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            ExoSocialActivity activityReceiver;
            ExoSocialActivity activitySender;
            Identity sender = this.identityManager.getOrCreateIdentity("organization", relationship.getSender().getRemoteId(), true);
            Identity receiver = this.identityManager.getOrCreateIdentity("organization", relationship.getReceiver().getRemoteId(), true);
            String activityIdSender = this.getIdentityStorage().getProfileActivityId(sender.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
            int nbOfSenderConnections = this.getRelationShipManager().getConnections(sender).getSize();
            String activityIdReceiver = this.getIdentityStorage().getProfileActivityId(receiver.getProfile(), Profile.AttachedActivityType.RELATIONSHIP);
            int nbOfReceiverConnections = this.getRelationShipManager().getConnections(receiver).getSize();
            if (activityIdSender != null && (activitySender = this.activityManager.getActivity(activityIdSender)) != null) {
                this.updateActivity(activitySender, nbOfSenderConnections);
                this.activityManager.updateActivity(activitySender);
            }
            if (activityIdReceiver != null && (activityReceiver = this.activityManager.getActivity(activityIdReceiver)) != null) {
                this.updateActivity(activityReceiver, nbOfReceiverConnections);
                this.activityManager.updateActivity(activityReceiver);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to update relationship activity when remove connection : " + e.getMessage()));
        }
    }

    @Override
    public void denied(RelationshipEvent event) {
    }

    @Override
    public void requested(RelationshipEvent event) {
    }

    private Map<String, String> getParams(Relationship relationship) throws Exception {
        Identity sender = relationship.getSender();
        this.reloadIfNeeded(sender);
        Identity receiver = relationship.getReceiver();
        this.reloadIfNeeded(receiver);
        String senderRemoteId = sender.getRemoteId();
        String receiverRemoteId = receiver.getRemoteId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SENDER_PARAM, senderRemoteId);
        params.put(RECEIVER_PARAM, receiverRemoteId);
        params.put(RELATIONSHIP_UUID_PARAM, relationship.getId());
        return params;
    }

    private IdentityStorage getIdentityStorage() {
        return (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
    }

    private RelationshipManager getRelationShipManager() {
        return (RelationshipManager)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static enum TitleId {
        CONNECTION_REQUESTED,
        CONNECTION_CONFIRMED;

    }
}

