/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.chromattic.entity.SpaceRef;

@PrimaryType(name="soc:spaceslist")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class SpaceListEntity {
    @OneToMany
    @Owner
    @MappedBy(value="soc:refs")
    public abstract Map<String, SpaceRef> getRefs();

    @Create
    public abstract SpaceRef createRef();

    public SpaceRef getRef(String name) {
        SpaceRef ref = this.getRefs().get(name);
        if (ref == null) {
            ref = this.createRef();
            this.getRefs().put(name, ref);
        }
        return ref;
    }

    public void removeRef(String name) {
        this.getRefs().remove(name);
    }
}

