/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadgets.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class PopulateGadgetRegisryService
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(PopulateGadgetRegisryService.class);
    private static final String DEFAULT_GADGETS_CATEGORY_NAME = "Gadgets";
    private String categoryName;
    private String gadgetsCategoryAccessPermission;
    private GadgetRegistryService gadgetRegistryService;
    private ApplicationRegistryService applicationRegistryService;
    private List<Gadget> gadgets;

    public PopulateGadgetRegisryService(GadgetRegistryService gadgetRegistryService, ApplicationRegistryService applicationRegistryService, InitParams initParams) {
        this.categoryName = initParams.getValueParam("gadgetsCategoryName").getValue();
        if (this.categoryName == null) {
            this.categoryName = DEFAULT_GADGETS_CATEGORY_NAME;
            LOG.warn((Object)("Failed to retrieve " + initParams.getValueParam("gadgetsCategoryName").getName() + " init param. Default category name will be used: " + DEFAULT_GADGETS_CATEGORY_NAME));
        }
        this.gadgetsCategoryAccessPermission = initParams.getValueParam("gadgetsCategoryAccessPermission").getValue();
        if (this.gadgetsCategoryAccessPermission == null) {
            this.gadgetsCategoryAccessPermission = "Everyone";
            LOG.warn((Object)("Failed to retrieve " + initParams.getValueParam("gadgetsCategoryAccessPermission").getName() + " init param. Default access permission will be used: " + "Everyone"));
        }
        this.gadgets = initParams.getObjectParamValues(Gadget.class);
        this.gadgetRegistryService = gadgetRegistryService;
        this.applicationRegistryService = applicationRegistryService;
    }

    public void start() {
        for (Gadget gadget : this.gadgets) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                String[] permissionEntry;
                if (this.gadgetRegistryService.getGadget(gadget.getName()) == null) {
                    this.gadgetRegistryService.saveGadget(gadget);
                }
                ArrayList<String> permissions = new ArrayList<String>();
                for (String entry : permissionEntry = this.gadgetsCategoryAccessPermission.split(",")) {
                    permissions.add(entry);
                }
                Application registryApplication = new Application();
                registryApplication.setApplicationName(gadget.getName());
                registryApplication.setType(ApplicationType.GADGET);
                registryApplication.setDisplayName(gadget.getTitle());
                registryApplication.setContentId(gadget.getName());
                String description = gadget.getDescription() == null || gadget.getDescription().length() < 1 ? gadget.getName() : gadget.getDescription();
                registryApplication.setDescription(description);
                registryApplication.setAccessPermissions(permissions);
                registryApplication.setCategoryName(this.categoryName);
                if (this.applicationRegistryService.getApplicationCategory(this.categoryName) == null) {
                    ApplicationCategory category = new ApplicationCategory();
                    category.setName(this.categoryName);
                    category.setDisplayName(this.categoryName);
                    category.setDescription(this.categoryName);
                    category.setAccessPermissions(permissions);
                    this.applicationRegistryService.save(category, registryApplication);
                    continue;
                }
                this.applicationRegistryService.save(this.applicationRegistryService.getApplicationCategory(this.categoryName), registryApplication);
            }
            catch (Exception e) {
                LOG.error((Object)("Error while saving gadget: " + gadget.getName() + " with " + this.categoryName + " application category. "), (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void stop() {
    }
}

