/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.Use;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ScopeInfo {
    private boolean dynamicUsePossible;
    final int depth;
    final ScopeInfo parent;
    final Scope s;
    final Map<String, String> mapping = Maps.newLinkedHashMap();
    final List<AncestorChain<Declaration>> decls = Lists.newArrayList();
    final List<AncestorChain<FunctionConstructor>> fns = Lists.newArrayList();
    final Set<Use> uses = Sets.newLinkedHashSet();
    final List<ScopeInfo> inners = Lists.newArrayList();

    ScopeInfo(Block program, MessageQueue mq) {
        this(new ScopeInfo(), Scope.fromProgram(program, new Rewriter(mq, false, false)));
        this.dynamicUsePossible = true;
    }

    ScopeInfo(ScopeInfo parent, Scope s) {
        this.depth = parent.depth + 1;
        this.parent = parent;
        this.s = s;
        parent.inners.add(this);
        if (s.getType() == ScopeType.FUNCTION) {
            this.mapping.put("this", "this");
            this.mapping.put("arguments", "arguments");
        } else if (s.getType() == ScopeType.PROGRAM) {
            this.mapping.put("this", "this");
        }
    }

    ScopeInfo() {
        this.depth = 0;
        this.parent = null;
        this.s = null;
        this.dynamicUsePossible = true;
    }

    ScopeInfo withScope(Scope s) {
        ScopeInfo u = this;
        while (u != null && u.s != s) {
            u = u.parent;
        }
        return u;
    }

    void setDynamicUsePossible() {
        this.dynamicUsePossible = true;
    }

    boolean isDynamicUsePossible() {
        return this.dynamicUsePossible;
    }
}

