/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.Chardet;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.GuessContentType;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.js.Parser;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserContext {
    private MessageQueue mq;
    private InputSource is;
    private CharProducer cp;
    private ContentType type;
    private Charset charset;
    private InputStream inputStream;
    private String content;
    private PluginMeta meta;
    private Map<InputSource, CharSequence> sourceMap;
    private MessageContext mc;
    private boolean comments;

    public ParserContext(MessageQueue mq) {
        this(mq, InputSource.UNKNOWN, null, null, null, null, null, null, null, null, false);
    }

    private ParserContext(MessageQueue mq, InputSource is, CharProducer cp, ContentType type, Charset charset, InputStream inputStream, String content, PluginMeta meta, Map<InputSource, CharSequence> sourceMap, MessageContext mc, boolean comments) {
        this.mq = mq;
        this.is = is;
        this.cp = cp;
        this.type = type;
        this.charset = charset;
        this.inputStream = inputStream;
        this.content = content;
        this.meta = meta;
        this.sourceMap = sourceMap;
        this.mc = mc;
        this.comments = comments;
    }

    public ParserContext withInput(ContentType type) {
        return this.type != type ? new ParserContext(this.mq, this.is, this.cp, type, this.charset, this.inputStream, this.content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withInput(InputSource is) {
        return this.is != is ? new ParserContext(this.mq, is, this.cp, this.type, this.charset, this.inputStream, this.content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withInput(CharProducer cp) {
        return this.cp != cp ? new ParserContext(this.mq, this.is, cp, this.type, this.charset, this.inputStream, this.content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withConfig(MessageContext mc) {
        return this.mc != mc ? new ParserContext(this.mq, this.is, this.cp, this.type, this.charset, this.inputStream, this.content, this.meta, this.sourceMap, mc, this.comments) : this;
    }

    public ParserContext withInput(String content) {
        return this.content != content ? new ParserContext(this.mq, this.is, this.cp, this.type, this.charset, this.inputStream, content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withInput(File file) throws IOException {
        return new ParserContext(this.mq, this.is, this.cp, this.type, this.charset, new FileInputStream(file), this.content, this.meta, this.sourceMap, this.mc, this.comments);
    }

    public ParserContext withInput(InputStream inputStream) {
        return this.inputStream != inputStream ? new ParserContext(this.mq, this.is, this.cp, this.type, this.charset, inputStream, this.content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withInput(Charset charset) {
        return this.charset != charset ? new ParserContext(this.mq, this.is, this.cp, this.type, charset, this.inputStream, this.content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withInput(InputStream inputStream, Charset charset) {
        return this.inputStream != inputStream && this.charset != charset ? new ParserContext(this.mq, this.is, this.cp, this.type, charset, inputStream, this.content, this.meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withConfig(PluginMeta meta) {
        return this.meta != meta ? new ParserContext(this.mq, this.is, this.cp, this.type, this.charset, this.inputStream, this.content, meta, this.sourceMap, this.mc, this.comments) : this;
    }

    public ParserContext withSourceMap(Map<InputSource, CharSequence> sourceMap) {
        return this.sourceMap != sourceMap ? new ParserContext(this.mq, this.is, this.cp, this.type, this.charset, this.inputStream, this.content, this.meta, sourceMap, this.mc, this.comments) : this;
    }

    private static InputSource guessInputSource(InputSource is) {
        if (null == is) {
            return InputSource.UNKNOWN;
        }
        return is;
    }

    private static CharProducer guessCharProducer(CharProducer cp, String content, Map<InputSource, CharSequence> sourceMap, PluginMeta meta, InputSource is, InputStream stream, Charset charset) throws IOException {
        CharProducer candidate;
        if (null != cp) {
            return cp;
        }
        if (null != content) {
            return CharProducer.Factory.fromString((CharSequence)content, is);
        }
        if (null != sourceMap && sourceMap.containsKey(is)) {
            return CharProducer.Factory.fromString(sourceMap.get(is), is);
        }
        if (null == stream && null != is && null != (candidate = ParserContext.guessCharProducer(is, meta))) {
            return candidate;
        }
        if (null != stream) {
            Reader reader;
            if (null != charset) {
                reader = new InputStreamReader(stream, charset);
            } else {
                Pair<Reader, String> guess = Chardet.guessCharset(stream);
                reader = (Reader)guess.a;
            }
            return CharProducer.Factory.create(reader, is);
        }
        throw new IllegalStateException("Not enough arguments to create a CharProducer");
    }

    private static CharProducer guessCharProducer(InputSource is, PluginMeta meta) {
        try {
            if (null == meta) {
                return null;
            }
            FetchedData data = meta.getUriFetcher().fetch(new ExternalReference(is.getUri(), FilePosition.UNKNOWN), "*/*");
            return data.getTextualContent();
        }
        catch (UriFetcher.UriFetchException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void cacheInMessageContext(MessageContext mc, InputSource is) {
        if (null != mc) {
            mc.addInputSource(is);
        }
    }

    private static void cacheInSourceMap(Map<InputSource, CharSequence> sourceMap, InputSource is, CharProducer cp, String content) {
        if (null != sourceMap) {
            if (null == content) {
                content = cp.toString(cp.getOffset(), cp.getLength());
            }
            sourceMap.put(is, content);
        }
    }

    private ContentType guessContentType(CharProducer cp, InputSource is, ContentType type) {
        assert (null != is);
        assert (null != cp);
        if (null != type) {
            return type;
        }
        String path = is.getUri().getPath();
        return GuessContentType.guess(null, path, this.content);
    }

    private ParseTreeNode parse() throws ParseException {
        AbstractParseTreeNode input;
        if (ContentType.JS == this.type) {
            JsLexer lexer = new JsLexer(this.cp);
            JsTokenQueue tq = new JsTokenQueue(lexer, this.is);
            if (tq.isEmpty()) {
                return null;
            }
            Parser p = new Parser(tq, this.mq);
            input = p.parse();
            tq.expectEmpty();
        } else if (ContentType.CSS == this.type) {
            TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(this.cp, this.mq, false);
            if (tq.isEmpty()) {
                return null;
            }
            CssParser p = new CssParser(tq, this.mq, MessageLevel.WARNING);
            input = p.parseStyleSheet();
            tq.expectEmpty();
        } else if (ContentType.HTML == this.type) {
            DomParser p = new DomParser(new HtmlLexer(this.cp), false, this.is, this.mq);
            input = Dom.transplant(p.parseDocument());
            p.getTokenQueue().expectEmpty();
        } else {
            throw new SomethingWidgyHappenedError("Can't classify input " + this.is);
        }
        return input;
    }

    public ParseTreeNode build() throws ParseException, IllegalStateException, IOException {
        this.is = ParserContext.guessInputSource(this.is);
        this.cp = ParserContext.guessCharProducer(this.cp, this.content, this.sourceMap, this.meta, this.is, this.inputStream, this.charset);
        ParserContext.cacheInSourceMap(this.sourceMap, this.is, this.cp, this.content);
        ParserContext.cacheInMessageContext(this.mc, this.is);
        this.type = this.guessContentType(this.cp, this.is, this.type);
        ParseTreeNode node = this.parse();
        return node;
    }
}

