/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Identifier
extends AbstractParseTreeNode
implements JsonMLCompatible {
    private static final long serialVersionUID = 4119434470934007127L;
    private final String name;
    private static final Pattern GWT_IDENTIFIER_RE;

    @ParseTreeNode.ReflectiveCtor
    public Identifier(FilePosition pos, String name, List<? extends ParseTreeNode> children) {
        this(pos, name);
        assert (children.isEmpty());
    }

    public Identifier(FilePosition pos, String name) {
        super(pos);
        if (name != null && !"".equals(name) && !Identifier.isValid(name) || name != null && name.length() > 1024) {
            throw new IllegalArgumentException("Invalid identifier " + name);
        }
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void render(RenderContext r) {
        if (this.name != null) {
            switch (r.jsIdentifierSyntax()) {
                case JAVASCRIPT: {
                    if (Identifier.isValidJs(this.name)) break;
                    throw new RuntimeException("Cannot render invalid JavaScript identifier: " + this.name);
                }
                case QUASILITERAL: {
                    if (Identifier.isValidJs(this.name) || Identifier.isValidQuasiliteral(this.name)) break;
                    throw new RuntimeException("Cannot render invalid Quasiliteral identifier: " + this.name);
                }
                case GWT: {
                    if (Identifier.isValidJs(this.name) || Identifier.isValidGWT(this.name)) break;
                    throw new RuntimeException("Cannot render invalid GWT identifier: " + this.name);
                }
                default: {
                    throw new SomethingWidgyHappenedError("Unrecognized JsIdentifierSyntax enum");
                }
            }
            StringBuilder escapedName = new StringBuilder();
            if ("".equals(this.name)) {
                escapedName.append("(blank identifier)");
            } else {
                Escaping.escapeJsIdentifier((CharSequence)this.name, true, escapedName);
                r.getOut().mark(this.getFilePosition());
                r.getOut().consume(escapedName.toString());
            }
        }
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    @Override
    public JsonML toJsonML() {
        if (this.name != null) {
            return JsonMLCompatible.JsonMLBuilder.builder(TagType.IdPatt, this.getFilePosition()).setAttribute(TagAttr.NAME, this.name).build();
        }
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.Empty, this.getFilePosition()).build();
    }

    private static boolean isValid(String name) {
        return Identifier.isValidJs(name) || Identifier.isValidQuasiliteral(name) || Identifier.isValidGWT(name);
    }

    private static boolean isValidJs(String name) {
        return ParserBase.isJavascriptIdentifier(name);
    }

    private static boolean isValidQuasiliteral(String name) {
        return ParserBase.isQuasiIdentifier(name);
    }

    static boolean isValidGWT(String name) {
        return GWT_IDENTIFIER_RE.matcher(name).matches();
    }

    static {
        String letter = "(\\p{javaJavaIdentifierStart})";
        String letterOrDigit = "(\\p{javaJavaIdentifierPart})";
        String identifier = "(" + letter + letterOrDigit + "*" + ")";
        String fullClassName = "(" + identifier + "(\\." + identifier + ")*)";
        String memberReference = "(" + fullClassName + "\\:\\:" + identifier + ")";
        String fullClassTypeName = "(" + identifier + "(\\/" + identifier + ")*)";
        String simpleTypeName = "((L" + fullClassTypeName + ";)|Z|B|C|S|I|J|F|D)";
        String arrayTypeName = "((\\[)*" + simpleTypeName + ")";
        String methodReference = "(" + memberReference + "\\(" + arrayTypeName + "*\\))";
        String gwtIdentifier = "^@(" + memberReference + "|" + methodReference + ")$";
        GWT_IDENTIFIER_RE = Pattern.compile(gwtIdentifier);
    }
}

