/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.OAuth2Utils;

public class OAuth2NormalizedRequest
extends HashMap<String, Object> {
    private static final long serialVersionUID = -7849581704967135322L;
    private HttpServletRequest httpReq = null;
    private static final Pattern FORM_URL_REGEX = Pattern.compile("application/(x-www-)?form-url(-)?encoded");
    private static final String classname = OAuth2NormalizedRequest.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    public OAuth2NormalizedRequest(HttpServletRequest request) throws OAuth2Exception {
        Matcher match;
        this.setHttpServletRequest(request);
        String contentType = request.getContentType();
        if (contentType != null && (match = FORM_URL_REGEX.matcher(contentType)).matches()) {
            this.normalizeBody(this.getBodyAsString(request));
        }
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.put(key, request.getParameter(key));
        }
        this.normalizeClientSecret(request);
        this.normalizeAccessToken(request);
    }

    public String getClientId() {
        return this.getString("client_id");
    }

    public String getClientSecret() {
        return this.getString("client_secret");
    }

    public String getResponseType() {
        return this.getString("response_type");
    }

    public String getGrantType() {
        return this.getString("grant_type");
    }

    public String getRedirectURI() {
        return this.getString("redirect_uri");
    }

    public String getAccessToken() {
        return this.getString("access_token");
    }

    public String getAuthorizationCode() {
        return this.getString("code");
    }

    public String getState() {
        return this.getString("state");
    }

    public String getScope() {
        return this.getString("scope");
    }

    public OAuth2Types.ResponseType getEnumeratedResponseType() throws OAuth2Exception {
        String respType = this.getResponseType();
        if (respType == null) {
            return null;
        }
        if (respType.equals("code")) {
            return OAuth2Types.ResponseType.CODE;
        }
        if (respType.equals("token")) {
            return OAuth2Types.ResponseType.TOKEN;
        }
        OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
        resp.setError(OAuth2Types.ErrorType.UNSUPPORTED_RESPONSE_TYPE.toString());
        resp.setErrorDescription("Unsupported response type");
        resp.setStatus(302);
        resp.setBodyReturned(false);
        resp.setHeader("Location", OAuth2Utils.buildUrl(this.getRedirectURI(), resp.getResponseParameters(), null));
        throw new OAuth2Exception(resp);
    }

    public OAuth2Types.GrantType getEnumeratedGrantType() {
        String grantType = this.getGrantType();
        if (grantType == null) {
            return null;
        }
        if (grantType.equals("refresh_token")) {
            return OAuth2Types.GrantType.REFRESH_TOKEN;
        }
        if (grantType.equals("authorization_code")) {
            return OAuth2Types.GrantType.AUTHORIZATION_CODE;
        }
        if (grantType.equals("password")) {
            return OAuth2Types.GrantType.PASSWORD;
        }
        if (grantType.equals("client_credentials")) {
            return OAuth2Types.GrantType.CLIENT_CREDENTIALS;
        }
        return OAuth2Types.GrantType.CUSTOM;
    }

    public String getString(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return (String)this.get(key);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.keySet()) {
            sb.append(key);
            sb.append(": ");
            sb.append(this.get(key));
            sb.append('\n');
        }
        return sb.toString();
    }

    private void normalizeAccessToken(HttpServletRequest req) {
        String header;
        String bearerToken = this.getString("access_token");
        if ((bearerToken == null || bearerToken.equals("")) && (header = req.getHeader("Authorization")) != null && header.toLowerCase().startsWith("bearer")) {
            String[] parts = header.split("[ \\t]+");
            bearerToken = parts[parts.length - 1];
        }
        this.put("access_token", bearerToken);
    }

    private void normalizeClientSecret(HttpServletRequest request) throws OAuth2Exception {
        String header;
        String secret = this.getClientSecret();
        if ((secret == null || secret.equals("")) && (header = request.getHeader("Authorization")) != null && header.toLowerCase().startsWith("basic")) {
            String[] parts = header.split("[ \\t]+");
            String temp = parts[parts.length - 1];
            byte[] decodedSecret = Base64.decodeBase64((String)temp);
            try {
                temp = new String(decodedSecret, "UTF-8");
                parts = temp.split(":");
                if (parts != null && parts.length == 2) {
                    secret = parts[1];
                    String queryId = this.getString("client_id");
                    if (queryId != null && !queryId.equals(parts[0])) {
                        OAuth2NormalizedResponse response = new OAuth2NormalizedResponse();
                        response.setError(OAuth2Types.ErrorType.INVALID_REQUEST.toString());
                        response.setErrorDescription("Request contains mismatched client ids");
                        response.setStatus(403);
                        throw new OAuth2Exception(response);
                    }
                    if (queryId == null) {
                        this.put("client_id", parts[0]);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.logp(Level.WARNING, classname, "normalizeClientSecret", "invalidOauth", e);
                return;
            }
        }
        this.put("client_secret", secret);
    }

    private void normalizeBody(String body) throws OAuth2Exception {
        if (body == null || body.length() == 0) {
            return;
        }
        try {
            List params = URLEncodedUtils.parse((URI)new URI("http://localhost:8080?" + body), (String)"UTF-8");
            for (NameValuePair param : params) {
                this.put(param.getName(), param.getValue());
            }
        }
        catch (URISyntaxException e) {
            OAuth2NormalizedResponse response = new OAuth2NormalizedResponse();
            response.setError(OAuth2Types.ErrorType.INVALID_REQUEST.toString());
            response.setErrorDescription("The message body's syntax is incorrect");
            response.setStatus(403);
            throw new OAuth2Exception(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBodyAsString(HttpServletRequest request) {
        String string;
        if (request.getContentLength() == 0) {
            return "";
        }
        ServletInputStream is = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            is = request.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            is.close();
            string = sb.toString();
        }
        catch (IOException ioe) {
            String string2;
            try {
                LOG.logp(Level.WARNING, classname, "getBodyAsString", "invalidOauth", ioe);
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    public void setHttpServletRequest(HttpServletRequest httpReq) {
        this.httpReq = httpReq;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpReq;
    }
}

