/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.atom;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.shindig.social.core.util.atom.AtomAuthor;
import org.apache.shindig.social.core.util.atom.AtomContent;
import org.apache.shindig.social.core.util.atom.AtomGenerator;
import org.apache.shindig.social.core.util.atom.AtomLink;
import org.apache.shindig.social.core.util.atom.AtomSource;
import org.apache.shindig.social.core.util.atom.AtomSummary;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.model.Person;

public class AtomEntry {
    private String id;
    private String title;
    private AtomSummary summary;
    private String icon;
    private AtomSource source;
    private AtomGenerator generator;
    private AtomAuthor author;
    private Date updated;
    private AtomLink link;
    private Object content;

    public AtomEntry() {
    }

    public AtomEntry(Object o) {
        Object oCopy = o;
        if (o instanceof Map.Entry) {
            o = ((Map.Entry)o).getValue();
        }
        if (o instanceof Person) {
            Person person = (Person)o;
            this.content = new AtomContent(person);
            this.id = "urn:guid:" + person.getId();
            this.updated = person.getUpdated();
        } else if (o instanceof Activity) {
            Activity activity = (Activity)o;
            this.content = new AtomContent(activity);
            this.title = activity.getTitle();
            this.summary = new AtomSummary(activity.getBody());
            this.link = new AtomLink("self", activity.getUrl());
            this.icon = activity.getStreamFaviconUrl();
            this.source = new AtomSource(activity);
            this.generator = new AtomGenerator(activity);
            this.author = new AtomAuthor(activity);
            this.updated = activity.getUpdated();
        } else if (o instanceof ActivityEntry) {
            ActivityEntry activity = (ActivityEntry)o;
            this.id = activity.getId();
            this.title = activity.getTitle();
            this.summary = new AtomSummary(activity.getObject().getSummary());
            this.link = new AtomLink("alternate", activity.getObject().getUrl());
            this.author = new AtomAuthor(activity);
            this.content = new AtomContent(activity);
            try {
                this.updated = new SimpleDateFormat().parse(activity.getPublished());
            }
            catch (ParseException e) {}
        } else if (oCopy instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)oCopy;
            this.id = (String)e.getKey();
            this.content = new AtomContent(e.getValue());
        } else {
            this.content = o;
        }
    }
}

