/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.gadget.core.CharResponseWrapper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.proxy.ProxyFilterService;

public class ProxyServletFilter
implements Filter {
    private ServletContext ctx;
    private static final Log logger = ExoLogger.getLogger(ProxyServletFilter.class);

    public void init(FilterConfig cfg) throws ServletException {
        this.ctx = cfg.getServletContext();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        HttpServletResponse hresp = (HttpServletResponse)resp;
        String url = hreq.getParameter("url");
        if (url == null) {
            hresp.sendError(500, "No URL");
        } else {
            PortalContainer container = PortalContainer.getInstance((ServletContext)this.ctx);
            if (container == null) {
                hresp.sendError(500, "Could not access container for servlet context " + this.ctx.getContextPath());
            } else {
                ProxyFilterService service = (ProxyFilterService)container.getComponentInstanceOfType(ProxyFilterService.class);
                if (service == null) {
                    hresp.sendError(500, "Could not access proxy filter service " + this.ctx.getContextPath());
                } else {
                    try {
                        URI uri = URI.create(url);
                        if (!service.accept(hreq, container, uri)) {
                            hresp.sendError(403, "Gadget " + url + " is blacklisted");
                        } else {
                            CharResponseWrapper responseWrapper = new CharResponseWrapper((HttpServletResponse)resp);
                            chain.doFilter(req, (ServletResponse)responseWrapper);
                            if (resp != null && hresp.getStatus() >= 400) {
                                logger.debug("The error response code sent by gadget proxy servlet is {}", new Object[]{hresp.getStatus()});
                                hresp.setStatus(400);
                                hresp.setContentLength(0);
                                hresp.getOutputStream().write("".getBytes());
                            } else {
                                PrintWriter responseWrapperWriter = responseWrapper.getWriter();
                                responseWrapperWriter.flush();
                                byte[] bytes = responseWrapper.getByteArray();
                                hresp.setContentLength(bytes.length);
                                hresp.getWriter().write(new String(bytes));
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        logger.debug("Invalid URL: {}", new Object[]{url});
                    }
                }
            }
        }
    }

    public void destroy() {
    }
}

