/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContainer;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateList;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UITemplateEditForm
extends UIForm {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_ISTEMPLATE = "isDocumentTemplate";
    private static String nodeType_;

    public UITemplateEditForm() {
        this.addChild((UIComponent)new UIFormStringInput(FIELD_NAME, null));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_LABEL, null));
        this.addChild((UIComponent)new UICheckBoxInput(FIELD_ISTEMPLATE, null, null));
    }

    private boolean isDocumentTemplate(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getDocumentTemplates().contains(nodeType);
    }

    public void update(String nodeType) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        Node node = tempService.getTemplatesHome(WCMCoreUtils.getSystemSessionProvider()).getNode(nodeType);
        String label = null;
        if (node.hasProperty(FIELD_LABEL)) {
            label = node.getProperty(FIELD_LABEL).getString();
        }
        this.getUICheckBoxInput(FIELD_ISTEMPLATE).setChecked(this.isDocumentTemplate(nodeType));
        this.getUIStringInput(FIELD_NAME).setValue((Object)nodeType);
        this.getUIStringInput(FIELD_LABEL).setValue((Object)label);
        this.getUICheckBoxInput(FIELD_ISTEMPLATE).setDisabled(true);
        this.getUIStringInput(FIELD_NAME).setDisabled(true);
        nodeType_ = nodeType;
    }

    public static class CancelActionListener
    extends EventListener<UITemplateEditForm> {
        public void execute(Event<UITemplateEditForm> event) throws Exception {
            UITemplatesManager uiManager = (UITemplatesManager)((UITemplateEditForm)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChildById("TemplateContainerPopup");
            uiPopupWindow.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class SaveActionListener
    extends EventListener<UITemplateEditForm> {
        public void execute(Event<UITemplateEditForm> event) throws Exception {
            UITemplateEditForm uiForm = (UITemplateEditForm)((Object)event.getSource());
            TemplateService tempService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            Node node = tempService.getTemplatesHome(WCMCoreUtils.getSystemSessionProvider()).getNode(nodeType_);
            node.setProperty(UITemplateEditForm.FIELD_LABEL, (String)uiForm.getUIStringInput(UITemplateEditForm.FIELD_LABEL).getValue());
            node.save();
            uiForm.reset();
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            UITemplateContainer uiTemplateContainer = (UITemplateContainer)uiManager.getChildById(uiManager.getSelectedTabId());
            UITemplateList uiList = (UITemplateList)uiTemplateContainer.getChild(UITemplateList.class);
            uiList.refresh(uiList.getUIPageIterator().getCurrentPage());
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChildById("TemplateContainerPopup");
            uiPopupWindow.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

