/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/organization/webui/component/UIGroupMembershipSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ChangeNodeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMembershipActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectPathActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeGroupSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UITree.ChangeNodeActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UIBreadcumbs.SelectPathActionListener.class})})})
@Serialized
public class UIGroupMembershipSelector
extends UIContainer {
    private OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    private UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
    private Group selectGroup_;
    private List<String> listMemberhip;

    public UIGroupMembershipSelector() throws Exception {
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.addChild(UIBreadcumbs.class, "BreadcumbGroupSelector", "BreadcumbGroupSelector");
        UITree tree = (UITree)this.addChild(UITree.class, "UITreeGroupSelector", "TreeGroupSelector");
        tree.setIcon("GroupAdminIcon");
        tree.setSelectedIcon("PortalIcon");
        tree.setBeanIdField("id");
        tree.setBeanLabelField("label");
        tree.setEscapeHTML(true);
        uiBreadcumbs.setBreadcumbsStyle("UIExplorerHistoryPath");
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UITree tree = (UITree)this.getChild(UITree.class);
        if (tree != null && tree.getSibbling() == null) {
            tree.setSibbling(this.getChildrenGroups(null));
        }
        List memberships = (List)this.organizationService.getMembershipTypeHandler().findMembershipTypes();
        memberships.sort(Comparator.comparing(MembershipType::getName));
        this.listMemberhip = new LinkedList<String>();
        boolean containWildcard = false;
        for (MembershipType mt : memberships) {
            this.listMemberhip.add(mt.getName());
            if (!"*".equals(mt.getName())) continue;
            containWildcard = true;
        }
        if (!containWildcard) {
            ((LinkedList)this.listMemberhip).addFirst("*");
        }
        super.processRender(context);
    }

    public Group getCurrentGroup() {
        return this.selectGroup_;
    }

    public void changeGroup(String groupId) throws Exception {
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        uiBreadcumb.setPath(this.getPath(null, groupId));
        UITree tree = (UITree)this.getChild(UITree.class);
        if (groupId == null) {
            tree.setSibbling(this.getChildrenGroups(null));
            tree.setChildren(null);
            tree.setSelected(null);
            this.selectGroup_ = null;
            return;
        }
        this.selectGroup_ = this.organizationService.getGroupHandler().findGroupById(groupId);
        String parentGroupId = null;
        if (this.selectGroup_ != null) {
            parentGroupId = this.selectGroup_.getParentId();
        }
        Group parentGroup = null;
        if (parentGroupId != null) {
            parentGroup = this.organizationService.getGroupHandler().findGroupById(parentGroupId);
        }
        tree.setSibbling(this.getChildrenGroups(parentGroup));
        tree.setChildren(this.getChildrenGroups(this.selectGroup_));
        tree.setSelected((Object)this.selectGroup_);
        tree.setParentSelected((Object)parentGroup);
    }

    protected List<Group> getChildrenGroups(Group parentGroup) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null) {
            return this.organizationService.getGroupHandler().findGroups(parentGroup).stream().filter(group -> this.userACL.hasPermission(conversationState.getIdentity(), group, "default")).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> list, String id) throws Exception {
        if (list == null) {
            list = new ArrayList<UIBreadcumbs.LocalPath>(5);
        }
        if (id == null) {
            return list;
        }
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Group group = service.getGroupHandler().findGroupById(id);
        if (group == null) {
            return list;
        }
        list.add(0, new UIBreadcumbs.LocalPath(group.getId(), group.getLabel()));
        this.getPath(list, group.getParentId());
        return list;
    }

    public List<String> getListMemberhip() {
        return this.listMemberhip;
    }

    public String event(String name, String beanId) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), beanId);
        }
        return super.event(name, beanId);
    }

    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIGroupMembershipSelector uiSelector = (UIGroupMembershipSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiSelector.changeGroup(selectGroupId);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            uiPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class SelectMembershipActionListener
    extends EventListener<UIGroupMembershipSelector> {
        public void execute(Event<UIGroupMembershipSelector> event) throws Exception {
            UIGroupMembershipSelector uiSelector = (UIGroupMembershipSelector)((Object)event.getSource());
            UIComponent uiPermission = uiSelector.getParent().getParent();
            uiPermission.setRenderSibling(uiPermission.getClass());
            WebuiRequestContext pcontext = event.getRequestContext();
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            UIForm uiForm = (UIForm)uiSelector.getAncestorOfType(UIForm.class);
            if (uiSelector.getCurrentGroup() == null) {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIGroupMembershipSelector.msg.selectGroup", null));
                uiPopup.setShow(true);
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPermission);
            uiPermission.broadcast(event, event.getExecutionPhase());
            uiPopup.setShow(false);
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            UIComponent uiComp = (UIComponent)event.getSource();
            UIGroupMembershipSelector uiSelector = (UIGroupMembershipSelector)uiComp.getParent();
            uiSelector.changeGroup(groupId);
            UIComponent uiPermission = uiSelector.getParent().getParent();
            uiPermission.setRenderSibling(uiPermission.getClass());
            uiPermission.broadcast(event, Event.Phase.PROCESS);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            uiPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

